/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.remoting.management.ManagementRemotingServices;
import org.jboss.as.server.mgmt.NativeManagementResourceDefinition;
import org.jboss.as.server.operations.NativeManagementAddHandler;
import org.jboss.dmr.ModelNode;

public class NativeManagementWriteAttributeHandler
extends AbstractWriteAttributeHandler<Void> {
    public static OperationStepHandler INSTANCE = new NativeManagementWriteAttributeHandler();

    private NativeManagementWriteAttributeHandler() {
        super(NativeManagementResourceDefinition.ATTRIBUTE_DEFINITIONS);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
                if (model.hasDefined(NativeManagementResourceDefinition.INTERFACE.getName()) && model.hasDefined(NativeManagementResourceDefinition.SOCKET_BINDING.getName())) {
                    ModelNode failure = new ModelNode().set(String.format("%s cannot be defined when %s is also defined", NativeManagementResourceDefinition.INTERFACE.getName(), NativeManagementResourceDefinition.SOCKET_BINDING.getName()));
                    throw new OperationFailedException(failure);
                }
            }
        }, OperationContext.Stage.MODEL);
        super.execute(context, operation);
    }

    protected boolean requiresRuntime(OperationContext context) {
        return !context.isBooting();
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        ModelNode subModel = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
        context.addStep((OperationStepHandler)verificationHandler, OperationContext.Stage.VERIFY);
        this.installNativeManagementService(context, subModel, verificationHandler);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        ModelNode subModel = context.readResource(PathAddress.EMPTY_ADDRESS).getModel().clone();
        subModel.get(attributeName).set(valueToRestore);
        this.installNativeManagementService(context, subModel, null);
    }

    private void installNativeManagementService(OperationContext context, ModelNode subModel, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        ModelNode portNode = NativeManagementResourceDefinition.NATIVE_PORT.resolveModelAttribute(context, subModel);
        int port = portNode.isDefined() ? portNode.asInt() : 0;
        ManagementRemotingServices.removeConnectorServices((OperationContext)context, (String)"management");
        NativeManagementAddHandler.installNativeManagementConnector(context, subModel, ManagementRemotingServices.MANAGEMENT_ENDPOINT, context.getServiceTarget(), verificationHandler, null);
    }
}

