/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.controller.interfaces.InterfaceCriteria;
import org.jboss.as.controller.interfaces.ParsedInterfaceCriteria;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.server.ServerLogger;
import org.jboss.as.server.ServerMessages;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class NetworkInterfaceService
implements Service<NetworkInterfaceBinding> {
    private static Logger log = Logger.getLogger((String)"org.jboss.as.server.net");
    public static final ServiceName JBOSS_NETWORK_INTERFACE = ServiceName.JBOSS.append(new String[]{"network"});
    private static final boolean preferIPv4Stack = Boolean.getBoolean("java.net.preferIPv4Stack");
    private static final boolean preferIPv6Stack = Boolean.getBoolean("java.net.preferIPv6Addresses");
    private static final String IPV4_ANYLOCAL = "0.0.0.0";
    private static final String IPV6_ANYLOCAL = "::";
    private NetworkInterfaceBinding interfaceBinding;
    private final String name;
    private final boolean anyLocalV4;
    private final boolean anyLocalV6;
    private final boolean anyLocal;
    private final InterfaceCriteria criteria;

    public static Service<NetworkInterfaceBinding> create(String name, ParsedInterfaceCriteria criteria) {
        return new NetworkInterfaceService(name, criteria.isAnyLocalV4(), criteria.isAnyLocalV6(), criteria.isAnyLocal(), new OverallInterfaceCriteria(criteria.getCriteria()));
    }

    public NetworkInterfaceService(String name, boolean anyLocalV4, boolean anyLocalV6, boolean anyLocal, InterfaceCriteria criteria) {
        this.name = name;
        this.anyLocalV4 = anyLocalV4;
        this.anyLocalV6 = anyLocalV6;
        this.anyLocal = anyLocal;
        this.criteria = criteria;
    }

    public synchronized void start(StartContext arg0) throws StartException {
        log.debug((Object)"Starting NetworkInterfaceService\n");
        try {
            this.interfaceBinding = NetworkInterfaceService.createBinding(this.anyLocalV4, this.anyLocalV6, this.anyLocal, this.criteria);
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
        if (this.interfaceBinding == null) {
            throw ServerMessages.MESSAGES.failedToResolveInterface(this.name);
        }
        log.debugf("NetworkInterfaceService matched interface binding: %s\n", (Object)this.interfaceBinding);
    }

    public static NetworkInterfaceBinding createBinding(ParsedInterfaceCriteria criteria) throws SocketException, UnknownHostException {
        return NetworkInterfaceService.createBinding(criteria.isAnyLocalV4(), criteria.isAnyLocalV6(), criteria.isAnyLocal(), new OverallInterfaceCriteria(criteria.getCriteria()));
    }

    static NetworkInterfaceBinding createBinding(boolean anyLocalV4, boolean anyLocalV6, boolean anyLocal, InterfaceCriteria criteria) throws SocketException, UnknownHostException {
        if (anyLocalV4) {
            return NetworkInterfaceService.getNetworkInterfaceBinding(IPV4_ANYLOCAL);
        }
        if (anyLocalV6) {
            return NetworkInterfaceService.getNetworkInterfaceBinding(IPV6_ANYLOCAL);
        }
        if (anyLocal) {
            return NetworkInterfaceService.getNetworkInterfaceBinding(preferIPv4Stack ? IPV4_ANYLOCAL : IPV6_ANYLOCAL);
        }
        return NetworkInterfaceService.resolveInterface(criteria);
    }

    public synchronized void stop(StopContext arg0) {
        this.interfaceBinding = null;
    }

    public synchronized NetworkInterfaceBinding getValue() throws IllegalStateException {
        NetworkInterfaceBinding binding = this.interfaceBinding;
        if (binding == null) {
            throw new IllegalStateException();
        }
        return binding;
    }

    static NetworkInterfaceBinding resolveInterface(InterfaceCriteria criteria) throws SocketException {
        NetworkInterfaceBinding result = null;
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        log.tracef("resolveInterface, checking criteria: %s\n", (Object)criteria);
        while (result == null && networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            result = NetworkInterfaceService.resolveInterface(criteria, networkInterface);
            if (result != null) continue;
            Enumeration<NetworkInterface> subInterfaces = networkInterface.getSubInterfaces();
            while (result == null && subInterfaces.hasMoreElements()) {
                NetworkInterface subInterface = subInterfaces.nextElement();
                result = NetworkInterfaceService.resolveInterface(criteria, subInterface);
            }
        }
        return result;
    }

    private static NetworkInterfaceBinding resolveInterface(InterfaceCriteria criteria, NetworkInterface networkInterface) throws SocketException {
        log.tracef("resolveInterface, checking NetworkInterface: %s\n", (Object)NetworkInterfaceService.toString(networkInterface));
        Enumeration<InetAddress> interfaceAddresses = networkInterface.getInetAddresses();
        while (interfaceAddresses.hasMoreElements()) {
            InetAddress address = interfaceAddresses.nextElement();
            if (preferIPv4Stack && !preferIPv6Stack && !(address instanceof Inet4Address) || preferIPv6Stack && !preferIPv4Stack && !(address instanceof Inet6Address)) continue;
            log.tracef("Checking interface(name=%s,address=%s), criteria=%s\n", (Object)networkInterface.getName(), (Object)address, (Object)criteria);
            InetAddress bindAddress = criteria.isAcceptable(networkInterface, address);
            if (bindAddress == null) continue;
            log.tracef("Criteria provided bind address: %s\n", (Object)bindAddress);
            return new NetworkInterfaceBinding(Collections.singleton(networkInterface), bindAddress);
        }
        return null;
    }

    static NetworkInterfaceBinding getNetworkInterfaceBinding(String addr) throws UnknownHostException, SocketException {
        InetAddress address = InetAddress.getByName(addr);
        ArrayList<NetworkInterface> interfaces = new ArrayList<NetworkInterface>();
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            interfaces.add(networkInterfaces.nextElement());
        }
        return new NetworkInterfaceBinding(interfaces, address);
    }

    static String toString(NetworkInterface iface) {
        StringBuilder sb = new StringBuilder("NetworkInterface(");
        sb.append("name:");
        sb.append(iface.getName());
        sb.append("(");
        sb.append(iface.getDisplayName());
        sb.append("), addresses:");
        sb.append(iface.getInterfaceAddresses());
        return sb.toString();
    }

    static final class OverallInterfaceCriteria
    implements InterfaceCriteria {
        private static final long serialVersionUID = -5417786897309925997L;
        private final Set<InterfaceCriteria> interfaceCriteria;

        public OverallInterfaceCriteria(Set<InterfaceCriteria> criteria) {
            this.interfaceCriteria = criteria;
        }

        public InetAddress isAcceptable(NetworkInterface networkInterface, InetAddress address) throws SocketException {
            HashSet<InetAddress> addresses = new HashSet<InetAddress>();
            for (InterfaceCriteria criteria : this.interfaceCriteria) {
                InetAddress bindAddress = criteria.isAcceptable(networkInterface, address);
                if (bindAddress == null) {
                    log.debugf("Criteria(%s) failed to accept input\n", (Object)criteria);
                    return null;
                }
                log.tracef("%s accepted input, provided bind address: %s", (Object)criteria, (Object)bindAddress);
                addresses.add(bindAddress);
            }
            log.debugf("Candidate accepted addresses are: %s\n", addresses);
            InetAddress bindAddress = null;
            if (addresses.size() > 0) {
                log.tracef("Determining unique address from among: %s\n", (Object)addresses.toString());
                if (addresses.size() == 1) {
                    bindAddress = (InetAddress)addresses.iterator().next();
                } else if (addresses.size() > 2) {
                    ServerLogger.ROOT_LOGGER.moreThanTwoUniqueCriteria(addresses.toString());
                } else {
                    ServerLogger.ROOT_LOGGER.checkingTwoUniqueCriteria(addresses.toString());
                    addresses.remove(address);
                    if (addresses.size() == 1) {
                        bindAddress = (InetAddress)addresses.iterator().next();
                    } else {
                        ServerLogger.ROOT_LOGGER.twoUniqueCriteriaAddresses(addresses.toString());
                    }
                }
            }
            return bindAddress;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("OverallInterfaceCriteria(");
            for (InterfaceCriteria criteria : this.interfaceCriteria) {
                sb.append(criteria.toString());
                sb.append(",");
            }
            sb.setLength(sb.length() - 1);
            sb.append(")");
            return sb.toString();
        }
    }
}

