/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import org.jboss.as.server.ServerLogger;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.AttachmentList;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.deploymentoverlay.service.ContentService;
import org.jboss.as.server.deploymentoverlay.service.DeploymentOverlayIndexService;
import org.jboss.as.server.deploymentoverlay.service.DeploymentOverlayService;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

public class ContentOverrideDeploymentUnitProcessor
implements DeploymentUnitProcessor {
    private final DeploymentOverlayIndexService indexService;
    private static final AttachmentKey<AttachmentList<Closeable>> MOUNTED_FILES = AttachmentKey.createList(Closeable.class);

    public ContentOverrideDeploymentUnitProcessor(DeploymentOverlayIndexService indexService) {
        this.indexService = indexService;
    }

    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.getParent() != null) {
            return;
        }
        ResourceRoot deploymentRoot = deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        HashSet<String> paths = new HashSet<String>();
        for (DeploymentOverlayService deploymentOverlay : this.indexService.getOverrides(deploymentUnit.getName())) {
            for (ContentService override : deploymentOverlay.getContentServices()) {
                if (paths.contains(override.getPath())) continue;
                paths.add(override.getPath());
                try {
                    Closeable handle = VFS.mountReal((File)override.getContentHash().getPhysicalFile(), (VirtualFile)deploymentRoot.getRoot().getChild(override.getPath()));
                    deploymentUnit.addToAttachmentList(MOUNTED_FILES, handle);
                }
                catch (IOException e) {
                    throw ServerMessages.MESSAGES.deploymentOverlayFailed(e, deploymentOverlay.getName(), override.getPath());
                }
            }
        }
    }

    @Override
    public void undeploy(DeploymentUnit context) {
        for (Closeable closable : context.getAttachmentList(MOUNTED_FILES)) {
            try {
                closable.close();
            }
            catch (IOException e) {
                ServerLogger.DEPLOYMENT_LOGGER.failedToUnmountContentOverride(e);
            }
        }
    }
}

