/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.ProcessEnvironmentSystemPropertyUpdater;
import org.jboss.as.server.operations.SecurityActions;
import org.jboss.dmr.ModelNode;

public class SystemPropertyValueWriteAttributeHandler
extends AbstractWriteAttributeHandler<SysPropValue> {
    private final ProcessEnvironmentSystemPropertyUpdater systemPropertyUpdater;

    public SystemPropertyValueWriteAttributeHandler(ProcessEnvironmentSystemPropertyUpdater systemPropertyUpdater, AttributeDefinition valueAttribute) {
        super(new AttributeDefinition[]{valueAttribute});
        this.systemPropertyUpdater = systemPropertyUpdater;
    }

    protected boolean requiresRuntime(OperationContext context) {
        return this.systemPropertyUpdater != null;
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<SysPropValue> handbackHolder) throws OperationFailedException {
        String setValue;
        String name = PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue();
        boolean applyToRuntime = this.systemPropertyUpdater.isRuntimeSystemPropertyUpdateAllowed(name, setValue = resolvedValue.isDefined() ? resolvedValue.asString() : null, context.isBooting());
        if (applyToRuntime) {
            String oldValue = SecurityActions.getSystemProperty(name);
            if (setValue != null) {
                SecurityActions.setSystemProperty(name, setValue);
            } else {
                SecurityActions.clearSystemProperty(name);
            }
            this.systemPropertyUpdater.systemPropertyUpdated(name, setValue);
            handbackHolder.setHandback((Object)new SysPropValue(name, oldValue));
        }
        return !applyToRuntime;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, SysPropValue handback) throws OperationFailedException {
        if (handback != null) {
            if (handback.value != null) {
                SecurityActions.setSystemProperty(handback.name, handback.value);
            } else {
                SecurityActions.clearSystemProperty(handback.name);
            }
            this.systemPropertyUpdater.systemPropertyUpdated(handback.name, handback.value);
        }
    }

    public static class SysPropValue {
        private final String name;
        private final String value;

        private SysPropValue(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

