/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.subsystem.test;

import java.io.IOException;
import java.util.List;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.subsystem.test.AbstractSubsystemTest;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.dmr.ModelNode;
import org.junit.Test;

public abstract class AbstractSubsystemBaseTest
extends AbstractSubsystemTest {
    public AbstractSubsystemBaseTest(String mainSubsystemName, Extension mainExtension) {
        super(mainSubsystemName, mainExtension);
    }

    protected abstract String getSubsystemXml() throws IOException;

    protected void validateXml(String orignal, String marshalled) throws Exception {
    }

    @Test
    public void testSubsystem() throws Exception {
        AdditionalInitialization additionalInit = this.createAdditionalInitialization();
        String subsystemXml = this.getSubsystemXml();
        KernelServices servicesA = super.installInController(additionalInit, subsystemXml);
        ModelNode modelA = servicesA.readWholeModel();
        String marshalled = servicesA.getPersistedSubsystemXml();
        servicesA.shutdown();
        this.validateXml(this.normalizeXML(subsystemXml), this.normalizeXML(marshalled));
        KernelServices servicesB = super.installInController(additionalInit, marshalled);
        ModelNode modelB = servicesB.readWholeModel();
        super.compare(modelA, modelB);
        ModelNode operation = this.createDescribeOperation();
        ModelNode result = servicesB.executeOperation(operation);
        List operations = result.get("result").asList();
        servicesB.shutdown();
        KernelServices servicesC = super.installInController(additionalInit, operations);
        ModelNode modelC = servicesC.readWholeModel();
        super.compare(modelA, modelC);
    }

    protected ModelNode createDescribeOperation() {
        ModelNode address = new ModelNode();
        address.add("subsystem", this.getMainSubsystemName());
        ModelNode operation = new ModelNode();
        operation.get("operation").set("describe");
        operation.get("address").set(address);
        return operation;
    }

    protected AdditionalInitialization createAdditionalInitialization() {
        return new AdditionalInitialization(){

            @Override
            protected OperationContext.Type getType() {
                return OperationContext.Type.MANAGEMENT;
            }
        };
    }
}

