/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.smoke.modular.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;

public class ShrinkWrapUtils {
    public static JavaArchive createJavaArchive(String archiveName) {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)ShrinkWrapUtils.getBaseArchiveName(archiveName));
        ShrinkWrapUtils.addResources(archiveName, archive);
        return archive;
    }

    public static JavaArchive createJavaArchive(String archiveName, Package ... packages) {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)ShrinkWrapUtils.getBaseArchiveName(archiveName));
        ShrinkWrapUtils.addPackages(archive, packages);
        ShrinkWrapUtils.addResources(archiveName, archive);
        return archive;
    }

    public static JavaArchive createJavaArchive(String archiveName, Class<?> ... classes) {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)ShrinkWrapUtils.getBaseArchiveName(archiveName));
        ShrinkWrapUtils.addClasses(archive, classes);
        ShrinkWrapUtils.addResources(archiveName, archive);
        return archive;
    }

    public static WebArchive createWebArchive(String archiveName) {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)ShrinkWrapUtils.getBaseArchiveName(archiveName));
        ShrinkWrapUtils.addResources(archiveName, archive);
        return archive;
    }

    public static WebArchive createWebArchive(String archiveName, Package ... packages) {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)ShrinkWrapUtils.getBaseArchiveName(archiveName));
        ShrinkWrapUtils.addPackages(archive, packages);
        ShrinkWrapUtils.addResources(archiveName, archive);
        return archive;
    }

    public static WebArchive createWebArchive(String archiveName, Class<?> ... classes) {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)ShrinkWrapUtils.getBaseArchiveName(archiveName));
        ShrinkWrapUtils.addClasses(archive, classes);
        ShrinkWrapUtils.addResources(archiveName, archive);
        return archive;
    }

    public static WebArchive createWebArchive(String archiveName, String resourcesName, Class<?> ... classes) {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)ShrinkWrapUtils.getBaseArchiveName(archiveName));
        ShrinkWrapUtils.addClasses(archive, classes);
        ShrinkWrapUtils.addResources(resourcesName, archive);
        return archive;
    }

    public static JavaArchive createEmptyJavaArchive(String archiveName) {
        int index = archiveName.lastIndexOf("/");
        String baseName = index < 0 ? archiveName : archiveName.substring(index + 1);
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)baseName);
        archive.addClass(ShrinkWrapUtils.class);
        return archive;
    }

    public static File getResources(String archiveName) {
        String name = archiveName;
        URL url = Thread.currentThread().getContextClassLoader().getResource(name);
        if (url == null) {
            System.err.println("No resources for " + archiveName);
            return null;
        }
        try {
            File file = new File(url.toURI());
            if (!file.exists()) {
                throw new IllegalArgumentException("Could not find " + file.getAbsolutePath());
            }
            if (!file.isDirectory()) {
                throw new IllegalArgumentException(file.getAbsolutePath() + " is not a directory");
            }
            return file;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Could not get file for " + url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeToFileSystem(JavaArchive javaArchive, File destDirectory) throws IOException {
        InputStream inputStream = ((ZipExporter)javaArchive.as(ZipExporter.class)).exportAsInputStream();
        String jarFileName = javaArchive.getName();
        File jarFile = new File(destDirectory, jarFileName);
        FileOutputStream fos = new FileOutputStream(jarFile);
        BufferedOutputStream bos = null;
        BufferedInputStream bis = null;
        try {
            int length;
            bos = new BufferedOutputStream(fos);
            bis = new BufferedInputStream(inputStream);
            byte[] content = new byte[4096];
            while ((length = bis.read(content)) != -1) {
                bos.write(content, 0, length);
            }
            bos.flush();
        }
        finally {
            if (bos != null) {
                bos.close();
            }
            if (bis != null) {
                bis.close();
            }
        }
        return jarFile;
    }

    public static void addFiles(Archive<?> archive, File dir, ArchivePath dest) {
        for (String name : dir.list()) {
            File file = new File(dir, name);
            if (file.isDirectory()) {
                ShrinkWrapUtils.addFiles(archive, file, ArchivePaths.create((ArchivePath)dest, (String)name));
                continue;
            }
            archive.add((Asset)new FileAsset(file), ArchivePaths.create((ArchivePath)dest, (String)name));
        }
    }

    private static String getBaseArchiveName(String archiveName) {
        int index = archiveName.lastIndexOf("/");
        return index < 0 ? archiveName : archiveName.substring(index + 1);
    }

    private static void addPackages(ClassContainer<?> archive, Package ... packages) {
        for (Package pkg : packages) {
            archive.addPackage(pkg);
        }
    }

    private static void addClasses(ClassContainer<?> archive, Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            archive.addClass(clazz);
        }
    }

    private static void addResources(String archiveName, Archive<?> archive) {
        File resourcesDir = ShrinkWrapUtils.getResources(archiveName);
        if (resourcesDir != null) {
            ShrinkWrapUtils.addFiles(archive, resourcesDir, ArchivePaths.create((String)"/"));
        }
    }
}

