/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.common.jms;

import java.io.IOException;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.test.integration.common.jms.JMSOperations;
import org.jboss.as.test.integration.common.jms.JMSOperationsException;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public class DefaultHornetQProviderJMSOperations
implements JMSOperations {
    private final ManagementClient client;
    private static final Logger logger = Logger.getLogger(DefaultHornetQProviderJMSOperations.class);

    public DefaultHornetQProviderJMSOperations(ManagementClient client) {
        this.client = client;
    }

    @Override
    public void createJmsQueue(String queueName, String jndiName) {
        this.createJmsDestination("jms-queue", queueName, jndiName);
    }

    @Override
    public void createJmsTopic(String topicName, String jndiName) {
        this.createJmsDestination("jms-topic", topicName, jndiName);
    }

    @Override
    public void removeJmsQueue(String queueName) {
        this.removeJmsDestination("jms-queue", queueName);
    }

    @Override
    public void removeJmsTopic(String topicName) {
        this.removeJmsDestination("jms-topic", topicName);
    }

    @Override
    public void close() {
    }

    private ModelControllerClient getModelControllerClient() {
        return this.client.getControllerClient();
    }

    private void createJmsDestination(String destinationType, String destinationName, String jndiName) {
        ModelNode createJmsQueueOperation = new ModelNode();
        createJmsQueueOperation.get("operation").set("add");
        createJmsQueueOperation.get("address").add("subsystem", "messaging");
        createJmsQueueOperation.get("address").add("hornetq-server", "default");
        createJmsQueueOperation.get("address").add(destinationType, destinationName);
        createJmsQueueOperation.get("entries").add(jndiName);
        try {
            this.applyUpdate(createJmsQueueOperation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void removeJmsDestination(String destinationType, String destinationName) {
        ModelNode removeJmsQueue = new ModelNode();
        removeJmsQueue.get("operation").set("remove");
        removeJmsQueue.get("address").add("subsystem", "messaging");
        removeJmsQueue.get("address").add("hornetq-server", "default");
        removeJmsQueue.get("address").add(destinationType, destinationName);
        try {
            this.applyUpdate(removeJmsQueue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void applyUpdate(ModelNode update) throws IOException, JMSOperationsException {
        ModelNode result = this.getModelControllerClient().execute(update);
        if (!result.hasDefined("outcome") || !"success".equals(result.get("outcome").asString())) {
            if (result.hasDefined("failure-description")) {
                String failureDesc = result.get("failure-description").toString();
                throw new JMSOperationsException(failureDesc);
            }
            throw new JMSOperationsException("Operation not successful; outcome = " + result.get("outcome"));
        }
        logger.info((Object)("Operation successful for update = " + update.toString()));
    }
}

