/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.threads.TimeSpec;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.threads.BlockingExecutor;
import org.jboss.threads.EventListener;
import org.jboss.threads.JBossExecutors;
import org.jboss.threads.QueueExecutor;

public class BoundedQueueThreadPoolService
implements Service<Executor> {
    private final InjectedValue<ThreadFactory> threadFactoryValue = new InjectedValue();
    private final InjectedValue<Executor> handoffExecutorValue = new InjectedValue();
    private QueueExecutor executor;
    private Executor value;
    private int coreThreads;
    private int maxThreads;
    private int queueLength;
    private boolean blocking;
    private TimeSpec keepAlive;
    private boolean allowCoreTimeout;

    public BoundedQueueThreadPoolService(int coreThreads, int maxThreads, int queueLength, boolean blocking, TimeSpec keepAlive, boolean allowCoreTimeout) {
        this.coreThreads = coreThreads;
        this.maxThreads = maxThreads;
        this.queueLength = queueLength;
        this.blocking = blocking;
        this.keepAlive = keepAlive;
        this.allowCoreTimeout = allowCoreTimeout;
    }

    public synchronized void start(StartContext context) throws StartException {
        this.executor = new QueueExecutor(this.coreThreads, this.maxThreads, this.keepAlive.getDuration(), this.keepAlive.getUnit(), this.queueLength, (ThreadFactory)this.threadFactoryValue.getValue(), this.blocking, (Executor)this.handoffExecutorValue.getOptionalValue());
        this.executor.setAllowCoreThreadTimeout(this.allowCoreTimeout);
        this.value = JBossExecutors.protectedBlockingExecutor((BlockingExecutor)this.executor);
    }

    public synchronized void stop(StopContext context) {
        QueueExecutor executor = this.executor;
        if (executor == null) {
            throw new IllegalStateException();
        }
        context.asynchronous();
        executor.shutdown();
        executor.addShutdownListener((EventListener)new EventListener<StopContext>(){

            public void handleEvent(StopContext stopContext) {
                stopContext.complete();
            }
        }, (Object)context);
        this.executor = null;
        this.value = null;
    }

    public synchronized Executor getValue() throws IllegalStateException {
        Executor value = this.value;
        if (value == null) {
            throw new IllegalStateException();
        }
        return value;
    }

    public Injector<ThreadFactory> getThreadFactoryInjector() {
        return this.threadFactoryValue;
    }

    public Injector<Executor> getHandoffExecutorInjector() {
        return this.handoffExecutorValue;
    }

    public synchronized void setCoreThreads(int coreThreads) {
        this.coreThreads = coreThreads;
        QueueExecutor executor = this.executor;
        if (executor != null) {
            executor.setCoreThreads(coreThreads);
        }
    }

    public synchronized void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        QueueExecutor executor = this.executor;
        if (executor != null) {
            executor.setMaxThreads(maxThreads);
        }
    }

    public synchronized void setQueueLength(int queueLength) {
        this.queueLength = queueLength;
    }

    public synchronized void setBlocking(boolean blocking) {
        this.blocking = blocking;
        QueueExecutor executor = this.executor;
        if (executor != null) {
            executor.setBlocking(blocking);
        }
    }

    public synchronized void setKeepAlive(TimeSpec keepAlive) {
        this.keepAlive = keepAlive;
        QueueExecutor executor = this.executor;
        if (executor != null) {
            executor.setKeepAliveTime(keepAlive.getDuration(), keepAlive.getUnit());
        }
    }

    public synchronized void setAllowCoreTimeout(boolean allowCoreTimeout) {
        this.allowCoreTimeout = allowCoreTimeout;
        QueueExecutor executor = this.executor;
        if (executor != null) {
            executor.setAllowCoreThreadTimeout(allowCoreTimeout);
        }
    }
}

