/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationHandler;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.threads.ScheduledThreadPoolService;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.as.threads.ThreadsSubsystemThreadPoolOperationUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class ScheduledThreadPoolAdd
implements ModelAddOperationHandler {
    static final OperationHandler INSTANCE = new ScheduledThreadPoolAdd();

    public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) {
        final ThreadsSubsystemThreadPoolOperationUtils.BaseOperationParameters params = ThreadsSubsystemThreadPoolOperationUtils.parseScheduledThreadPoolOperationParameters(operation);
        ModelNode model = context.getSubModel();
        model.get("name").set(params.getName());
        if (params.getThreadFactory() != null) {
            model.get("thread-factory").set(params.getThreadFactory());
        }
        if (params.getProperties() != null && params.getProperties().asList().size() > 0) {
            model.get("properties").set(params.getProperties());
        }
        if (params.getMaxThreads() != null) {
            model.get("max-threads").set(operation.get("max-threads"));
        }
        if (params.getKeepAliveTime() != null) {
            model.get("keepalive-time").set(operation.get("keepalive-time"));
        }
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceTarget target = context.getServiceTarget();
                    ServiceName serviceName = ThreadsServices.executorName(params.getName());
                    ScheduledThreadPoolService service = new ScheduledThreadPoolService(params.getMaxThreads().getScaledCount(), params.getKeepAliveTime());
                    ServiceBuilder serviceBuilder = target.addService(serviceName, (Service)service);
                    ThreadsSubsystemThreadPoolOperationUtils.addThreadFactoryDependency(params.getThreadFactory(), serviceName, serviceBuilder, service.getThreadFactoryInjector(), target);
                    serviceBuilder.addListener((ServiceListener)new ResultHandler.ServiceStartListener(resultHandler));
                    serviceBuilder.install();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        ModelNode compensating = Util.getResourceRemoveOperation((ModelNode)params.getAddress());
        return new BasicOperationResult(compensating);
    }
}

