/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.txn.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class TransactionSubsystemProviders {
    static final String RESOURCE_NAME = TransactionSubsystemProviders.class.getPackage().getName() + ".LocalDescriptions";
    static final DescriptionProvider SUBSYSTEM = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getSubsystem(locale);
        }
    };
    static final DescriptionProvider SUBSYSTEM_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getSubsystemAdd(locale);
        }
    };

    TransactionSubsystemProviders() {
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }

    private static class Descriptions {
        private Descriptions() {
        }

        static ModelNode getSubsystem(Locale locale) {
            ResourceBundle bundle = TransactionSubsystemProviders.getResourceBundle(locale);
            ModelNode subsystem = new ModelNode();
            subsystem.get("description").set(bundle.getString("txn"));
            subsystem.get("head-comment-allowed").set(true);
            subsystem.get("tail-comment-allowed").set(true);
            subsystem.get("namespace").set(Namespace.TRANSACTIONS_1_0.getUriString());
            subsystem.get(new String[]{"attributes", "core-environment", "description"}).set(bundle.getString("core-environment"));
            subsystem.get(new String[]{"attributes", "core-environment", "type"}).set(ModelType.OBJECT);
            subsystem.get(new String[]{"attributes", "core-environment", "required"}).set(true);
            subsystem.get(new String[]{"attributes", "core-environment", "value-type", "node-identifier", "description"}).set(bundle.getString("core-environment.node-identifier"));
            subsystem.get(new String[]{"attributes", "core-environment", "value-type", "node-identifier", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "core-environment", "value-type", "node-identifier", "default"}).set(1);
            subsystem.get(new String[]{"attributes", "core-environment", "value-type", "node-identifier", "required"}).set(false);
            subsystem.get(new String[]{"attributes", "core-environment", "value-type", "socket-binding", "description"}).set(bundle.getString("core-environment.socket-binding"));
            subsystem.get(new String[]{"attributes", "core-environment", "value-type", "socket-binding", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "core-environment", "value-type", "socket-binding", "min-length"}).set(1);
            subsystem.get(new String[]{"attributes", "core-environment", "value-type", "socket-binding", "required"}).set(true);
            subsystem.get(new String[]{"attributes", "recovery-environment", "description"}).set(bundle.getString("recovery-environment"));
            subsystem.get(new String[]{"attributes", "recovery-environment", "type"}).set(ModelType.OBJECT);
            subsystem.get(new String[]{"attributes", "recovery-environment", "required"}).set(true);
            subsystem.get(new String[]{"attributes", "recovery-environment", "value-type", "socket-binding", "description"}).set(bundle.getString("recovery-environment.socket-binding"));
            subsystem.get(new String[]{"attributes", "recovery-environment", "value-type", "socket-binding", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "recovery-environment", "value-type", "socket-binding", "min-length"}).set(1);
            subsystem.get(new String[]{"attributes", "recovery-environment", "value-type", "socket-binding", "required"}).set(true);
            subsystem.get(new String[]{"attributes", "recovery-environment", "value-type", "status-socket-binding", "description"}).set(bundle.getString("recovery-environment.status-socket-binding"));
            subsystem.get(new String[]{"attributes", "recovery-environment", "value-type", "status-socket-binding", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "recovery-environment", "value-type", "status-socket-binding", "min-length"}).set(1);
            subsystem.get(new String[]{"attributes", "recovery-environment", "value-type", "status-socket-binding", "required"}).set(true);
            subsystem.get(new String[]{"attributes", "coordinator-environment", "description"}).set(bundle.getString("coordinator-environment"));
            subsystem.get(new String[]{"attributes", "coordinator-environment", "type"}).set(ModelType.OBJECT);
            subsystem.get(new String[]{"attributes", "coordinator-environment", "required"}).set(false);
            subsystem.get(new String[]{"attributes", "coordinator-environment", "value-type", "enable-statistics", "description"}).set(bundle.getString("coordinator-environment.enable-statistics"));
            subsystem.get(new String[]{"attributes", "coordinator-environment", "value-type", "enable-statistics", "type"}).set(ModelType.BOOLEAN);
            subsystem.get(new String[]{"attributes", "coordinator-environment", "value-type", "enable-statistics", "required"}).set(false);
            subsystem.get(new String[]{"attributes", "coordinator-environment", "value-type", "enable-statistics", "default"}).set(true);
            return subsystem;
        }

        static ModelNode getSubsystemAdd(Locale locale) {
            ResourceBundle bundle = TransactionSubsystemProviders.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("description").set(bundle.getString("txn.add"));
            op.get("head-comment-allowed").set(true);
            op.get("tail-comment-allowed").set(true);
            op.get("namespace").set(Namespace.TRANSACTIONS_1_0.getUriString());
            op.get(new String[]{"request-properties", "core-environment", "description"}).set(bundle.getString("core-environment"));
            op.get(new String[]{"request-properties", "core-environment", "type"}).set(ModelType.OBJECT);
            op.get(new String[]{"request-properties", "core-environment", "required"}).set(true);
            op.get(new String[]{"request-properties", "core-environment", "value-type", "node-identifier", "description"}).set(bundle.getString("core-environment.node-identifier"));
            op.get(new String[]{"request-properties", "core-environment", "value-type", "node-identifier", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "core-environment", "value-type", "node-identifier", "default"}).set(1);
            op.get(new String[]{"request-properties", "core-environment", "value-type", "node-identifier", "required"}).set(false);
            op.get(new String[]{"request-properties", "core-environment", "value-type", "socket-binding", "description"}).set(bundle.getString("core-environment.socket-binding"));
            op.get(new String[]{"request-properties", "core-environment", "value-type", "socket-binding", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "core-environment", "value-type", "socket-binding", "min-length"}).set(1);
            op.get(new String[]{"request-properties", "core-environment", "value-type", "socket-binding", "required"}).set(true);
            op.get(new String[]{"request-properties", "recovery-environment", "description"}).set(bundle.getString("recovery-environment"));
            op.get(new String[]{"request-properties", "recovery-environment", "type"}).set(ModelType.OBJECT);
            op.get(new String[]{"request-properties", "recovery-environment", "required"}).set(true);
            op.get(new String[]{"request-properties", "recovery-environment", "value-type", "socket-binding", "description"}).set(bundle.getString("recovery-environment.socket-binding"));
            op.get(new String[]{"request-properties", "recovery-environment", "value-type", "socket-binding", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "recovery-environment", "value-type", "socket-binding", "min-length"}).set(1);
            op.get(new String[]{"request-properties", "recovery-environment", "value-type", "socket-binding", "required"}).set(true);
            op.get(new String[]{"request-properties", "recovery-environment", "value-type", "status-socket-binding", "description"}).set(bundle.getString("recovery-environment.status-socket-binding"));
            op.get(new String[]{"request-properties", "recovery-environment", "value-type", "status-socket-binding", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "recovery-environment", "value-type", "status-socket-binding", "min-length"}).set(1);
            op.get(new String[]{"request-properties", "recovery-environment", "value-type", "status-socket-binding", "required"}).set(true);
            op.get(new String[]{"request-properties", "coordinator-environment", "description"}).set(bundle.getString("coordinator-environment"));
            op.get(new String[]{"request-properties", "coordinator-environment", "type"}).set(ModelType.OBJECT);
            op.get(new String[]{"request-properties", "coordinator-environment", "required"}).set(false);
            op.get(new String[]{"request-properties", "coordinator-environment", "value-type", "enable-statistics", "description"}).set(bundle.getString("coordinator-environment.enable-statistics"));
            op.get(new String[]{"request-properties", "coordinator-environment", "value-type", "enable-statistics", "type"}).set(ModelType.BOOLEAN);
            op.get(new String[]{"request-properties", "coordinator-environment", "value-type", "enable-statistics", "required"}).set(false);
            op.get(new String[]{"request-properties", "coordinator-environment", "value-type", "enable-statistics", "default"}).set(true);
            op.get("reply-properties").setEmptyObject();
            return op;
        }
    }
}

