/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.deployment;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.transaction.TransactionManager;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.as.txn.TransactionLogger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class TransactionRollbackSetupAction
implements SetupAction,
Service<TransactionRollbackSetupAction> {
    private final InjectedValue<TransactionManager> transactionManager = new InjectedValue();
    private final ServiceName serviceName;

    public TransactionRollbackSetupAction(ServiceName serviceName) {
        this.serviceName = serviceName;
    }

    public void setup(Map<String, Object> properties) {
    }

    public void teardown(Map<String, Object> properties) {
        try {
            TransactionManager tm = (TransactionManager)this.transactionManager.getValue();
            int status = tm.getStatus();
            switch (status) {
                case 0: 
                case 1: 
                case 2: 
                case 7: 
                case 8: 
                case 9: {
                    try {
                        TransactionLogger.ROOT_LOGGER.transactionStillOpen(status);
                        tm.rollback();
                        break;
                    }
                    catch (Exception ex) {
                        TransactionLogger.ROOT_LOGGER.unableToRollBack(ex);
                    }
                }
            }
        }
        catch (Exception e) {
            TransactionLogger.ROOT_LOGGER.unableToGetTransactionStatus(e);
        }
    }

    public int priority() {
        return 0;
    }

    public Set<ServiceName> dependencies() {
        return Collections.singleton(this.serviceName);
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public TransactionRollbackSetupAction getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<TransactionManager> getTransactionManager() {
        return this.transactionManager;
    }
}

