/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.subsystem;

import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.txn.subsystem.Attribute;
import org.jboss.as.txn.subsystem.Element;
import org.jboss.as.txn.subsystem.Namespace;
import org.jboss.as.txn.subsystem.TransactionSubsystemRootResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

class TransactionSubsystem11Parser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    public static final TransactionSubsystem11Parser INSTANCE = new TransactionSubsystem11Parser();

    private TransactionSubsystem11Parser() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        ModelNode address = new ModelNode();
        address.add("subsystem", "transactions");
        address.protect();
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").set(address);
        list.add(subsystem);
        EnumSet<Element> required = EnumSet.of(Element.RECOVERY_ENVIRONMENT, Element.CORE_ENVIRONMENT);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case TRANSACTIONS_1_1: {
                    Element element = Element.forName(reader.getLocalName());
                    required.remove((Object)element);
                    if (!encountered.add(element)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    switch (element) {
                        case RECOVERY_ENVIRONMENT: {
                            TransactionSubsystem11Parser.parseRecoveryEnvironmentElement(reader, subsystem);
                            continue block10;
                        }
                        case CORE_ENVIRONMENT: {
                            TransactionSubsystem11Parser.parseCoreEnvironmentElement(reader, subsystem);
                            continue block10;
                        }
                        case COORDINATOR_ENVIRONMENT: {
                            TransactionSubsystem11Parser.parseCoordinatorEnvironmentElement(reader, subsystem);
                            continue block10;
                        }
                        case OBJECT_STORE: {
                            TransactionSubsystem11Parser.parseObjectStoreEnvironmentElementAndEnrichOperation(reader, subsystem);
                            continue block10;
                        }
                        case JTS: {
                            this.parseJts(reader, subsystem);
                            continue block10;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, required);
        }
    }

    private void parseJts(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        operation.get("jts").set(true);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    static void parseObjectStoreEnvironmentElementAndEnrichOperation(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case RELATIVE_TO: {
                    TransactionSubsystemRootResourceDefinition.OBJECT_STORE_RELATIVE_TO.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block4;
                }
                case PATH: {
                    TransactionSubsystemRootResourceDefinition.OBJECT_STORE_PATH.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    static void parseCoordinatorEnvironmentElement(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLE_STATISTICS: {
                    TransactionSubsystemRootResourceDefinition.ENABLE_STATISTICS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block5;
                }
                case ENABLE_TSM_STATUS: {
                    TransactionSubsystemRootResourceDefinition.ENABLE_TSM_STATUS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block5;
                }
                case DEFAULT_TIMEOUT: {
                    TransactionSubsystemRootResourceDefinition.DEFAULT_TIMEOUT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    static void parseCoreEnvironmentElement(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NODE_IDENTIFIER: {
                    TransactionSubsystemRootResourceDefinition.NODE_IDENTIFIER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                case PATH: {
                    TransactionSubsystemRootResourceDefinition.PATH.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                case RELATIVE_TO: {
                    TransactionSubsystemRootResourceDefinition.RELATIVE_TO.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        EnumSet<Element> required = EnumSet.of(Element.PROCESS_ID);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            required.remove((Object)element);
            switch (element) {
                case PROCESS_ID: {
                    if (!encountered.add(element)) {
                        throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)reader.getLocalName());
                    }
                    TransactionSubsystem11Parser.parseProcessIdEnvironmentElement(reader, operation);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, required);
        }
    }

    static void parseProcessIdEnvironmentElement(XMLExtendedStreamReader reader, ModelNode coreEnvironmentAdd) throws XMLStreamException {
        boolean encountered = false;
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case UUID: {
                    if (encountered) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    encountered = true;
                    coreEnvironmentAdd.get(TransactionSubsystemRootResourceDefinition.PROCESS_ID_UUID.getName()).set(true);
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block4;
                }
                case SOCKET: {
                    if (encountered) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    encountered = true;
                    TransactionSubsystem11Parser.parseSocketProcessIdElement(reader, coreEnvironmentAdd);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!encountered) {
            throw ParseUtils.missingOneOf((XMLExtendedStreamReader)reader, EnumSet.of(Element.UUID, Element.SOCKET));
        }
    }

    static void parseSocketProcessIdElement(XMLExtendedStreamReader reader, ModelNode coreEnvironmentAdd) throws XMLStreamException {
        int count = reader.getAttributeCount();
        EnumSet<Attribute> required = EnumSet.of(Attribute.BINDING);
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case BINDING: {
                    TransactionSubsystemRootResourceDefinition.PROCESS_ID_SOCKET_BINDING.parseAndSetParameter(value, coreEnvironmentAdd, (XMLStreamReader)reader);
                    continue block4;
                }
                case SOCKET_PROCESS_ID_MAX_PORTS: {
                    TransactionSubsystemRootResourceDefinition.PROCESS_ID_SOCKET_MAX_PORTS.parseAndSetParameter(value, coreEnvironmentAdd, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    static void parseRecoveryEnvironmentElement(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.BINDING, Attribute.STATUS_BINDING);
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case BINDING: {
                    TransactionSubsystemRootResourceDefinition.BINDING.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block5;
                }
                case STATUS_BINDING: {
                    TransactionSubsystemRootResourceDefinition.STATUS_BINDING.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block5;
                }
                case RECOVERY_LISTENER: {
                    TransactionSubsystemRootResourceDefinition.RECOVERY_LISTENER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode node = context.getModelNode();
        writer.writeStartElement(Element.CORE_ENVIRONMENT.getLocalName());
        TransactionSubsystemRootResourceDefinition.NODE_IDENTIFIER.marshallAsAttribute(node, (XMLStreamWriter)writer);
        TransactionSubsystemRootResourceDefinition.PATH.marshallAsAttribute(node, (XMLStreamWriter)writer);
        TransactionSubsystemRootResourceDefinition.RELATIVE_TO.marshallAsAttribute(node, (XMLStreamWriter)writer);
        this.writeProcessId(writer, node);
        writer.writeEndElement();
        if (TransactionSubsystemRootResourceDefinition.BINDING.isMarshallable(node) || TransactionSubsystemRootResourceDefinition.STATUS_BINDING.isMarshallable(node) || TransactionSubsystemRootResourceDefinition.RECOVERY_LISTENER.isMarshallable(node)) {
            writer.writeStartElement(Element.RECOVERY_ENVIRONMENT.getLocalName());
            TransactionSubsystemRootResourceDefinition.BINDING.marshallAsAttribute(node, (XMLStreamWriter)writer);
            TransactionSubsystemRootResourceDefinition.STATUS_BINDING.marshallAsAttribute(node, (XMLStreamWriter)writer);
            TransactionSubsystemRootResourceDefinition.RECOVERY_LISTENER.marshallAsAttribute(node, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        if (TransactionSubsystemRootResourceDefinition.ENABLE_STATISTICS.isMarshallable(node) || TransactionSubsystemRootResourceDefinition.ENABLE_TSM_STATUS.isMarshallable(node) || TransactionSubsystemRootResourceDefinition.DEFAULT_TIMEOUT.isMarshallable(node)) {
            writer.writeStartElement(Element.COORDINATOR_ENVIRONMENT.getLocalName());
            TransactionSubsystemRootResourceDefinition.ENABLE_STATISTICS.marshallAsAttribute(node, (XMLStreamWriter)writer);
            TransactionSubsystemRootResourceDefinition.ENABLE_TSM_STATUS.marshallAsAttribute(node, (XMLStreamWriter)writer);
            TransactionSubsystemRootResourceDefinition.DEFAULT_TIMEOUT.marshallAsAttribute(node, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        if (TransactionSubsystemRootResourceDefinition.OBJECT_STORE_RELATIVE_TO.isMarshallable(node) || TransactionSubsystemRootResourceDefinition.OBJECT_STORE_PATH.isMarshallable(node)) {
            writer.writeStartElement(Element.OBJECT_STORE.getLocalName());
            TransactionSubsystemRootResourceDefinition.OBJECT_STORE_PATH.marshallAsAttribute(node, (XMLStreamWriter)writer);
            TransactionSubsystemRootResourceDefinition.OBJECT_STORE_RELATIVE_TO.marshallAsAttribute(node, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        if (node.hasDefined("jts") && node.get("jts").asBoolean()) {
            writer.writeStartElement(Element.JTS.getLocalName());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeProcessId(XMLExtendedStreamWriter writer, ModelNode value) throws XMLStreamException {
        writer.writeStartElement(Element.PROCESS_ID.getLocalName());
        if (value.get(TransactionSubsystemRootResourceDefinition.PROCESS_ID_UUID.getName()).asBoolean()) {
            writer.writeEmptyElement(Element.UUID.getLocalName());
        } else {
            writer.writeStartElement(Element.SOCKET.getLocalName());
            TransactionSubsystemRootResourceDefinition.PROCESS_ID_SOCKET_BINDING.marshallAsAttribute(value, (XMLStreamWriter)writer);
            TransactionSubsystemRootResourceDefinition.PROCESS_ID_SOCKET_MAX_PORTS.marshallAsAttribute(value, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

