/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.web.WebConnectorAdd;
import org.jboss.as.web.WebVirtualHostAdd;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

class WebSubsystemDescribe
implements OperationStepHandler,
DescriptionProvider {
    static final WebSubsystemDescribe INSTANCE = new WebSubsystemDescribe();

    WebSubsystemDescribe() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode address;
        ModelNode result = context.getResult();
        PathAddress rootAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement()});
        ModelNode subModel = context.readModel(PathAddress.EMPTY_ADDRESS);
        ModelNode subsystemAdd = new ModelNode();
        subsystemAdd.get("operation").set("add");
        subsystemAdd.get("address").set(rootAddress.toModelNode());
        if (subModel.hasDefined("configuration")) {
            subsystemAdd.get("configuration").set(subModel.get("configuration"));
        }
        result.add(subsystemAdd);
        if (subModel.hasDefined("connector")) {
            for (Property connector : subModel.get("connector").asPropertyList()) {
                address = rootAddress.toModelNode();
                address.add("connector", connector.getName());
                result.add(WebConnectorAdd.getRecreateOperation(address, connector.getValue()));
            }
        }
        if (subModel.hasDefined("virtual-server")) {
            for (Property host : subModel.get("virtual-server").asPropertyList()) {
                address = rootAddress.toModelNode();
                address.add("virtual-server", host.getName());
                result.add(WebVirtualHostAdd.getAddOperation(address, host.getValue()));
            }
        }
        context.completeStep();
    }

    public ModelNode getModelDescription(Locale locale) {
        return new ModelNode();
    }
}

