/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment;

import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.web.deployment.JsfVersionMarker;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.filter.PathFilters;

public class WarClassloadingDependencyProcessor
implements DeploymentUnitProcessor {
    private static final ModuleIdentifier JAVAX_EE_API = ModuleIdentifier.create((String)"javaee.api");
    private static final ModuleIdentifier JSF_IMPL = ModuleIdentifier.create((String)"com.sun.jsf-impl");
    private static final ModuleIdentifier JSF_API = ModuleIdentifier.create((String)"javax.faces.api");
    private static final ModuleIdentifier JSF_1_2_IMPL = ModuleIdentifier.create((String)"com.sun.jsf-impl", (String)"1.2");
    private static final ModuleIdentifier JSF_1_2_API = ModuleIdentifier.create((String)"javax.faces.api", (String)"1.2");
    private static final ModuleIdentifier BEAN_VALIDATION = ModuleIdentifier.create((String)"org.hibernate.validator");
    private static final ModuleIdentifier JBOSS_WEB = ModuleIdentifier.create((String)"org.jboss.as.web");
    private static final Logger logger;

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        DeploymentUnit topLevelDeployment = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        String jsfVersion = JsfVersionMarker.getVersion(topLevelDeployment);
        if (jsfVersion.equals("Mojarra-1.2")) {
            moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, JSF_1_2_API, false, false, false));
        } else {
            moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, JSF_API, false, false, false));
        }
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, JAVAX_EE_API, false, false, false));
        if (jsfVersion.equals("Mojarra-1.2")) {
            ModuleDependency jsf = new ModuleDependency(moduleLoader, JSF_1_2_IMPL, false, false, false);
            jsf.addImportFilter(PathFilters.getMetaInfFilter(), true);
            moduleSpecification.addSystemDependency(jsf);
        } else {
            if (!jsfVersion.equals("Mojarra-2.0")) {
                logger.warn((Object)("Ukown JSF version " + jsfVersion + " " + "Mojarra-2.0" + " will be used instead"));
            }
            ModuleDependency jsf = new ModuleDependency(moduleLoader, JSF_IMPL, false, false, false);
            jsf.addImportFilter(PathFilters.getMetaInfFilter(), true);
            moduleSpecification.addSystemDependency(jsf);
        }
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, BEAN_VALIDATION, false, false, true));
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, JBOSS_WEB, false, false, true));
    }

    public void undeploy(DeploymentUnit context) {
    }

    static {
        Module.registerURLStreamHandlerFactoryModule((Module)Module.forClass(WarClassloadingDependencyProcessor.class));
        logger = Logger.getLogger(WarClassloadingDependencyProcessor.class);
    }
}

