/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment.component;

import java.util.HashSet;
import java.util.Set;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.web.deployment.component.ComponentInstantiator;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class ManagedBeanComponentInstantiator
implements ComponentInstantiator {
    private volatile ServiceController<ComponentView> viewServiceServiceController;
    private final Set<ServiceName> serviceNames = new HashSet<ServiceName>();
    private final ServiceName serviceName;
    private final ServiceRegistry serviceRegistry;

    public ManagedBeanComponentInstantiator(DeploymentUnit deploymentUnit, ComponentDescription componentDescription) {
        ServiceName baseName = deploymentUnit.getServiceName().append(new String[]{"component"}).append(new String[]{componentDescription.getComponentName()});
        this.serviceRegistry = deploymentUnit.getServiceRegistry();
        this.serviceNames.add(baseName.append(new String[]{"START"}));
        if (componentDescription.getViews() == null || componentDescription.getViews().size() != 1) {
            throw new RuntimeException("Servlet components must have exactly one view: " + componentDescription.getComponentName());
        }
        ViewDescription view = (ViewDescription)componentDescription.getViews().iterator().next();
        String viewClassName = view.getViewClassName();
        this.serviceName = baseName.append(new String[]{"VIEW"}).append(new String[]{viewClassName});
        this.serviceNames.add(this.serviceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedReference getReference() {
        if (this.viewServiceServiceController == null) {
            ManagedBeanComponentInstantiator managedBeanComponentInstantiator = this;
            synchronized (managedBeanComponentInstantiator) {
                if (this.viewServiceServiceController == null) {
                    this.viewServiceServiceController = this.serviceRegistry.getRequiredService(this.serviceName);
                }
            }
        }
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public Set<ServiceName> getServiceNames() {
        return this.serviceNames;
    }

    @Override
    public ManagedReference initializeInstance(Object instance) {
        throw new UnsupportedOperationException("Not Implemented");
    }
}

