/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.global.WriteAttributeHandlers;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.web.MimeMappingAdd;
import org.jboss.as.web.MimeMappingRemove;
import org.jboss.as.web.Namespace;
import org.jboss.as.web.WebAccessLogAdd;
import org.jboss.as.web.WebAccessLogRemove;
import org.jboss.as.web.WebConfigurationHandlerUtils;
import org.jboss.as.web.WebConnectorAdd;
import org.jboss.as.web.WebConnectorMetrics;
import org.jboss.as.web.WebConnectorRemove;
import org.jboss.as.web.WebReWriteAdd;
import org.jboss.as.web.WebReWriteConditionAdd;
import org.jboss.as.web.WebReWriteConditionRemove;
import org.jboss.as.web.WebReWriteRemove;
import org.jboss.as.web.WebSSLAdd;
import org.jboss.as.web.WebSSLRemove;
import org.jboss.as.web.WebSSOAdd;
import org.jboss.as.web.WebSSORemove;
import org.jboss.as.web.WebSubsystemAdd;
import org.jboss.as.web.WebSubsystemDescribe;
import org.jboss.as.web.WebSubsystemDescriptionProviders;
import org.jboss.as.web.WebSubsystemParser;
import org.jboss.as.web.WebVirtualHostAdd;
import org.jboss.as.web.WebVirtualHostRemove;
import org.jboss.as.web.WriteDefaultWebModule;
import org.jboss.as.web.WriteEnableWelcomeRoot;
import org.jboss.as.web.deployment.ServletDeploymentStats;
import org.jboss.dmr.ModelType;
import org.jboss.logging.Logger;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class WebExtension
implements Extension {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.web");
    public static final String SUBSYSTEM_NAME = "web";
    private static final PathElement connectorPath = PathElement.pathElement((String)"connector");
    private static final PathElement hostPath = PathElement.pathElement((String)"virtual-server");
    private static final PathElement sslPath = PathElement.pathElement((String)"ssl", (String)"configuration");
    private static final PathElement jspconfigurationPath = PathElement.pathElement((String)"configuration", (String)"jsp-configuration");
    private static final PathElement resourcesPath = PathElement.pathElement((String)"configuration", (String)"static-resources");
    private static final PathElement containerPath = PathElement.pathElement((String)"configuration", (String)"container");
    private static final PathElement accesslogPath = PathElement.pathElement((String)"access-log", (String)"configuration");
    private static final PathElement rewritePath = PathElement.pathElement((String)"rewrite");
    private static final PathElement ssoPath = PathElement.pathElement((String)"sso", (String)"configuration");
    private static final PathElement directoryPath = PathElement.pathElement((String)"directory", (String)"configuration");
    private static final PathElement rewritecondPath = PathElement.pathElement((String)"condition");

    public void initialize(ExtensionContext context) {
        boolean registerRuntimeOnly = context.isRuntimeOnlyRegistrationValid();
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 1, 0);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel(WebSubsystemDescriptionProviders.SUBSYSTEM);
        registration.registerOperationHandler("add", (OperationStepHandler)WebSubsystemAdd.INSTANCE, (DescriptionProvider)WebSubsystemAdd.INSTANCE, false);
        registration.registerOperationHandler("describe", (OperationStepHandler)WebSubsystemDescribe.INSTANCE, (DescriptionProvider)WebSubsystemDescribe.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        registration.registerOperationHandler("remove", (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE, WebSubsystemDescriptionProviders.SUBSYSTEM_REMOVE, false);
        registration.registerReadWriteAttribute("default-virtual-server", null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler((ParameterValidator)new ModelTypeValidator(ModelType.STRING)), AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute("native", null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler((ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN)), AttributeAccess.Storage.CONFIGURATION);
        subsystem.registerXMLElementWriter((XMLElementWriter)WebSubsystemParser.getInstance());
        ManagementResourceRegistration connectors = registration.registerSubModel(connectorPath, WebSubsystemDescriptionProviders.CONNECTOR);
        connectors.registerOperationHandler("add", (OperationStepHandler)WebConnectorAdd.INSTANCE, (DescriptionProvider)WebConnectorAdd.INSTANCE, false);
        connectors.registerOperationHandler("remove", (OperationStepHandler)WebConnectorRemove.INSTANCE, (DescriptionProvider)WebConnectorRemove.INSTANCE, false);
        if (registerRuntimeOnly) {
            for (String attributeName : WebConnectorMetrics.ATTRIBUTES) {
                connectors.registerMetric(attributeName, (OperationStepHandler)WebConnectorMetrics.INSTANCE);
            }
        }
        connectors.registerReadWriteAttribute("protocol", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1, true), AttributeAccess.Storage.CONFIGURATION);
        connectors.registerReadWriteAttribute("scheme", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1, true), AttributeAccess.Storage.CONFIGURATION);
        connectors.registerReadWriteAttribute("socket-binding", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1), AttributeAccess.Storage.CONFIGURATION);
        connectors.registerReadWriteAttribute("enable-lookups", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN, true), AttributeAccess.Storage.CONFIGURATION);
        connectors.registerReadWriteAttribute("proxy-name", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1), AttributeAccess.Storage.CONFIGURATION);
        connectors.registerReadWriteAttribute("proxy-port", null, (OperationStepHandler)new WriteAttributeHandlers.IntRangeValidatingHandler(1, true), AttributeAccess.Storage.CONFIGURATION);
        connectors.registerReadWriteAttribute("max-post-size", null, (OperationStepHandler)new WriteAttributeHandlers.IntRangeValidatingHandler(1024, true), AttributeAccess.Storage.CONFIGURATION);
        connectors.registerReadWriteAttribute("max-save-post-size", null, (OperationStepHandler)new WriteAttributeHandlers.IntRangeValidatingHandler(0, true), AttributeAccess.Storage.CONFIGURATION);
        connectors.registerReadWriteAttribute("enabled", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN, true), AttributeAccess.Storage.CONFIGURATION);
        connectors.registerReadWriteAttribute("executor", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1, true), AttributeAccess.Storage.CONFIGURATION);
        connectors.registerReadWriteAttribute("max-connections", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1, true), AttributeAccess.Storage.CONFIGURATION);
        connectors.registerReadWriteAttribute("virtual-server", null, (OperationStepHandler)new WriteAttributeHandlers.ListValidatatingHandler((ParameterValidator)new StringLengthValidator(1, false), true), AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration ssl = connectors.registerSubModel(sslPath, WebSubsystemDescriptionProviders.SSL);
        ssl.registerOperationHandler("add", (OperationStepHandler)WebSSLAdd.INSTANCE, (DescriptionProvider)WebSSLAdd.INSTANCE, true);
        ssl.registerOperationHandler("remove", (OperationStepHandler)WebSSLRemove.INSTANCE, (DescriptionProvider)WebSSLRemove.INSTANCE, true);
        ssl.registerReadWriteAttribute("key-alias", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1, true), AttributeAccess.Storage.CONFIGURATION);
        ssl.registerReadWriteAttribute("password", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1, true), AttributeAccess.Storage.CONFIGURATION);
        ssl.registerReadWriteAttribute("certificate-key-file", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1, true), AttributeAccess.Storage.CONFIGURATION);
        ssl.registerReadWriteAttribute("cipher-suite", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1, true), AttributeAccess.Storage.CONFIGURATION);
        ssl.registerReadWriteAttribute("protocol", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1, true), AttributeAccess.Storage.CONFIGURATION);
        ssl.registerReadWriteAttribute("verify-client", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1, true), AttributeAccess.Storage.CONFIGURATION);
        ssl.registerReadWriteAttribute("verify-depth", null, (OperationStepHandler)new WriteAttributeHandlers.IntRangeValidatingHandler(1, true), AttributeAccess.Storage.CONFIGURATION);
        ssl.registerReadWriteAttribute("certificate-file", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1, true), AttributeAccess.Storage.CONFIGURATION);
        ssl.registerReadWriteAttribute("ca-certificate-file", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1, true), AttributeAccess.Storage.CONFIGURATION);
        ssl.registerReadWriteAttribute("ca-revocation-url", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1, true), AttributeAccess.Storage.CONFIGURATION);
        ssl.registerReadWriteAttribute("session-cache-size", null, (OperationStepHandler)new WriteAttributeHandlers.IntRangeValidatingHandler(0, true), AttributeAccess.Storage.CONFIGURATION);
        ssl.registerReadWriteAttribute("session-timeout", null, (OperationStepHandler)new WriteAttributeHandlers.IntRangeValidatingHandler(0, true), AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration hosts = registration.registerSubModel(hostPath, WebSubsystemDescriptionProviders.VIRTUAL_SERVER);
        hosts.registerOperationHandler("add", (OperationStepHandler)WebVirtualHostAdd.INSTANCE, (DescriptionProvider)WebVirtualHostAdd.INSTANCE, false);
        hosts.registerOperationHandler("remove", (OperationStepHandler)WebVirtualHostRemove.INSTANCE, (DescriptionProvider)WebVirtualHostRemove.INSTANCE, false);
        hosts.registerReadWriteAttribute("alias", null, (OperationStepHandler)new WriteAttributeHandlers.ListValidatatingHandler((ParameterValidator)new StringLengthValidator(1, false), true), AttributeAccess.Storage.CONFIGURATION);
        hosts.registerReadWriteAttribute("enable-welcome-root", null, (OperationStepHandler)WriteEnableWelcomeRoot.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        hosts.registerReadWriteAttribute("default-web-module", null, (OperationStepHandler)WriteDefaultWebModule.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration accesslog = hosts.registerSubModel(accesslogPath, WebSubsystemDescriptionProviders.ACCESS_LOG);
        accesslog.registerOperationHandler("add", (OperationStepHandler)WebAccessLogAdd.INSTANCE, (DescriptionProvider)WebAccessLogAdd.INSTANCE, true);
        accesslog.registerOperationHandler("remove", (OperationStepHandler)WebAccessLogRemove.INSTANCE, (DescriptionProvider)WebAccessLogRemove.INSTANCE, true);
        ManagementResourceRegistration directory = accesslog.registerSubModel(directoryPath, WebSubsystemDescriptionProviders.DIRECTORY);
        directory.registerReadWriteAttribute("relative-to", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1, true), AttributeAccess.Storage.CONFIGURATION);
        directory.registerReadWriteAttribute("path", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1, true), AttributeAccess.Storage.CONFIGURATION);
        accesslog.registerReadWriteAttribute("pattern", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1, true), AttributeAccess.Storage.CONFIGURATION);
        accesslog.registerReadWriteAttribute("resolve-hosts", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN, true), AttributeAccess.Storage.CONFIGURATION);
        accesslog.registerReadWriteAttribute("extended", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN, true), AttributeAccess.Storage.CONFIGURATION);
        accesslog.registerReadWriteAttribute("prefix", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1, true), AttributeAccess.Storage.CONFIGURATION);
        accesslog.registerReadWriteAttribute("rotate", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1, true), AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration sso = hosts.registerSubModel(ssoPath, WebSubsystemDescriptionProviders.SSO);
        sso.registerOperationHandler("add", (OperationStepHandler)WebSSOAdd.INSTANCE, (DescriptionProvider)WebSSOAdd.INSTANCE, false);
        sso.registerOperationHandler("remove", (OperationStepHandler)WebSSORemove.INSTANCE, (DescriptionProvider)WebSSORemove.INSTANCE, false);
        sso.registerReadWriteAttribute("cache-container", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1, true), AttributeAccess.Storage.CONFIGURATION);
        sso.registerReadWriteAttribute("domain", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1, true), AttributeAccess.Storage.CONFIGURATION);
        sso.registerReadWriteAttribute("reauthenticate", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN, true), AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration rewrite = hosts.registerSubModel(rewritePath, WebSubsystemDescriptionProviders.REWRITE);
        rewrite.registerOperationHandler("add", (OperationStepHandler)WebReWriteAdd.INSTANCE, (DescriptionProvider)WebReWriteAdd.INSTANCE, false);
        rewrite.registerOperationHandler("remove", (OperationStepHandler)WebReWriteRemove.INSTANCE, (DescriptionProvider)WebReWriteRemove.INSTANCE, false);
        ManagementResourceRegistration rewritecondition = rewrite.registerSubModel(rewritecondPath, WebSubsystemDescriptionProviders.REWRITECOND);
        rewritecondition.registerOperationHandler("add", (OperationStepHandler)WebReWriteConditionAdd.INSTANCE, (DescriptionProvider)WebReWriteConditionAdd.INSTANCE, false);
        rewritecondition.registerOperationHandler("remove", (OperationStepHandler)WebReWriteConditionRemove.INSTANCE, (DescriptionProvider)WebReWriteConditionRemove.INSTANCE, false);
        rewritecondition.registerReadWriteAttribute("test", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1, true), AttributeAccess.Storage.CONFIGURATION);
        rewritecondition.registerReadWriteAttribute("pattern", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1, true), AttributeAccess.Storage.CONFIGURATION);
        rewritecondition.registerReadWriteAttribute("flags", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1, true), AttributeAccess.Storage.CONFIGURATION);
        rewrite.registerReadWriteAttribute("condition", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1, true), AttributeAccess.Storage.CONFIGURATION);
        rewrite.registerReadWriteAttribute("pattern", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1, true), AttributeAccess.Storage.CONFIGURATION);
        rewrite.registerReadWriteAttribute("substitution", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1, true), AttributeAccess.Storage.CONFIGURATION);
        rewrite.registerReadWriteAttribute("flags", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1, true), AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration jsp = registration.registerSubModel(jspconfigurationPath, WebSubsystemDescriptionProviders.JSP_CONFIGURATION);
        WebConfigurationHandlerUtils.initJSPAttributes(jsp);
        ManagementResourceRegistration resources = registration.registerSubModel(resourcesPath, WebSubsystemDescriptionProviders.STATIC_RESOURCES);
        WebConfigurationHandlerUtils.initResourcesAttribtues(resources);
        ManagementResourceRegistration container = registration.registerSubModel(containerPath, WebSubsystemDescriptionProviders.CONTAINER);
        container.registerOperationHandler("add-mime", (OperationStepHandler)MimeMappingAdd.INSTANCE, (DescriptionProvider)MimeMappingAdd.INSTANCE, false);
        container.registerOperationHandler("remove-mime", (OperationStepHandler)MimeMappingRemove.INSTANCE, (DescriptionProvider)MimeMappingRemove.INSTANCE, false);
        container.registerReadWriteAttribute("welcome-file", null, (OperationStepHandler)new WriteAttributeHandlers.ListValidatatingHandler((ParameterValidator)new StringLengthValidator(1, false), true), AttributeAccess.Storage.CONFIGURATION);
        if (registerRuntimeOnly) {
            ManagementResourceRegistration deployments = subsystem.registerDeploymentModel(WebSubsystemDescriptionProviders.DEPLOYMENT);
            ManagementResourceRegistration servlets = deployments.registerSubModel(PathElement.pathElement((String)"servlet"), WebSubsystemDescriptionProviders.SERVLET);
            ServletDeploymentStats.register(servlets);
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.WEB_1_1.getUriString(), (XMLElementReader)WebSubsystemParser.getInstance());
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.WEB_1_0.getUriString(), (XMLElementReader)WebSubsystemParser.getInstance());
    }
}

