/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.ee.structure.SpecDescriptorPropertyReplacement;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.web.WebMessages;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.metadata.parser.servlet.WebFragmentMetaDataParser;
import org.jboss.metadata.parser.util.NoopXMLResolver;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.metadata.web.spec.WebFragmentMetaData;
import org.jboss.vfs.VirtualFile;

public class WebFragmentParsingDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final String WEB_FRAGMENT_XML = "META-INF/web-fragment.xml";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        assert (warMetaData != null);
        Map<String, WebFragmentMetaData> webFragments = warMetaData.getWebFragmentsMetaData();
        if (webFragments == null) {
            webFragments = new HashMap<String, WebFragmentMetaData>();
            warMetaData.setWebFragmentsMetaData(webFragments);
        }
        List resourceRoots = DeploymentUtils.allResourceRoots((DeploymentUnit)deploymentUnit);
        for (ResourceRoot resourceRoot : resourceRoots) {
            VirtualFile webFragment;
            if (!resourceRoot.getRoot().getName().toLowerCase(Locale.ENGLISH).endsWith(".jar") || !(webFragment = resourceRoot.getRoot().getChild(WEB_FRAGMENT_XML)).exists() || !webFragment.isFile()) continue;
            InputStream is = null;
            try {
                is = webFragment.openStream();
                XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                inputFactory.setXMLResolver(NoopXMLResolver.create());
                XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(is);
                webFragments.put(resourceRoot.getRootName(), WebFragmentMetaDataParser.parse((XMLStreamReader)xmlReader, (PropertyReplacer)SpecDescriptorPropertyReplacement.propertyReplacer((DeploymentUnit)deploymentUnit)));
            }
            catch (XMLStreamException e) {
                throw new DeploymentUnitProcessingException(WebMessages.MESSAGES.failToParseXMLDescriptor(webFragment, e.getLocation().getLineNumber(), e.getLocation().getColumnNumber()));
            }
            catch (IOException e) {
                throw new DeploymentUnitProcessingException(WebMessages.MESSAGES.failToParseXMLDescriptor(webFragment), (Throwable)e);
            }
            finally {
                try {
                    if (is == null) continue;
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

