/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers.annotation;

import org.jboss.as.ee.component.InjectionTargetDescription;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.webservices.deployers.annotation.AbstractWebServiceRefAnnotation;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;

public class WebServiceRefMethodAnnotation
extends AbstractWebServiceRefAnnotation<MethodInfo> {
    public WebServiceRefMethodAnnotation(CompositeIndex index) {
        super(index);
    }

    @Override
    public String getName(MethodInfo methodInfo) {
        String name = methodInfo.name().substring(3);
        name = name.length() > 1 ? name.substring(0, 1).toLowerCase() + name.substring(1) : name.toLowerCase();
        return methodInfo.declaringClass().name().toString() + "/" + name;
    }

    @Override
    public InjectionTargetDescription.Type getInjectionType() {
        return InjectionTargetDescription.Type.METHOD;
    }

    @Override
    protected String getInjectionName(MethodInfo methodInfo) {
        return methodInfo.name();
    }

    @Override
    protected String getType(MethodInfo methodInfo) {
        if (methodInfo.args().length != 1) {
            throw new IllegalStateException("The method requires one parameter: " + methodInfo.name());
        }
        return methodInfo.args()[0].name().toString();
    }

    @Override
    protected ClassInfo getTypeInfo(MethodInfo methodInfo) {
        if (methodInfo.args().length != 1) {
            throw new IllegalStateException("The method requires one parameter: " + methodInfo.name());
        }
        return this.index.getClassByName(methodInfo.args()[0].name());
    }

    @Override
    public String getDeclaringClass(MethodInfo methodInfo) {
        return methodInfo.declaringClass().name().toString();
    }
}

