/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers.deployment;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.webservices.deployers.deployment.DeploymentModelBuilder;
import org.jboss.as.webservices.deployers.deployment.DeploymentModelBuilderJAXRPC_EJB21;
import org.jboss.as.webservices.deployers.deployment.DeploymentModelBuilderJAXRPC_JSE;
import org.jboss.as.webservices.deployers.deployment.DeploymentModelBuilderJAXWS_EJB3;
import org.jboss.as.webservices.deployers.deployment.DeploymentModelBuilderJAXWS_JMS;
import org.jboss.as.webservices.deployers.deployment.DeploymentModelBuilderJAXWS_JSE;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.wsf.spi.deployment.Deployment;

public final class WSDeploymentBuilder {
    private static final WSDeploymentBuilder SINGLETON = new WSDeploymentBuilder();
    private static final Map<Deployment.DeploymentType, DeploymentModelBuilder> builders = new HashMap<Deployment.DeploymentType, DeploymentModelBuilder>();

    private WSDeploymentBuilder() {
    }

    public static WSDeploymentBuilder getInstance() {
        return SINGLETON;
    }

    public void build(DeploymentUnit unit) {
        Deployment.DeploymentType deploymentType = ASHelper.getOptionalAttachment(unit, WSAttachmentKeys.DEPLOYMENT_TYPE_KEY);
        if (deploymentType != null) {
            builders.get(deploymentType).newDeploymentModel(unit);
        }
    }

    static {
        builders.put(Deployment.DeploymentType.JAXWS_JSE, new DeploymentModelBuilderJAXWS_JSE());
        builders.put(Deployment.DeploymentType.JAXRPC_JSE, new DeploymentModelBuilderJAXRPC_JSE());
        builders.put(Deployment.DeploymentType.JAXWS_EJB3, new DeploymentModelBuilderJAXWS_EJB3());
        builders.put(Deployment.DeploymentType.JAXRPC_EJB21, new DeploymentModelBuilderJAXRPC_EJB21());
        builders.put(Deployment.DeploymentType.JAXWS_JMS, new DeploymentModelBuilderJAXWS_JMS());
    }
}

