/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jws.WebService;
import javax.xml.ws.WebServiceProvider;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.annotation.AnnotationIndexUtils;
import org.jboss.as.server.deployment.module.ModuleRootMarker;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.logging.Logger;
import org.jboss.metadata.common.jboss.WebserviceDescriptionMetaData;
import org.jboss.metadata.common.jboss.WebserviceDescriptionsMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.integration.WebServiceDeclaration;
import org.jboss.wsf.spi.deployment.integration.WebServiceDeployment;

public final class ASHelper {
    public static final String CONTAINER_NAME = "org.jboss.wsf.spi.invocation.ContainerName";
    private static final Logger LOGGER = Logger.getLogger(ASHelper.class);

    private ASHelper() {
    }

    public static boolean isWebServiceDeployment(DeploymentUnit unit) {
        return ASHelper.getOptionalAttachment(unit, WSAttachmentKeys.DEPLOYMENT_TYPE_KEY) != null;
    }

    public static boolean isJaxrpcEjbDeployment(DeploymentUnit unit) {
        Deployment.DeploymentType deploymentType = ASHelper.getOptionalAttachment(unit, WSAttachmentKeys.DEPLOYMENT_TYPE_KEY);
        return Deployment.DeploymentType.JAXRPC_EJB21.equals((Object)deploymentType);
    }

    public static boolean isJaxrpcJseDeployment(DeploymentUnit unit) {
        Deployment.DeploymentType deploymentType = ASHelper.getOptionalAttachment(unit, WSAttachmentKeys.DEPLOYMENT_TYPE_KEY);
        return Deployment.DeploymentType.JAXRPC_JSE.equals((Object)deploymentType);
    }

    public static boolean isJaxwsEjbDeployment(DeploymentUnit unit) {
        Deployment.DeploymentType deploymentType = ASHelper.getOptionalAttachment(unit, WSAttachmentKeys.DEPLOYMENT_TYPE_KEY);
        return Deployment.DeploymentType.JAXWS_EJB3.equals((Object)deploymentType);
    }

    public static boolean isJaxwsJseDeployment(DeploymentUnit unit) {
        Deployment.DeploymentType deploymentType = ASHelper.getOptionalAttachment(unit, WSAttachmentKeys.DEPLOYMENT_TYPE_KEY);
        return Deployment.DeploymentType.JAXWS_JSE.equals((Object)deploymentType);
    }

    public static boolean isJseDeployment(DeploymentUnit unit) {
        boolean isJaxwsJse = ASHelper.isJaxwsJseDeployment(unit);
        boolean isJaxrpcJse = ASHelper.isJaxrpcJseDeployment(unit);
        return isJaxwsJse || isJaxrpcJse;
    }

    public static boolean isEjbDeployment(DeploymentUnit unit) {
        boolean isJaxwsEjb = ASHelper.isJaxwsEjbDeployment(unit);
        boolean isJaxrpcEjb = ASHelper.isJaxrpcEjbDeployment(unit);
        return isJaxwsEjb || isJaxrpcEjb;
    }

    public static boolean isJaxwsDeployment(DeploymentUnit unit) {
        boolean isJaxwsEjb = ASHelper.isJaxwsEjbDeployment(unit);
        boolean isJaxwsJse = ASHelper.isJaxwsJseDeployment(unit);
        return isJaxwsEjb || isJaxwsJse;
    }

    public static boolean isJaxrpcDeployment(DeploymentUnit unit) {
        boolean isJaxrpcEjb = ASHelper.isJaxrpcEjbDeployment(unit);
        boolean isJaxrpcJse = ASHelper.isJaxrpcJseDeployment(unit);
        return isJaxrpcEjb || isJaxrpcJse;
    }

    public static List<ServletMetaData> getJaxwsServlets(DeploymentUnit unit) {
        return ASHelper.getWebServiceServlets(unit, true);
    }

    public static List<ServletMetaData> getJaxrpcServlets(DeploymentUnit unit) {
        return ASHelper.getWebServiceServlets(unit, false);
    }

    public static List<WebServiceDeclaration> getJaxwsEjbs(DeploymentUnit unit) {
        WebServiceDeployment wsDeployment = ASHelper.getRequiredAttachment(unit, WSAttachmentKeys.WEBSERVICE_DEPLOYMENT_KEY);
        return Collections.unmodifiableList(wsDeployment.getServiceEndpoints());
    }

    public static String getEndpointName(ServletMetaData servletMD) {
        String endpointClass = servletMD.getServletClass();
        return endpointClass != null ? endpointClass.trim() : null;
    }

    public static ServletMetaData getServletForName(JBossWebMetaData jbossWebMD, String servletName) {
        for (JBossServletMetaData servlet : jbossWebMD.getServlets()) {
            if (!servlet.getName().equals(servletName)) continue;
            return servlet;
        }
        throw new IllegalStateException("Cannot find servlet for link: " + servletName);
    }

    public static <A> A getRequiredAttachment(DeploymentUnit unit, AttachmentKey<A> key) {
        Object value = unit.getAttachment(key);
        if (value == null) {
            LOGGER.error((Object)("Cannot find attachment in deployment unit: " + key));
            throw new IllegalStateException();
        }
        return (A)value;
    }

    public static <A> A getOptionalAttachment(DeploymentUnit unit, AttachmentKey<A> key) {
        return (A)unit.getAttachment(key);
    }

    public static boolean hasAttachment(DeploymentUnit unit, AttachmentKey<?> key) {
        return ASHelper.getOptionalAttachment(unit, key) != null;
    }

    public static WebserviceDescriptionMetaData getWebserviceDescriptionMetaData(WebserviceDescriptionsMetaData wsDescriptionsMD) {
        if (wsDescriptionsMD != null) {
            if (wsDescriptionsMD.size() > 1) {
                LOGGER.warn((Object)"Multiple <webservice-description> elements not supported");
            }
            if (wsDescriptionsMD.size() > 0) {
                return (WebserviceDescriptionMetaData)wsDescriptionsMD.iterator().next();
            }
        }
        return null;
    }

    private static List<ServletMetaData> getWebServiceServlets(DeploymentUnit unit, boolean jaxws) {
        JBossWebMetaData jbossWebMD = ASHelper.getJBossWebMetaData(unit);
        Index annotationIndex = ASHelper.getRootAnnotationIndex(unit);
        return ASHelper.selectWebServiceServlets(annotationIndex, jbossWebMD.getServlets(), jaxws);
    }

    public static <T extends ServletMetaData> List<ServletMetaData> selectWebServiceServlets(Index annotationIndex, Collection<T> smd, boolean jaxws) {
        ArrayList<ServletMetaData> endpoints = new ArrayList<ServletMetaData>();
        DotName webserviceAnnotation = DotName.createSimple((String)WebService.class.getName());
        DotName webserviceProviderAnnotation = DotName.createSimple((String)WebServiceProvider.class.getName());
        if (smd != null) {
            for (ServletMetaData servletMD : smd) {
                boolean isJaxrpcEndpoint;
                ClassInfo ci;
                String endpointClassName = ASHelper.getEndpointName(servletMD);
                if (endpointClassName == null || endpointClassName.length() <= 0) continue;
                Map map = null;
                if (annotationIndex != null && (ci = annotationIndex.getClassByName(DotName.createSimple((String)endpointClassName))) != null) {
                    map = ci.annotations();
                }
                if (map == null) {
                    map = new HashMap();
                }
                boolean isWebService = map.containsKey(webserviceAnnotation);
                boolean isWebServiceProvider = map.containsKey(webserviceProviderAnnotation);
                boolean isJaxwsEndpoint = jaxws && (isWebService || isWebServiceProvider);
                boolean bl = isJaxrpcEndpoint = !jaxws && !isWebService && !isWebServiceProvider;
                if (!isJaxwsEndpoint && !isJaxrpcEndpoint) continue;
                endpoints.add(servletMD);
            }
        }
        return endpoints;
    }

    public static JBossWebMetaData getJBossWebMetaData(DeploymentUnit unit) {
        WarMetaData warMetaData = (WarMetaData)ASHelper.getOptionalAttachment(unit, WarMetaData.ATTACHMENT_KEY);
        JBossWebMetaData result = null;
        if (warMetaData != null && (result = warMetaData.getMergedJBossWebMetaData()) == null) {
            result = warMetaData.getJbossWebMetaData();
        }
        return result;
    }

    public static Index getRootAnnotationIndex(DeploymentUnit unit) {
        Map indexes = AnnotationIndexUtils.getAnnotationIndexes((DeploymentUnit)unit);
        for (ResourceRoot rr : indexes.keySet()) {
            if (!ModuleRootMarker.isModuleRoot((ResourceRoot)rr)) continue;
            return (Index)indexes.get(rr);
        }
        return null;
    }
}

