/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers;

import java.util.List;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.as.webservices.WSLogger;
import org.jboss.as.webservices.deployers.SecurityActions;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;

public final class AspectDeploymentProcessor
implements DeploymentUnitProcessor {
    private Class<? extends DeploymentAspect> clazz;
    private String aspectClass;
    private DeploymentAspect aspect;

    public AspectDeploymentProcessor(Class<? extends DeploymentAspect> aspectClass) {
        this.clazz = aspectClass;
    }

    public AspectDeploymentProcessor(String aspectClass) {
        this.aspectClass = aspectClass;
    }

    public AspectDeploymentProcessor(DeploymentAspect aspect) {
        this.aspect = aspect;
        this.clazz = aspect.getClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        if (AspectDeploymentProcessor.isWebServiceDeployment(unit)) {
            this.ensureAspectInitialized();
            Deployment dep = ASHelper.getRequiredAttachment(unit, WSAttachmentKeys.DEPLOYMENT_KEY);
            if (this.aspect.canHandle(dep)) {
                WSLogger.ROOT_LOGGER.aspectStart(this.aspect, unit.getName());
                ClassLoader origClassLoader = SecurityActions.getContextClassLoader();
                List setupActions = unit.getAttachmentList(Attachments.EE_SETUP_ACTIONS);
                try {
                    SecurityActions.setContextClassLoader(this.aspect.getLoader());
                    dep.addAttachment(ServiceTarget.class, (Object)phaseContext.getServiceTarget());
                    for (SetupAction action : setupActions) {
                        action.setup(null);
                    }
                    this.aspect.start(dep);
                    dep.removeAttachment(ServiceTarget.class);
                }
                finally {
                    for (SetupAction action : setupActions) {
                        action.teardown(null);
                    }
                    SecurityActions.setContextClassLoader(origClassLoader);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(DeploymentUnit unit) {
        Deployment dep;
        if (AspectDeploymentProcessor.isWebServiceDeployment(unit) && this.aspect.canHandle(dep = ASHelper.getRequiredAttachment(unit, WSAttachmentKeys.DEPLOYMENT_KEY))) {
            WSLogger.ROOT_LOGGER.aspectStop(this.aspect, unit.getName());
            ClassLoader origClassLoader = SecurityActions.getContextClassLoader();
            try {
                SecurityActions.setContextClassLoader(this.aspect.getLoader());
                this.aspect.stop(dep);
            }
            finally {
                SecurityActions.setContextClassLoader(origClassLoader);
            }
        }
    }

    private void ensureAspectInitialized() throws DeploymentUnitProcessingException {
        if (this.aspect == null) {
            try {
                if (this.clazz == null) {
                    this.clazz = ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader().loadClass(this.aspectClass);
                }
                this.aspect = this.clazz.newInstance();
            }
            catch (Exception e) {
                throw new DeploymentUnitProcessingException((Throwable)e);
            }
        }
    }

    private static boolean isWebServiceDeployment(DeploymentUnit unit) {
        return unit.getAttachment(WSAttachmentKeys.DEPLOYMENT_KEY) != null;
    }
}

