/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.webservices.dmr.EndpointConfigAdd;
import org.jboss.as.webservices.dmr.EndpointConfigRemove;
import org.jboss.as.webservices.dmr.HandlerAdd;
import org.jboss.as.webservices.dmr.HandlerChainAdd;
import org.jboss.as.webservices.dmr.HandlerChainRemove;
import org.jboss.as.webservices.dmr.HandlerRemove;
import org.jboss.as.webservices.dmr.Namespace;
import org.jboss.as.webservices.dmr.PropertyAdd;
import org.jboss.as.webservices.dmr.PropertyRemove;
import org.jboss.as.webservices.dmr.WSEndpointMetrics;
import org.jboss.as.webservices.dmr.WSSubsystemAdd;
import org.jboss.as.webservices.dmr.WSSubsystemAttributeChangeHandler;
import org.jboss.as.webservices.dmr.WSSubsystemDescribe;
import org.jboss.as.webservices.dmr.WSSubsystemLegacyReader;
import org.jboss.as.webservices.dmr.WSSubsystemProviders;
import org.jboss.as.webservices.dmr.WSSubsystemReader;
import org.jboss.as.webservices.dmr.WSSubsystemRemove;
import org.jboss.as.webservices.dmr.WSSubsystemWriter;
import org.jboss.dmr.ModelType;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public final class WSExtension
implements Extension {
    private static final PathElement endpointPath = PathElement.pathElement((String)"endpoint");
    private static final PathElement endpointConfigPath = PathElement.pathElement((String)"endpoint-config");
    private static final PathElement propertyPath = PathElement.pathElement((String)"property");
    private static final PathElement preHandlerChainPath = PathElement.pathElement((String)"pre-handler-chain");
    private static final PathElement postHandlerChainPath = PathElement.pathElement((String)"post-handler-chain");
    private static final PathElement handlerPath = PathElement.pathElement((String)"handler");
    private static final ReloadRequiredWriteAttributeHandler reloadRequiredAttributeHandler = new ReloadRequiredWriteAttributeHandler();
    public static final String SUBSYSTEM_NAME = "webservices";
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 1;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;

    public void initialize(ExtensionContext context) {
        boolean registerRuntimeOnly = context.isRuntimeOnlyRegistrationValid();
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 1, 1, 0);
        subsystem.registerXMLElementWriter((XMLElementWriter)WSSubsystemWriter.getInstance());
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel(WSSubsystemProviders.SUBSYSTEM);
        registration.registerOperationHandler("add", (OperationStepHandler)WSSubsystemAdd.INSTANCE, WSSubsystemProviders.SUBSYSTEM_ADD, false);
        registration.registerOperationHandler("describe", (OperationStepHandler)WSSubsystemDescribe.INSTANCE, WSSubsystemProviders.SUBSYSTEM_DESCRIBE, false, OperationEntry.EntryType.PRIVATE);
        registration.registerOperationHandler("remove", (OperationStepHandler)WSSubsystemRemove.INSTANCE, WSSubsystemProviders.SUBSYSTEM_REMOVE, false);
        registration.registerReadWriteAttribute("wsdl-host", null, (OperationStepHandler)new WSSubsystemAttributeChangeHandler((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true)), AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute("wsdl-port", null, (OperationStepHandler)new WSSubsystemAttributeChangeHandler((ParameterValidator)new IntRangeValidator(1, Integer.MAX_VALUE, true, true)), AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute("wsdl-secure-port", null, (OperationStepHandler)new WSSubsystemAttributeChangeHandler((ParameterValidator)new IntRangeValidator(1, Integer.MAX_VALUE, true, true)), AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute("modify-wsdl-address", null, (OperationStepHandler)new WSSubsystemAttributeChangeHandler((ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN, true)), AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration endpointConfig = registration.registerSubModel(endpointConfigPath, WSSubsystemProviders.ENDPOINT_CONFIG_DESCRIPTION);
        endpointConfig.registerOperationHandler("add", (OperationStepHandler)EndpointConfigAdd.INSTANCE, WSSubsystemProviders.ENDPOINT_CONFIG_ADD_DESCRIPTION, false);
        endpointConfig.registerOperationHandler("remove", (OperationStepHandler)EndpointConfigRemove.INSTANCE, WSSubsystemProviders.ENDPOINT_CONFIG_REMOVE_DESCRIPTION, false);
        ManagementResourceRegistration property = endpointConfig.registerSubModel(propertyPath, WSSubsystemProviders.PROPERTY_DESCRIPTION);
        property.registerOperationHandler("add", (OperationStepHandler)PropertyAdd.INSTANCE, WSSubsystemProviders.PROPERTY_ADD_DESCRIPTION, false);
        property.registerOperationHandler("remove", (OperationStepHandler)PropertyRemove.INSTANCE, WSSubsystemProviders.PROPERTY_REMOVE_DESCRIPTION, false);
        property.registerReadWriteAttribute("value", null, (OperationStepHandler)reloadRequiredAttributeHandler, AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration preHandlerChain = endpointConfig.registerSubModel(preHandlerChainPath, WSSubsystemProviders.PRE_HANDLER_CHAIN_DESCRIPTION);
        preHandlerChain.registerOperationHandler("add", (OperationStepHandler)HandlerChainAdd.INSTANCE, WSSubsystemProviders.PRE_HANDLER_CHAIN_ADD_DESCRIPTION, false);
        preHandlerChain.registerOperationHandler("remove", (OperationStepHandler)HandlerChainRemove.INSTANCE, WSSubsystemProviders.PRE_HANDLER_CHAIN_REMOVE_DESCRIPTION, false);
        preHandlerChain.registerReadWriteAttribute("protocol-bindings", null, (OperationStepHandler)reloadRequiredAttributeHandler, AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration preHandler = preHandlerChain.registerSubModel(handlerPath, WSSubsystemProviders.HANDLER_DESCRIPTION);
        preHandler.registerOperationHandler("add", (OperationStepHandler)HandlerAdd.INSTANCE, WSSubsystemProviders.HANDLER_ADD_DESCRIPTION, false);
        preHandler.registerOperationHandler("remove", (OperationStepHandler)HandlerRemove.INSTANCE, WSSubsystemProviders.HANDLER_REMOVE_DESCRIPTION, false);
        preHandler.registerReadWriteAttribute("class", null, (OperationStepHandler)reloadRequiredAttributeHandler, AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration postHandlerChain = endpointConfig.registerSubModel(postHandlerChainPath, WSSubsystemProviders.POST_HANDLER_CHAIN_DESCRIPTION);
        postHandlerChain.registerOperationHandler("add", (OperationStepHandler)HandlerChainAdd.INSTANCE, WSSubsystemProviders.POST_HANDLER_CHAIN_ADD_DESCRIPTION, false);
        postHandlerChain.registerOperationHandler("remove", (OperationStepHandler)HandlerChainRemove.INSTANCE, WSSubsystemProviders.POST_HANDLER_CHAIN_REMOVE_DESCRIPTION, false);
        postHandlerChain.registerReadWriteAttribute("protocol-bindings", null, (OperationStepHandler)reloadRequiredAttributeHandler, AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration postHandler = postHandlerChain.registerSubModel(handlerPath, WSSubsystemProviders.HANDLER_DESCRIPTION);
        postHandler.registerOperationHandler("add", (OperationStepHandler)HandlerAdd.INSTANCE, WSSubsystemProviders.HANDLER_ADD_DESCRIPTION, false);
        postHandler.registerOperationHandler("remove", (OperationStepHandler)HandlerRemove.INSTANCE, WSSubsystemProviders.HANDLER_REMOVE_DESCRIPTION, false);
        postHandler.registerReadWriteAttribute("class", null, (OperationStepHandler)reloadRequiredAttributeHandler, AttributeAccess.Storage.CONFIGURATION);
        if (registerRuntimeOnly) {
            ManagementResourceRegistration deployments = subsystem.registerDeploymentModel(WSSubsystemProviders.DEPLOYMENT_DESCRIPTION);
            ManagementResourceRegistration endpoints = deployments.registerSubModel(endpointPath, WSSubsystemProviders.ENDPOINT_DESCRIPTION);
            for (String attributeName : WSEndpointMetrics.ATTRIBUTES) {
                endpoints.registerMetric(attributeName, (OperationStepHandler)WSEndpointMetrics.INSTANCE);
            }
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.WEBSERVICES_1_0.getUriString(), (XMLElementReader)WSSubsystemLegacyReader.getInstance());
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.WEBSERVICES_1_1.getUriString(), (XMLElementReader)WSSubsystemReader.getInstance());
    }
}

