/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployer;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.client.helpers.standalone.DeploymentAction;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlan;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.InitialDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentActionResult;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentPlanResult;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.deployer.Deployer;

public final class RemoteDeployer
implements Deployer {
    private static final Logger LOGGER = Logger.getLogger(RemoteDeployer.class);
    private final Map<URL, String> url2Id = new HashMap<URL, String>();
    private ServerDeploymentManager deploymentManager;

    public RemoteDeployer() throws IOException {
        InetAddress address = InetAddress.getByName("127.0.0.1");
        this.deploymentManager = ServerDeploymentManager.Factory.create((InetAddress)address, (int)9999);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(URL archiveURL) throws Exception {
        DeploymentPlanBuilder builder = this.deploymentManager.newDeploymentPlan().add(archiveURL).andDeploy();
        DeploymentPlan plan = builder.build();
        DeploymentAction deployAction = builder.getLastAction();
        String uniqueId = deployAction.getDeploymentUnitUniqueName();
        try {
            this.executeDeploymentPlan(plan, deployAction);
        }
        finally {
            this.url2Id.put(archiveURL, uniqueId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(URL archiveURL) throws Exception {
        InitialDeploymentPlanBuilder builder = this.deploymentManager.newDeploymentPlan();
        String uniqueName = this.url2Id.get(archiveURL);
        DeploymentPlan plan = builder.undeploy(uniqueName).remove(uniqueName).build();
        DeploymentAction deployAction = builder.getLastAction();
        try {
            this.executeDeploymentPlan(plan, deployAction);
        }
        finally {
            this.url2Id.remove(archiveURL);
        }
    }

    private void executeDeploymentPlan(DeploymentPlan plan, DeploymentAction deployAction) throws Exception {
        try {
            Exception deploymentException;
            ServerDeploymentActionResult actionResult;
            ServerDeploymentPlanResult planResult = (ServerDeploymentPlanResult)this.deploymentManager.execute(plan).get();
            if (deployAction != null && (actionResult = planResult.getDeploymentActionResult(deployAction.getId())) != null && (deploymentException = (Exception)actionResult.getDeploymentException()) != null) {
                throw deploymentException;
            }
        }
        catch (Exception e) {
            LOGGER.fatal((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }
}

