/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.websockets.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.as.websockets.Handshake;
import org.jboss.as.websockets.WebSocket;
import org.jboss.as.websockets.WebSocketHeaders;
import org.jboss.as.websockets.protocol.ietf00.Hybi00Handshake;
import org.jboss.as.websockets.protocol.ietf07.Hybi07Handshake;
import org.jboss.as.websockets.protocol.ietf08.Hybi08Handshake;
import org.jboss.as.websockets.protocol.ietf13.Hybi13Handshake;
import org.jboss.servlet.http.HttpEvent;
import org.jboss.servlet.http.HttpEventServlet;
import org.jboss.servlet.http.UpgradableHttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebSocketServlet
extends HttpServlet
implements HttpEventServlet {
    private static final List<Handshake> websocketHandshakes;
    private static final Logger log;
    private String protocolName;
    private static final String SESSION_WEBSOCKET_HANDLE = "JBoss:Experimental:Websocket:Handle";

    private void setStandardUpgradeHeaders(HttpServletResponse response) {
        response.setHeader("Upgrade", "WebSocket");
        response.setHeader("Connection", "Upgrade");
        if (this.protocolName != null) {
            WebSocketHeaders.SEC_WEBSOCKET_PROTOCOL.set(response, this.protocolName);
        }
    }

    public final void event(HttpEvent event) throws IOException, ServletException {
        HttpServletRequest request = event.getHttpServletRequest();
        HttpServletResponse response = event.getHttpServletResponse();
        switch (event.getType()) {
            case BEGIN: {
                event.setTimeout(20000);
                log.debug("Begin Websocket Handshake");
                if (response instanceof UpgradableHttpServletResponse) {
                    for (Handshake handshake : websocketHandshakes) {
                        if (!handshake.matches(request)) continue;
                        this.setStandardUpgradeHeaders(response);
                        log.debug("Found a compatible handshake: (Version:" + handshake.getVersion() + "; Handler: " + handshake.getClass().getName() + ")");
                        byte[] handShakeData = handshake.generateResponse(event);
                        WebSocket webSocket = handshake.getWebSocket(event);
                        log.debug("Using WebSocket implementation: " + webSocket.getClass().getName());
                        request.setAttribute(SESSION_WEBSOCKET_HANDLE, (Object)webSocket);
                        if (handShakeData.length > 0) {
                            response.getOutputStream().write(handShakeData);
                            response.getOutputStream().flush();
                        }
                        ((UpgradableHttpServletResponse)response).sendUpgrade();
                        log.debug("Websocket opened for session: " + request.getSession().getId());
                        this.onSocketOpened(event, webSocket);
                    }
                    break;
                }
                throw new IllegalStateException("cannot upgrade connection");
            }
            case END: {
                break;
            }
            case ERROR: {
                event.close();
                break;
            }
            case EVENT: 
            case READ: {
                while (event.isReadReady()) {
                    this.onReceivedTextFrame(event, (WebSocket)request.getAttribute(SESSION_WEBSOCKET_HANDLE));
                }
                break;
            }
            case TIMEOUT: {
                event.resume();
                break;
            }
            case EOF: {
                this.onSocketClosed(event);
            }
        }
    }

    protected final void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doGet(req, resp);
    }

    protected final long getLastModified(HttpServletRequest req) {
        return super.getLastModified(req);
    }

    protected final void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doHead(req, resp);
    }

    protected final void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPost(req, resp);
    }

    protected final void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPut(req, resp);
    }

    protected final void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doDelete(req, resp);
    }

    protected final void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doOptions(req, resp);
    }

    protected final void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doTrace(req, resp);
    }

    protected final void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.service(req, resp);
    }

    public final void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        super.service(req, res);
    }

    protected void setProtocolName(String protocol) {
        this.protocolName = protocol;
    }

    protected abstract void onSocketOpened(HttpEvent var1, WebSocket var2) throws IOException;

    protected abstract void onSocketClosed(HttpEvent var1) throws IOException;

    protected abstract void onReceivedTextFrame(HttpEvent var1, WebSocket var2) throws IOException;

    static {
        log = LoggerFactory.getLogger(WebSocketServlet.class);
        ArrayList<Handshake> handshakeList = new ArrayList<Handshake>();
        handshakeList.add(new Hybi13Handshake());
        handshakeList.add(new Hybi07Handshake());
        handshakeList.add(new Hybi08Handshake());
        handshakeList.add(new Hybi00Handshake());
        websocketHandshakes = Collections.unmodifiableList(handshakeList);
    }
}

