/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.websockets.protocol.ietf00;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.as.websockets.AbstractWebSocket;
import org.jboss.as.websockets.Frame;
import org.jboss.as.websockets.FrameType;
import org.jboss.as.websockets.WebSocket;
import org.jboss.as.websockets.frame.TextFrame;
import org.jboss.as.websockets.protocol.ClosingStrategy;

public class Hybi00Socket
extends AbstractWebSocket {
    private static final int MAX_FRAME_SIZE = 32768;

    private Hybi00Socket(HttpServletRequest servletRequest, InputStream inputStream, OutputStream outputStream, ClosingStrategy closingStrategy) {
        super(servletRequest, inputStream, outputStream, closingStrategy);
    }

    public static WebSocket from(HttpServletRequest request, HttpServletResponse response, ClosingStrategy closingStrategy) throws IOException {
        return new Hybi00Socket(request, (InputStream)request.getInputStream(), (OutputStream)response.getOutputStream(), closingStrategy);
    }

    public void writeTextFrame(String text) throws IOException {
        this.outputStream.write(0);
        this.outputStream.write(text.getBytes("UTF-8"));
        this.outputStream.write(-1);
        this.outputStream.flush();
    }

    private String _readTextFrame() throws IOException {
        byte frametype = (byte)this.inputStream.read();
        if ((frametype & 0x80) == 128) {
            throw new RuntimeException("binary payload not supported");
        }
        if (frametype == 0) {
            int b;
            StringBuilder buf = new StringBuilder();
            int read = 0;
            while ((b = this.inputStream.read()) != 255) {
                if (++read > 32768) {
                    throw new RuntimeException("frame too large");
                }
                buf.append((char)b);
            }
            return buf.toString();
        }
        throw new RuntimeException("bad websockets payload");
    }

    public void writeFrame(Frame frame) throws IOException {
        if (frame.getType() == FrameType.Text) {
            this.writeTextFrame(((TextFrame)frame).getText());
        }
    }

    public Frame readFrame() throws IOException {
        return TextFrame.from(this._readTextFrame());
    }
}

