/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.websockets.protocol.ietf07;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.as.websockets.Handshake;
import org.jboss.as.websockets.WebSocket;
import org.jboss.as.websockets.WebSocketHeaders;
import org.jboss.as.websockets.protocol.ClosingStrategy;
import org.jboss.as.websockets.protocol.ietf07.Hybi07Socket;
import org.jboss.as.websockets.util.Base64;
import org.jboss.servlet.http.HttpEvent;

public class Hybi07Handshake
extends Handshake {
    protected Hybi07Handshake(String version) {
        super(version, "SHA1", "258EAFA5-E914-47DA-95CA-C5AB0DC85B11");
    }

    public Hybi07Handshake() {
        this("7");
    }

    public WebSocket getWebSocket(HttpServletRequest request, HttpServletResponse response, ClosingStrategy closingStrategy) throws IOException {
        return Hybi07Socket.from(request, response, closingStrategy);
    }

    public boolean matches(HttpServletRequest request) {
        return WebSocketHeaders.SEC_WEBSOCKET_KEY.isIn(request) && WebSocketHeaders.SEC_WEBSOCKET_VERSION.matches(request, this.getVersion());
    }

    public byte[] generateResponse(HttpEvent event) throws IOException {
        HttpServletRequest request = event.getHttpServletRequest();
        HttpServletResponse response = event.getHttpServletResponse();
        if (WebSocketHeaders.ORIGIN.isIn(request)) {
            WebSocketHeaders.SEC_WEBSOCKET_ORIGIN.set(response, WebSocketHeaders.ORIGIN.get(request));
        }
        WebSocketHeaders.SEC_WEBSOCKET_PROTOCOL.copy(request, response);
        WebSocketHeaders.SEC_WEBSOCKET_LOCATION.set(response, this.getWebSocketLocation(request));
        String key = WebSocketHeaders.SEC_WEBSOCKET_KEY.get(request);
        String solution = this.solve(key);
        WebSocketHeaders.SEC_WEBSOCKET_ACCEPT.set(response, solution);
        return new byte[0];
    }

    public String solve(String nonceBase64) {
        try {
            String concat = nonceBase64.trim().concat(this.getMagicNumber());
            MessageDigest digest = MessageDigest.getInstance(this.getHashAlgorithm());
            digest.update(concat.getBytes("UTF-8"));
            String result = Base64.encodeBase64String(digest.digest()).trim();
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("error generating hash", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("could not get UTF-8 bytes");
        }
    }
}

