/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.websockets.protocol.ietf13;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.as.websockets.AbstractWebSocket;
import org.jboss.as.websockets.Frame;
import org.jboss.as.websockets.FrameType;
import org.jboss.as.websockets.WebSocket;
import org.jboss.as.websockets.frame.BinaryFrame;
import org.jboss.as.websockets.frame.CloseFrame;
import org.jboss.as.websockets.frame.PingFrame;
import org.jboss.as.websockets.frame.PongFrame;
import org.jboss.as.websockets.frame.TextFrame;
import org.jboss.as.websockets.protocol.ClosingStrategy;

public class Hybi13Socket
extends AbstractWebSocket {
    private static final byte FRAME_OPCODE = 127;
    private static final byte FRAME_MASKED = -128;
    private static final byte FRAME_LENGTH = 127;

    public Hybi13Socket(HttpServletRequest servletRequest, InputStream inputStream, OutputStream outputStream, ClosingStrategy closingStrategy) {
        super(servletRequest, inputStream, outputStream, closingStrategy);
    }

    public static WebSocket from(HttpServletRequest request, HttpServletResponse response, ClosingStrategy closingStrategy) throws IOException {
        return new Hybi13Socket(request, (InputStream)request.getInputStream(), (OutputStream)response.getOutputStream(), closingStrategy);
    }

    private FrameType getNextFrameType() throws IOException {
        switch (this.inputStream.read() & 0x7F) {
            case 0: {
                return FrameType.Continuation;
            }
            case 1: {
                return FrameType.Text;
            }
            case 2: {
                return FrameType.Binary;
            }
            case 8: {
                return FrameType.ConnectionClose;
            }
            case 9: {
                return FrameType.Ping;
            }
            case 10: {
                return FrameType.Pong;
            }
        }
        return FrameType.Unknown;
    }

    private int getPayloadSize(int b) throws IOException {
        int payloadLength = b & 0x7F;
        if (payloadLength == 126) {
            payloadLength = ((this.inputStream.read() & 0xFF) << 8) + (this.inputStream.read() & 0xFF);
        } else if (payloadLength == 127) {
            this.inputStream.read();
            this.inputStream.read();
            this.inputStream.read();
            this.inputStream.read();
            payloadLength = ((this.inputStream.read() & 0xFF) << 24) + ((this.inputStream.read() & 0xFF) << 16) + ((this.inputStream.read() & 0xFF) << 8) + (this.inputStream.read() & 0xFF);
        }
        return payloadLength;
    }

    private String _readTextFrame() throws IOException {
        int b = this.inputStream.read();
        boolean frameMasked = (b & 0xFFFFFF80) != 0;
        int payloadLength = this.getPayloadSize(b);
        byte[] frameMaskingKey = new byte[4];
        if (frameMasked) {
            this.inputStream.read(frameMaskingKey);
        }
        StringBuilder payloadBuffer = new StringBuilder(payloadLength);
        int read = 0;
        if (frameMasked) {
            do {
                payloadBuffer.append((char)((this.inputStream.read() ^ frameMaskingKey[read % 4]) & 0x7F));
            } while (++read < payloadLength);
        } else {
            do {
                payloadBuffer.append((char)this.inputStream.read());
            } while (++read < payloadLength);
        }
        return payloadBuffer.toString();
    }

    public byte[] _readBinaryFrame() throws IOException {
        int b = this.inputStream.read();
        boolean frameMasked = (b & 0xFFFFFF80) != 0;
        int payloadLength = this.getPayloadSize(b);
        byte[] frameMaskingKey = new byte[4];
        if (frameMasked) {
            this.inputStream.read(frameMaskingKey);
        }
        byte[] buf = new byte[payloadLength];
        int read = 0;
        if (frameMasked) {
            do {
                buf[read] = (byte)((this.inputStream.read() ^ frameMaskingKey[read % 4]) & 0x7F);
            } while (++read < payloadLength);
        } else {
            do {
                buf[read] = (byte)this.inputStream.read();
            } while (++read < payloadLength);
        }
        return buf;
    }

    private void _writeTextFrame(String txt) throws IOException {
        byte[] strBytes = txt.getBytes("UTF-8");
        int len = strBytes.length;
        this.outputStream.write(-127);
        if (strBytes.length > Short.MAX_VALUE) {
            this.outputStream.write(127);
            this.outputStream.write(0);
            this.outputStream.write(0);
            this.outputStream.write(0);
            this.outputStream.write(0);
            this.outputStream.write((len & 0xFF) << 24);
            this.outputStream.write((len & 0xFF) << 16);
            this.outputStream.write((len & 0xFF) << 8);
            this.outputStream.write(len & 0xFF);
        } else if (strBytes.length > 125) {
            this.outputStream.write(126);
            this.outputStream.write(len >> 8 & 0xFF);
            this.outputStream.write(len & 0xFF);
        } else {
            this.outputStream.write(len & 0x7F);
        }
        for (byte strByte : strBytes) {
            this.outputStream.write(strByte);
        }
        this.outputStream.flush();
    }

    private void _writeBinaryFrame(byte[] data) throws IOException {
        int len = data.length;
        this.outputStream.write(-126);
        if (data.length > Short.MAX_VALUE) {
            this.outputStream.write(127);
            this.outputStream.write(0);
            this.outputStream.write(0);
            this.outputStream.write(0);
            this.outputStream.write(0);
            this.outputStream.write((len & 0xFF) << 24);
            this.outputStream.write((len & 0xFF) << 16);
            this.outputStream.write((len & 0xFF) << 8);
            this.outputStream.write(len & 0xFF);
        } else if (data.length > 125) {
            this.outputStream.write(126);
            this.outputStream.write(len >> 8 & 0xFF);
            this.outputStream.write(len & 0xFF);
        } else {
            this.outputStream.write(len & 0x7F);
        }
        for (byte b : data) {
            this.outputStream.write(b);
        }
        this.outputStream.flush();
    }

    private void _sendConnectionClose() throws IOException {
        this.outputStream.write(-120);
        this.outputStream.write(125);
        this.outputStream.flush();
    }

    private void _sendPing() throws IOException {
        this.outputStream.write(-119);
        this.outputStream.write(125);
        this.outputStream.flush();
    }

    private void _sendPong() throws IOException {
        this.outputStream.write(-118);
        this.outputStream.write(125);
        this.outputStream.flush();
    }

    public Frame readFrame() throws IOException {
        switch (this.getNextFrameType()) {
            case Text: {
                return TextFrame.from(this._readTextFrame());
            }
            case Binary: {
                return BinaryFrame.from(this._readBinaryFrame());
            }
            case Ping: {
                return new PingFrame();
            }
            case Pong: {
                return new PongFrame();
            }
            case ConnectionClose: {
                this.closeSocket();
                return new CloseFrame();
            }
        }
        throw new IOException("unknown frame type");
    }

    public void writeFrame(Frame frame) throws IOException {
        switch (frame.getType()) {
            case Text: {
                this._writeTextFrame(((TextFrame)frame).getText());
                break;
            }
            case Binary: {
                this._writeBinaryFrame(((BinaryFrame)frame).getByteArray());
                break;
            }
            case ConnectionClose: {
                this._sendConnectionClose();
                break;
            }
            case Ping: {
                this._sendPing();
                break;
            }
            case Pong: {
                this._sendPong();
                break;
            }
            default: {
                throw new IOException("unable to handle frame type: " + (Object)((Object)frame.getType()));
            }
        }
    }
}

