/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import org.jboss.ejb.ContainerRelectionMBean;
import org.jboss.system.ServiceMBeanSupport;

public class ContainerRelection
extends ServiceMBeanSupport
implements ContainerRelectionMBean {
    public String inspectEJB(String jndiName) {
        MBeanServer server = this.getServer();
        StringBuffer buffer = new StringBuffer();
        try {
            buffer.append("<pre>");
            ObjectName containerName = new ObjectName(":service=Container,jndiName=" + jndiName);
            Class homeClass = (Class)server.invoke(containerName, "getHome", null, null);
            buffer.append("\nHome class = " + homeClass);
            buffer.append("\nClassLoader: " + homeClass.getClassLoader());
            buffer.append("\nCodeSource: " + homeClass.getProtectionDomain().getCodeSource());
            buffer.append("\n- Methods:");
            Method[] homeMethods = homeClass.getMethods();
            for (int m = 0; m < homeMethods.length; ++m) {
                buffer.append("\n--- " + homeMethods[m]);
            }
            Class remoteClass = (Class)server.invoke(containerName, "getRemote", null, null);
            buffer.append("\nRemote class = " + remoteClass);
            buffer.append("\n- Methods:");
            Method[] remoteMethods = remoteClass.getMethods();
            for (int m = 0; m < remoteMethods.length; ++m) {
                buffer.append("\n--- " + remoteMethods[m]);
            }
            buffer.append("\n</pre>\n");
        }
        catch (Throwable e2) {
            RuntimeException e2;
            if (e2 instanceof RuntimeOperationsException) {
                RuntimeOperationsException roe = (RuntimeOperationsException)e2;
                e2 = roe.getTargetException();
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e2.printStackTrace(pw);
            buffer.append(sw.toString());
            buffer.append("\n</pre>\n");
        }
        return buffer.toString();
    }

    public String getName() {
        return "ContainerRelection";
    }
}

