/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.util.Set;
import org.jboss.ejb.Container;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.ejb.plugins.SecurityActions;
import org.jboss.invocation.Invocation;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.AssemblyDescriptorMetaData;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.SecurityIdentityMetaData;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.RunAs;
import org.jboss.security.RunAsIdentity;

public class RunAsSecurityInterceptor
extends AbstractInterceptor {
    protected RunAs runAsIdentity;
    protected AuthenticationManager securityManager;

    public void setContainer(Container container) {
        super.setContainer(container);
        if (container != null) {
            BeanMetaData beanMetaData = container.getBeanMetaData();
            ApplicationMetaData application = beanMetaData.getApplicationMetaData();
            AssemblyDescriptorMetaData assemblyDescriptor = application.getAssemblyDescriptor();
            SecurityIdentityMetaData secMetaData = beanMetaData.getSecurityIdentityMetaData();
            if (secMetaData != null && !secMetaData.getUseCallerIdentity()) {
                String roleName = secMetaData.getRunAsRoleName();
                String principalName = secMetaData.getRunAsPrincipalName();
                if (principalName == null) {
                    principalName = application.getUnauthenticatedPrincipal();
                }
                Set extraRoleNames = assemblyDescriptor.getSecurityRoleNamesByPrincipal(principalName);
                this.runAsIdentity = new RunAsIdentity(roleName, principalName, extraRoleNames);
            }
            this.securityManager = container.getSecurityManager();
        }
    }

    public void start() throws Exception {
        super.start();
    }

    public Object invokeHome(Invocation mi) throws Exception {
        boolean isInvokeMethod = false;
        return this.process(mi, isInvokeMethod);
    }

    public Object invoke(Invocation mi) throws Exception {
        boolean isInvokeMethod = true;
        return this.process(mi, isInvokeMethod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object process(Invocation mi, boolean isInvokeMethod) throws Exception {
        block7: {
            Object object;
            String securityDomain = "other";
            if (this.securityManager != null) {
                securityDomain = this.securityManager.getSecurityDomain();
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Bean:" + this.container.getServiceName() + " securityDomain=" + securityDomain + " isInvokeMethod=" + isInvokeMethod));
            }
            if (SecurityActions.getSecurityContext() == null) {
                SecurityActions.createAndSetSecurityContext(mi.getPrincipal(), mi.getCredential(), securityDomain);
            }
            SecurityActions.pushRunAsIdentity(this.runAsIdentity);
            SecurityActions.pushCallerRunAsIdentity(this.runAsIdentity);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Security Context = " + SecurityActions.trace(SecurityActions.getSecurityContext())));
            }
            try {
                if (!isInvokeMethod) break block7;
                object = this.getNext().invoke(mi);
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                SecurityActions.popRunAsIdentity();
                SecurityActions.popCallerRunAsIdentity();
                throw throwable;
            }
            SecurityActions.popRunAsIdentity();
            SecurityActions.popCallerRunAsIdentity();
            return object;
        }
        Object object = this.getNext().invokeHome(mi);
        Object var6_7 = null;
        SecurityActions.popRunAsIdentity();
        SecurityActions.popCallerRunAsIdentity();
        return object;
    }
}

