/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.RunAs;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.javaee.AbstractEJBAuthorizationHelper;
import org.jboss.security.javaee.EJBAuthenticationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SecurityActions {
    SecurityActions() {
    }

    private static <T> T doPrivilegedIfNeeded(PrivilegedAction<T> action) {
        if (System.getSecurityManager() == null) {
            return action.run();
        }
        return AccessController.doPrivileged(action);
    }

    private static <T> T doPrivilegedIfNeeded(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        if (System.getSecurityManager() == null) {
            try {
                return action.run();
            }
            catch (Exception e) {
                throw new PrivilegedActionException(e);
            }
        }
        return AccessController.doPrivileged(action);
    }

    static ClassLoader getContextClassLoader() {
        return SecurityActions.doPrivilegedIfNeeded(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static void setContextClassLoader(final ClassLoader loader) {
        SecurityActions.doPrivilegedIfNeeded(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Thread.currentThread().setContextClassLoader(loader);
                return null;
            }
        });
    }

    static RunAs peekRunAsIdentity() {
        if (System.getSecurityManager() == null) {
            return RunAsIdentityActions.NON_PRIVILEGED.peek();
        }
        return RunAsIdentityActions.PRIVILEGED.peek();
    }

    static void pushRunAsIdentity(RunAs principal) {
        if (System.getSecurityManager() == null) {
            RunAsIdentityActions.NON_PRIVILEGED.push(principal);
        } else {
            RunAsIdentityActions.PRIVILEGED.push(principal);
        }
    }

    static RunAs popRunAsIdentity() {
        if (System.getSecurityManager() == null) {
            return RunAsIdentityActions.NON_PRIVILEGED.pop();
        }
        return RunAsIdentityActions.PRIVILEGED.pop();
    }

    static Subject getContextSubject() throws PolicyContextException {
        if (System.getSecurityManager() == null) {
            return PolicyContextActions.NON_PRIVILEGED.getContextSubject();
        }
        return PolicyContextActions.PRIVILEGED.getContextSubject();
    }

    static void createAndSetSecurityContext(final Principal p, final Object cred, final String domain) throws PrivilegedActionException {
        SecurityActions.doPrivilegedIfNeeded(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                SecurityContext sc = SecurityContextFactory.createSecurityContext((Principal)p, (Object)cred, null, (String)domain);
                SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
                return null;
            }
        });
    }

    static void createAndSetSecurityContext(final Principal p, final Object cred, final String domain, final Subject subject) throws PrivilegedActionException {
        SecurityActions.doPrivilegedIfNeeded(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                SecurityContext sc = SecurityContextFactory.createSecurityContext((String)domain);
                sc.getUtil().createSubjectInfo(p, cred, subject);
                SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
                return null;
            }
        });
    }

    static void clearSecurityContext() {
        SecurityActions.doPrivilegedIfNeeded(new PrivilegedAction(){

            public Object run() {
                SecurityContextAssociation.setSecurityContext(null);
                return null;
            }
        });
    }

    static RoleGroup getRolesFromSecurityContext(final SecurityContext sc) {
        return SecurityActions.doPrivilegedIfNeeded(new PrivilegedAction<RoleGroup>(){

            @Override
            public RoleGroup run() {
                return sc.getUtil().getRoles();
            }
        });
    }

    static SecurityContext getSecurityContext() {
        return (SecurityContext)SecurityActions.doPrivilegedIfNeeded(new PrivilegedAction(){

            public Object run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        });
    }

    static ISecurityManagement getSecurityManagement(final SecurityContext sc) {
        return SecurityActions.doPrivilegedIfNeeded(new PrivilegedAction<ISecurityManagement>(){

            @Override
            public ISecurityManagement run() {
                return sc.getSecurityManagement();
            }
        });
    }

    static void setSecurityManagement(final SecurityContext sc, final ISecurityManagement sm) {
        SecurityActions.doPrivilegedIfNeeded(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                sc.setSecurityManagement(sm);
                return null;
            }
        });
    }

    static Exception getContextException() {
        return (Exception)SecurityActions.doPrivilegedIfNeeded(new PrivilegedAction(){
            static final String EX_KEY = "org.jboss.security.exception";

            public Object run() {
                SecurityContext sc = SecurityActions.getSecurityContext();
                return sc.getData().get(EX_KEY);
            }
        });
    }

    static void pushSubjectContext(final Principal p, final Object cred, final Subject s) {
        SecurityActions.doPrivilegedIfNeeded(new PrivilegedAction(){

            public Object run() {
                SecurityContext sc = SecurityActions.getSecurityContext();
                if (sc == null) {
                    throw new IllegalStateException("Security Context is null");
                }
                sc.getUtil().createSubjectInfo(p, cred, s);
                return null;
            }
        });
    }

    static void popSubjectContext() {
        SecurityActions.doPrivilegedIfNeeded(new PrivilegedAction(){

            public Object run() {
                SecurityContext sc = SecurityActions.getSecurityContext();
                if (sc == null) {
                    throw new IllegalStateException("Security Context is null");
                }
                Principal p = sc.getUtil().getUserPrincipal();
                Object cred = sc.getUtil().getCredential();
                sc.getUtil().createSubjectInfo(p, cred, null);
                return null;
            }
        });
    }

    static void pushCallerRunAsIdentity(final RunAs ra) {
        SecurityActions.doPrivilegedIfNeeded(new PrivilegedAction(){

            public Object run() {
                SecurityContext sc = SecurityContextAssociation.getSecurityContext();
                if (sc == null) {
                    throw new IllegalStateException("Security Context is null");
                }
                sc.setIncomingRunAs(ra);
                return null;
            }
        });
    }

    static void popCallerRunAsIdentity() {
        SecurityActions.doPrivilegedIfNeeded(new PrivilegedAction(){

            public Object run() {
                SecurityContext sc = SecurityContextAssociation.getSecurityContext();
                if (sc == null) {
                    throw new IllegalStateException("Security Context is null");
                }
                sc.setIncomingRunAs(null);
                return null;
            }
        });
    }

    static boolean isValid(final EJBAuthenticationHelper helper, final Subject subject, final String methodName) {
        return SecurityActions.doPrivilegedIfNeeded(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return helper.isValid(subject, methodName);
            }
        });
    }

    static boolean authorize(final AbstractEJBAuthorizationHelper helper, final String ejbName, final Method ejbMethod, final Principal principal, final String interfaceString, final CodeSource ejbCS, final Subject caller, final RunAs callerRunAsIdentity, final String jaccContextID, final RoleGroup roleGroupOfMethodRoles) {
        return SecurityActions.doPrivilegedIfNeeded(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return helper.authorize(ejbName, ejbMethod, principal, interfaceString, ejbCS, caller, callerRunAsIdentity, jaccContextID, roleGroupOfMethodRoles);
            }
        });
    }

    static String trace(final SecurityContext sc) {
        return SecurityActions.doPrivilegedIfNeeded(new PrivilegedAction<String>(){

            @Override
            public String run() {
                StringBuilder sb = new StringBuilder();
                sb.append(" Principal = " + sc.getUtil().getUserPrincipal());
                sb.append(" Subject:" + sc.getUtil().getSubject());
                sb.append(" Incoming run as:" + sc.getIncomingRunAs());
                sb.append(" Outgoing run as:" + sc.getOutgoingRunAs());
                return sb.toString();
            }
        });
    }

    static interface PolicyContextActions {
        public static final String SUBJECT_CONTEXT_KEY = "javax.security.auth.Subject.container";
        public static final PolicyContextActions PRIVILEGED = new PolicyContextActions(){
            private final PrivilegedExceptionAction exAction = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return (Subject)PolicyContext.getContext((String)PolicyContextActions.SUBJECT_CONTEXT_KEY);
                }
            };

            public Subject getContextSubject() throws PolicyContextException {
                try {
                    return (Subject)AccessController.doPrivileged(this.exAction);
                }
                catch (PrivilegedActionException e) {
                    Exception ex = e.getException();
                    if (ex instanceof PolicyContextException) {
                        throw (PolicyContextException)((Object)ex);
                    }
                    throw new UndeclaredThrowableException(ex);
                }
            }
        };
        public static final PolicyContextActions NON_PRIVILEGED = new PolicyContextActions(){

            public Subject getContextSubject() throws PolicyContextException {
                return (Subject)PolicyContext.getContext((String)PolicyContextActions.SUBJECT_CONTEXT_KEY);
            }
        };

        public Subject getContextSubject() throws PolicyContextException;
    }

    static interface RunAsIdentityActions {
        public static final RunAsIdentityActions PRIVILEGED = new RunAsIdentityActions(){
            private final PrivilegedAction peekAction = new PrivilegedAction(){

                public Object run() {
                    SecurityContext sc = SecurityContextAssociation.getSecurityContext();
                    if (sc != null) {
                        return sc.getOutgoingRunAs();
                    }
                    return null;
                }
            };
            private final PrivilegedAction popAction = new PrivilegedAction(){

                public Object run() {
                    SecurityContext sc = SecurityContextAssociation.getSecurityContext();
                    if (sc == null) {
                        throw new IllegalStateException("Security Context is null");
                    }
                    RunAs ra = sc.getOutgoingRunAs();
                    sc.setOutgoingRunAs(null);
                    return ra;
                }
            };

            public RunAs peek() {
                return (RunAs)AccessController.doPrivileged(this.peekAction);
            }

            public void push(final RunAs id) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        SecurityContext sa = SecurityContextAssociation.getSecurityContext();
                        if (sa == null) {
                            throw new IllegalStateException("Security Context is null to push runas");
                        }
                        sa.setOutgoingRunAs(id);
                        return null;
                    }
                });
            }

            public RunAs pop() {
                return (RunAs)AccessController.doPrivileged(this.popAction);
            }
        };
        public static final RunAsIdentityActions NON_PRIVILEGED = new RunAsIdentityActions(){

            public RunAs peek() {
                SecurityContext sc = SecurityContextAssociation.getSecurityContext();
                if (sc != null) {
                    return sc.getOutgoingRunAs();
                }
                return null;
            }

            public void push(RunAs id) {
                SecurityContext sc = SecurityContextAssociation.getSecurityContext();
                if (sc == null) {
                    throw new IllegalStateException("Security Context is null to push runas");
                }
                sc.setOutgoingRunAs(id);
            }

            public RunAs pop() {
                SecurityContext sc = SecurityContextAssociation.getSecurityContext();
                if (sc == null) {
                    throw new IllegalStateException("Security Context is null");
                }
                RunAs ra = null;
                ra = sc.getOutgoingRunAs();
                sc.setOutgoingRunAs(null);
                return ra;
            }
        };

        public RunAs peek();

        public void push(RunAs var1);

        public RunAs pop();
    }
}

