/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.txtimer;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ejb.EJBException;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.transaction.TransactionManager;
import org.jboss.ejb.Container;
import org.jboss.ejb.ContainerMBean;
import org.jboss.ejb.txtimer.BigIntegerTimerIdGenerator;
import org.jboss.ejb.txtimer.EJBTimerServiceImplMBean;
import org.jboss.ejb.txtimer.NoopPersistencePolicy;
import org.jboss.ejb.txtimer.PersistencePolicy;
import org.jboss.ejb.txtimer.PersistencePolicyExt;
import org.jboss.ejb.txtimer.PersistentIdTimerService;
import org.jboss.ejb.txtimer.RetryPolicy;
import org.jboss.ejb.txtimer.TimedObjectId;
import org.jboss.ejb.txtimer.TimedObjectInvoker;
import org.jboss.ejb.txtimer.TimerHandleImpl;
import org.jboss.ejb.txtimer.TimerIdGenerator;
import org.jboss.ejb.txtimer.TimerImpl;
import org.jboss.ejb.txtimer.TimerRestoringTimerService;
import org.jboss.ejb.txtimer.TimerServiceImpl;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.tm.TransactionManagerFactory;
import org.jboss.tm.TransactionManagerLocator;

public class EJBTimerServiceImpl
extends ServiceMBeanSupport
implements EJBTimerServiceImplMBean {
    private static Logger log = Logger.getLogger(EJBTimerServiceImpl.class);
    public static TimerService FOR_NON_TIMED_OBJECT = new TimerService(){

        public Timer createTimer(long duration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
            throw new IllegalStateException("The object does not implement javax.ejb.TimedObject interface!");
        }

        public Timer createTimer(long initialDuration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
            throw new IllegalStateException("The object does not implement javax.ejb.TimedObject interface!");
        }

        public Timer createTimer(Date expiration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
            throw new IllegalStateException("The object does not implement javax.ejb.TimedObject interface!");
        }

        public Timer createTimer(Date initialExpiration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
            throw new IllegalStateException("The object does not implement javax.ejb.TimedObject interface!");
        }

        public Collection getTimers() throws IllegalStateException, EJBException {
            return Collections.EMPTY_LIST;
        }
    };
    private ObjectName retryPolicyName;
    private ObjectName persistencePolicyName;
    private String timerIdGeneratorClassName;
    private String timedObjectInvokerClassName;
    private TransactionManagerFactory transactionManagerFactory;
    private TransactionManager transactionManager;
    private RetryPolicy retryPolicy;
    private PersistencePolicy persistencePolicy;
    private TimerIdGenerator timerIdGenerator;
    private Map<TimedObjectId, TimerServiceImpl> timerServiceMap = Collections.synchronizedMap(new HashMap());
    private Integer threadPoolSize = new Integer(50);

    public ObjectName getRetryPolicy() {
        return this.retryPolicyName;
    }

    public void setRetryPolicy(ObjectName retryPolicyName) {
        this.retryPolicyName = retryPolicyName;
    }

    public ObjectName getPersistencePolicy() {
        return this.persistencePolicyName;
    }

    public void setPersistencePolicy(ObjectName persistencePolicyName) {
        this.persistencePolicyName = persistencePolicyName;
    }

    public String getTimerIdGeneratorClassName() {
        return this.timerIdGeneratorClassName;
    }

    public void setTimerIdGeneratorClassName(String timerIdGeneratorClassName) {
        this.timerIdGeneratorClassName = timerIdGeneratorClassName;
    }

    public String getTimedObjectInvokerClassName() {
        return this.timedObjectInvokerClassName;
    }

    public void setTimedObjectInvokerClassName(String timedObjectInvokerClassName) {
        this.timedObjectInvokerClassName = timedObjectInvokerClassName;
    }

    public void setTransactionManagerFactory(TransactionManagerFactory factory) {
        this.transactionManagerFactory = factory;
    }

    public Integer getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(Integer threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    protected void startService() throws Exception {
        this.transactionManager = this.transactionManagerFactory != null ? this.transactionManagerFactory.getTransactionManager() : TransactionManagerLocator.getInstance().locate();
        try {
            this.retryPolicy = (RetryPolicy)MBeanProxyExt.create(RetryPolicy.class, (ObjectName)this.getRetryPolicy(), (MBeanServer)this.server);
        }
        catch (Exception e) {
            log.error((Object)"Cannot obtain the implementation of a RetryPolicy", (Throwable)e);
        }
        try {
            this.persistencePolicy = this.isPersistencePolicyExt(this.persistencePolicyName) ? (PersistencePolicy)MBeanProxyExt.create(PersistencePolicyExt.class, (ObjectName)this.persistencePolicyName, (MBeanServer)this.server) : (PersistencePolicy)MBeanProxyExt.create(PersistencePolicy.class, (ObjectName)this.persistencePolicyName, (MBeanServer)this.server);
        }
        catch (Exception e) {
            log.warn((Object)("Cannot obtain the implementation of a PersistencePolicy, using NoopPersistencePolicy: " + e.toString()));
            this.persistencePolicy = new NoopPersistencePolicy();
        }
        try {
            Class<?> timerIdGeneratorClass = this.getClass().getClassLoader().loadClass(this.timerIdGeneratorClassName);
            this.timerIdGenerator = (TimerIdGenerator)timerIdGeneratorClass.newInstance();
        }
        catch (Exception e) {
            log.warn((Object)("Cannot obtain the implementation of a TimerIdGenerator, using BigIntegerTimerIdGenerator: " + e.toString()));
            this.timerIdGenerator = new BigIntegerTimerIdGenerator();
        }
    }

    protected void stopService() {
        this.transactionManager = null;
        this.retryPolicy = null;
        this.persistencePolicy = null;
        this.timerIdGenerator = null;
    }

    public TimerService createTimerService(ObjectName containerId, Object instancePk, Container container) {
        TimedObjectInvoker invoker = null;
        try {
            TimedObjectId timedObjectId = new TimedObjectId(containerId, instancePk);
            Class<?> invokerClass = this.getClass().getClassLoader().loadClass(this.timedObjectInvokerClassName);
            Constructor<?> constr = invokerClass.getConstructor(TimedObjectId.class, Container.class);
            invoker = (TimedObjectInvoker)constr.newInstance(timedObjectId, container);
        }
        catch (Exception e) {
            log.error((Object)("Cannot create TimedObjectInvoker: " + this.timedObjectInvokerClassName), (Throwable)e);
            return null;
        }
        return this.createTimerService(containerId, instancePk, invoker);
    }

    public TimerService createTimerService(ObjectName containerId, Object instancePk, TimedObjectInvoker invoker) {
        TimedObjectId timedObjectId = new TimedObjectId(containerId, instancePk);
        TimerServiceImpl timerService = this.timerServiceMap.get(timedObjectId);
        if (timerService == null) {
            timerService = new TimerServiceImpl(timedObjectId, invoker, this.transactionManager, this.persistencePolicy, this.retryPolicy, this.timerIdGenerator, this.getThreadPoolSize());
            log.debug((Object)("createTimerService: " + timerService));
            this.timerServiceMap.put(timedObjectId, timerService);
        }
        return timerService;
    }

    public TimerService getTimerService(ObjectName containerId, Object instancePk) {
        TimedObjectId timedObjectId = new TimedObjectId(containerId, instancePk);
        return this.timerServiceMap.get(timedObjectId);
    }

    public void removeTimerService(ObjectName containerId, Object instancePk) {
        TimedObjectId timedObjectId = new TimedObjectId(containerId, instancePk);
        if (timedObjectId.getInstancePk() != null) {
            TimerServiceImpl timerService = (TimerServiceImpl)this.getTimerService(containerId, instancePk);
            if (timerService != null) {
                log.debug((Object)("removeTimerService: " + timerService));
                timerService.shutdown(false);
                this.timerServiceMap.remove(timedObjectId);
            }
        } else {
            this.removeTimerService(containerId, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTimerService(ObjectName containerId, boolean keepState) throws IllegalStateException {
        Map<TimedObjectId, TimerServiceImpl> map = this.timerServiceMap;
        synchronized (map) {
            Iterator<Map.Entry<TimedObjectId, TimerServiceImpl>> it = this.timerServiceMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<TimedObjectId, TimerServiceImpl> entry = it.next();
                TimedObjectId key = entry.getKey();
                TimerServiceImpl timerService = entry.getValue();
                if (!containerId.equals(key.getContainerId())) continue;
                log.debug((Object)("removeTimerService: " + timerService));
                timerService.shutdown(keepState);
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTimerService(ObjectName containerId, Object instancePk, boolean keepState) throws IllegalStateException {
        TimedObjectId timedObjectId = new TimedObjectId(containerId, instancePk);
        if (timedObjectId.getInstancePk() != null) {
            TimerServiceImpl timerService = (TimerServiceImpl)this.getTimerService(containerId, instancePk);
            if (timerService != null) {
                log.debug((Object)("removeTimerService: " + timerService));
                timerService.shutdown(false);
                this.timerServiceMap.remove(timedObjectId);
            }
        } else {
            Map<TimedObjectId, TimerServiceImpl> map = this.timerServiceMap;
            synchronized (map) {
                Iterator<Map.Entry<TimedObjectId, TimerServiceImpl>> it = this.timerServiceMap.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<TimedObjectId, TimerServiceImpl> entry = it.next();
                    TimedObjectId key = entry.getKey();
                    TimerServiceImpl timerService = entry.getValue();
                    if (!containerId.equals(key.getContainerId())) continue;
                    log.debug((Object)("removeTimerService: " + timerService));
                    timerService.shutdown(keepState);
                    it.remove();
                }
            }
        }
    }

    public void restoreTimers(ObjectName containerId, ClassLoader loader) throws IllegalStateException {
        assert (this.persistencePolicy != null) : "persistencePolicy is not set";
        List handles = this.persistencePolicy.listTimerHandles(containerId, loader);
        if (!handles.isEmpty()) {
            for (TimerHandleImpl handle : handles) {
                this.persistencePolicy.deleteTimer(handle.getTimerId(), handle.getTimedObjectId());
            }
            for (TimerHandleImpl handle : handles) {
                try {
                    TimedObjectId targetId = handle.getTimedObjectId();
                    ContainerMBean container = (ContainerMBean)MBeanProxyExt.create(ContainerMBean.class, (ObjectName)containerId, (MBeanServer)this.server);
                    TimerService timerService = container.getTimerService(targetId.getInstancePk());
                    if (timerService instanceof TimerRestoringTimerService) {
                        TimerRestoringTimerService timerRestoringTimerService = (TimerRestoringTimerService)timerService;
                        timerRestoringTimerService.restoreTimer(handle.getFirstTime(), handle.getPeriode(), handle.getNextTimeout(), handle.getInfo(), handle.getTimerId());
                        continue;
                    }
                    if (timerService instanceof PersistentIdTimerService) {
                        PersistentIdTimerService persistentIdTimerService = (PersistentIdTimerService)timerService;
                        persistentIdTimerService.createTimer(handle.getFirstTime(), handle.getPeriode(), handle.getInfo(), handle.getTimerId());
                        continue;
                    }
                    log.warn((Object)("Unable to preserve timerId. Will generate new timerId: " + handle));
                    timerService.createTimer(handle.getFirstTime(), handle.getPeriode(), handle.getInfo());
                }
                catch (Exception e) {
                    log.warn((Object)("Unable to restore timer record: " + handle), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listTimers() {
        StringBuffer retBuffer = new StringBuffer();
        Map<TimedObjectId, TimerServiceImpl> map = this.timerServiceMap;
        synchronized (map) {
            for (Map.Entry<TimedObjectId, TimerServiceImpl> entry : this.timerServiceMap.entrySet()) {
                TimedObjectId timedObjectId = entry.getKey();
                retBuffer.append(timedObjectId + "\n");
                TimerServiceImpl timerService = entry.getValue();
                Collection col = timerService.getAllTimers();
                for (TimerImpl timer : col) {
                    TimerHandleImpl handle = new TimerHandleImpl(timer);
                    retBuffer.append("   handle: " + handle + "\n");
                    retBuffer.append("      " + timer + "\n");
                }
            }
        }
        return retBuffer.toString();
    }

    private boolean isPersistencePolicyExt(ObjectName persistencePolicyObjectName) {
        if (persistencePolicyObjectName == null) {
            return false;
        }
        try {
            ObjectInstance persistencePolicyMBeanInstance = this.server.getObjectInstance(persistencePolicyObjectName);
            String persistencePolicyInstanceClassName = persistencePolicyMBeanInstance.getClassName();
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            Class<?> persistencePolicyClass = tccl.loadClass(persistencePolicyInstanceClassName);
            if (PersistencePolicyExt.class.isAssignableFrom(persistencePolicyClass)) {
                return true;
            }
        }
        catch (Exception e) {
            log.debug((Object)("Could not determine whether: " + persistencePolicyObjectName + " implements " + PersistencePolicyExt.class + " - will assume that it doesn't"));
            return false;
        }
        return false;
    }
}

