/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.txtimer;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;
import javax.management.ObjectName;
import org.jboss.ejb.txtimer.EJBTimerService;
import org.jboss.ejb.txtimer.EJBTimerServiceLocator;
import org.jboss.ejb.txtimer.TimedObjectId;
import org.jboss.ejb.txtimer.TimerImpl;
import org.jboss.ejb.txtimer.TimerServiceImpl;

public class TimerHandleImpl
implements TimerHandle {
    public static final String DATE_PATTERN = "dd-MMM-yyyy HH:mm:ss.SSS";
    private String timerId;
    private TimedObjectId timedObjectId;
    private Date firstTime;
    private Date nextTimeout;
    private long periode;
    private Serializable info;
    private int hashCode;

    TimerHandleImpl(TimerImpl timer) {
        this.timerId = timer.getTimerId();
        this.timedObjectId = timer.getTimedObjectId();
        this.firstTime = timer.getFirstTime();
        this.nextTimeout = new Date(timer.getNextExpire());
        this.periode = timer.getPeriode();
        this.info = timer.getInfoInternal();
    }

    @Deprecated
    TimerHandleImpl(String timerId, TimedObjectId timedObjectId, Date firstTime, long periode, Serializable info) {
        this.timerId = timerId;
        this.timedObjectId = timedObjectId;
        this.firstTime = firstTime;
        this.periode = periode;
        this.info = info;
    }

    TimerHandleImpl(String timerId, TimedObjectId timedObjectId, Date firstTime, Date nextTimeout, long periode, Serializable info) {
        this.timerId = timerId;
        this.timedObjectId = timedObjectId;
        this.firstTime = firstTime;
        this.nextTimeout = nextTimeout;
        this.periode = periode;
        this.info = info;
    }

    private TimerHandleImpl(String externalForm) {
        if (!externalForm.startsWith("[") || !externalForm.endsWith("]")) {
            throw new IllegalArgumentException("Square brackets expected arround: " + externalForm);
        }
        try {
            String inStr = externalForm.substring(1, externalForm.length() - 1);
            if (!inStr.startsWith("id=")) {
                throw new IllegalArgumentException("Cannot parse: " + externalForm);
            }
            int targetIndex = inStr.indexOf(",target=");
            int firstIndex = inStr.indexOf(",first=");
            String idStr = inStr.substring(3, targetIndex);
            String targetStr = inStr.substring(targetIndex + 8, firstIndex);
            String restStr = inStr.substring(firstIndex + 1);
            this.timerId = idStr;
            this.timedObjectId = TimedObjectId.parse(targetStr);
            StringTokenizer st = new StringTokenizer(restStr, ",=");
            if (st.countTokens() % 2 != 0) {
                throw new IllegalArgumentException("Cannot parse: " + externalForm);
            }
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
            this.periode = -1L;
            while (st.hasMoreTokens()) {
                String key = st.nextToken();
                String value = st.nextToken();
                if (key.equals("first")) {
                    this.firstTime = sdf.parse(value);
                }
                if (!key.equals("periode")) continue;
                this.periode = new Long(value);
            }
            if (this.firstTime == null || this.periode < 0L) {
                throw new IllegalArgumentException("Cannot parse: " + externalForm);
            }
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Cannot parse date/time in: " + externalForm);
        }
    }

    public static TimerHandleImpl parse(String externalForm) {
        return new TimerHandleImpl(externalForm);
    }

    public String toExternalForm() {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
        String firstEvent = sdf.format(this.firstTime);
        return "[id=" + this.timerId + ",target=" + this.timedObjectId + ",first=" + firstEvent + ",periode=" + this.periode + "]";
    }

    public String getTimerId() {
        return this.timerId;
    }

    public TimedObjectId getTimedObjectId() {
        return this.timedObjectId;
    }

    public Date getFirstTime() {
        return this.firstTime;
    }

    public long getPeriode() {
        return this.periode;
    }

    public Serializable getInfo() {
        return this.info;
    }

    public Date getNextTimeout() {
        return this.nextTimeout;
    }

    public Timer getTimer() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        Object instancePk;
        ObjectName containerId;
        EJBTimerService ejbTimerService = EJBTimerServiceLocator.getEjbTimerService();
        TimerServiceImpl timerService = (TimerServiceImpl)ejbTimerService.getTimerService(containerId = this.timedObjectId.getContainerId(), instancePk = this.timedObjectId.getInstancePk());
        if (timerService == null) {
            throw new NoSuchObjectLocalException("TimerService not available: " + this.timedObjectId);
        }
        TimerImpl timer = (TimerImpl)timerService.getTimer(this);
        if (timer == null || !timer.isActive()) {
            throw new NoSuchObjectLocalException("Timer not available: " + this.timedObjectId);
        }
        return timer;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TimerHandleImpl) {
            TimerHandleImpl other = (TimerHandleImpl)obj;
            return this.hashCode() == other.hashCode();
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.toExternalForm().hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        return this.toExternalForm();
    }
}

