/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming;

import java.beans.PropertyEditor;
import org.jboss.common.beans.property.BeanUtils;
import org.jboss.common.beans.property.finder.PropertyEditorFinder;

public class JNDIBinding {
    private String name;
    private String text;
    private String type;
    private String editor;
    private Object value;
    private boolean trim;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        if (this.trim) {
            text = text.trim();
        }
        this.text = text;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getEditor() {
        return this.editor;
    }

    public void setEditor(String editor) {
        this.editor = editor;
    }

    public Object getValue() throws Exception {
        if (this.value == null && this.text != null) {
            if (this.editor != null) {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> editorClass = loader.loadClass(this.editor);
                PropertyEditor pe = (PropertyEditor)editorClass.newInstance();
                pe.setAsText(this.text);
                this.value = pe.getValue();
            } else if (this.type != null) {
                PropertyEditor pe = PropertyEditorFinder.getInstance().find(BeanUtils.findClass((String)this.type));
                pe.setAsText(this.text);
                this.value = pe.getValue();
            } else {
                this.value = this.text;
            }
        }
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean isTrim() {
        return this.trim;
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
    }
}

