/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.proxy.ejb;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.security.RunAs;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SecurityActions {
    SecurityActions() {
    }

    private static <T> T doPrivilegedIfNeeded(PrivilegedAction<T> action) {
        if (System.getSecurityManager() == null) {
            return action.run();
        }
        return AccessController.doPrivileged(action);
    }

    private static <T> T doPrivilegedIfNeeded(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        if (System.getSecurityManager() == null) {
            try {
                return action.run();
            }
            catch (Exception e) {
                throw new PrivilegedActionException(e);
            }
        }
        return AccessController.doPrivileged(action);
    }

    static SecurityContext getSecurityContext() {
        return SecurityActions.doPrivilegedIfNeeded(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        });
    }

    static RunAs getCallerRunAsIdentity() {
        return SecurityActions.doPrivilegedIfNeeded(new PrivilegedAction<RunAs>(){

            @Override
            public RunAs run() {
                RunAs rai = null;
                SecurityContext existingSC = SecurityActions.getSecurityContext();
                if (existingSC != null) {
                    rai = existingSC.getOutgoingRunAs();
                }
                return rai;
            }
        });
    }

    static void setSecurityContext(final SecurityContext sc) {
        SecurityActions.doPrivilegedIfNeeded(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
                return null;
            }
        });
    }

    static SecurityContext createSecurityContext(final Principal p, final Object cred, final String sdomain) throws Exception {
        return SecurityActions.doPrivilegedIfNeeded(new PrivilegedExceptionAction<SecurityContext>(){

            @Override
            public SecurityContext run() throws Exception {
                return SecurityContextFactory.createSecurityContext((Principal)p, (Object)cred, null, (String)sdomain);
            }
        });
    }

    static void setIncomingRunAs(final SecurityContext sc, final RunAs incomingRunAs) {
        SecurityActions.doPrivilegedIfNeeded(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                sc.setOutgoingRunAs(incomingRunAs);
                return null;
            }
        });
    }

    static void setOutgoingRunAs(final SecurityContext sc, final RunAs outgoingRunAs) {
        SecurityActions.doPrivilegedIfNeeded(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                sc.setOutgoingRunAs(outgoingRunAs);
                return null;
            }
        });
    }
}

