/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.stream;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.stream.StreamCallPayload;

public class StreamHandler
extends InputStream {
    private InvokerLocator streamServerLocator = null;
    private Client streamClient = null;
    private static final Logger log = Logger.getLogger(StreamHandler.class);
    public static final String READ = "read()";
    public static final String AVAILABLE = "available()";
    public static final String CLOSE = "close()";
    public static final String RESET = "reset()";
    public static final String MARKSUPPORTED = "markSupported()";
    public static final String MARKREADLIMIT = "mark(int readlimit)";
    public static final String SKIP = "skip(long n)";
    public static final String READBYTEARRAY = "read(byte b[])";
    public static final String READOFFSET = "read(byte b[], int off, int len)";

    public StreamHandler(String locatorURL) throws Exception {
        this.streamServerLocator = new InvokerLocator(locatorURL);
        this.streamClient = new Client(this.streamServerLocator);
        this.streamClient.connect();
    }

    @Override
    public int available() throws IOException {
        int readInt = 0;
        try {
            Integer retInt = (Integer)this.streamClient.invoke(new StreamCallPayload(AVAILABLE));
            if (retInt != null) {
                readInt = retInt;
            }
        }
        catch (Throwable throwable) {
            log.debug((Object)"Error getting available from client stream.", throwable);
            throw new IOException(throwable.getMessage());
        }
        return readInt;
    }

    @Override
    public void close() throws IOException {
        try {
            this.streamClient.invokeOneway(new StreamCallPayload(CLOSE));
        }
        catch (Throwable throwable) {
            log.debug((Object)"Error closing client stream.", throwable);
            throw new IOException(throwable.getMessage());
        }
        finally {
            this.streamClient.disconnect();
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        try {
            this.streamClient.invoke(new StreamCallPayload(RESET));
        }
        catch (Throwable throwable) {
            log.debug((Object)"Error reseting client stream.", throwable);
            throw new IOException(throwable.getMessage());
        }
    }

    @Override
    public boolean markSupported() {
        boolean supported = false;
        try {
            Boolean bSupported = (Boolean)this.streamClient.invoke(new StreamCallPayload(MARKSUPPORTED));
            if (bSupported != null) {
                supported = bSupported;
            }
        }
        catch (Throwable throwable) {
            log.debug((Object)"Error getting markSupported from client stream.", throwable);
            throw new RuntimeException(throwable.getMessage(), throwable);
        }
        return supported;
    }

    @Override
    public synchronized void mark(int readlimit) {
        try {
            StreamCallPayload payload = new StreamCallPayload(MARKREADLIMIT);
            payload.setParams(new Object[]{new Integer(readlimit)});
            this.streamClient.invoke(payload);
        }
        catch (Throwable throwable) {
            log.debug((Object)"Error marking with read limit on client stream.", throwable);
            throw new RuntimeException(throwable.getMessage(), throwable);
        }
    }

    @Override
    public long skip(long n) throws IOException {
        long numSkipped = -1L;
        try {
            StreamCallPayload payload = new StreamCallPayload(SKIP);
            payload.setParams(new Object[]{new Long(n)});
            Long ret = (Long)this.streamClient.invoke(payload);
            if (ret != null) {
                numSkipped = ret;
            }
        }
        catch (Throwable throwable) {
            log.debug((Object)"Error skipping on client stream.", throwable);
            throw new IOException(throwable.getMessage());
        }
        return numSkipped;
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (b == null) {
            throw new NullPointerException("can not read for a null byte array.");
        }
        if (b.length == 0) {
            return 0;
        }
        int retByte = -1;
        try {
            StreamCallPayload payload = new StreamCallPayload(READBYTEARRAY);
            payload.setParams(new Object[]{b});
            StreamCallPayload ret = (StreamCallPayload)this.streamClient.invoke(payload);
            if (ret != null) {
                Object[] retVals = ret.getParams();
                byte[] retBytes = (byte[])retVals[0];
                Integer retInt = (Integer)retVals[1];
                retByte = retInt;
                if (retByte != -1) {
                    System.arraycopy(retBytes, 0, b, 0, retByte);
                }
            }
        }
        catch (Throwable throwable) {
            log.debug((Object)"Error reading from client stream.", throwable);
            throw new IOException(throwable.getMessage());
        }
        return retByte;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException("can not read for a null byte array.");
        }
        if (b.length == 0) {
            return 0;
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException("Either off or len is negative or off+len is greater than length of b.");
        }
        if (len == 0) {
            return 0;
        }
        int retByte = -1;
        try {
            byte[] payloadArray = new byte[len];
            StreamCallPayload payload = new StreamCallPayload(READBYTEARRAY);
            payload.setParams(new Object[]{payloadArray});
            StreamCallPayload ret = (StreamCallPayload)this.streamClient.invoke(payload);
            if (ret != null) {
                Object[] retVals = ret.getParams();
                byte[] retBytes = (byte[])retVals[0];
                Integer retInt = (Integer)retVals[1];
                retByte = retInt;
                if (retByte != -1) {
                    System.arraycopy(retBytes, 0, b, off, retByte);
                }
            }
        }
        catch (Throwable throwable) {
            log.debug((Object)"Error reading with offset from client stream.", throwable);
            throw new IOException(throwable.getMessage());
        }
        return retByte;
    }

    @Override
    public int read() throws IOException {
        int readInt = -1;
        try {
            Integer retInt = (Integer)this.streamClient.invoke(new StreamCallPayload(READ));
            if (retInt != null) {
                readInt = retInt;
            }
        }
        catch (Throwable throwable) {
            log.debug((Object)"Error reading from client stream.", throwable);
            throw new IOException(throwable.getMessage());
        }
        return readInt;
    }
}

