/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.logging.Logger;
import org.jboss.remoting.transport.PortUtil;
import org.jboss.remoting.util.SecurityUtility;

public class AddressUtil {
    private static Logger log = Logger.getLogger(AddressUtil.class);

    public static boolean checkAddress(String host) throws Exception {
        return AddressUtil.checkAddress(host, 5000);
    }

    public static boolean checkAddress(String host, int timeout) throws Exception {
        try {
            log.trace((Object)("checking host: " + host));
            int port = PortUtil.findFreePort(host);
            InetAddress addr = AddressUtil.getAddressByName(host);
            ServerTestThread t1 = new ServerTestThread(addr, port);
            t1.setDaemon(true);
            t1.start();
            ClientTestThread t2 = new ClientTestThread(addr, port);
            t2.setDaemon(true);
            t2.start();
            t2.join(timeout);
            return t2.ok;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static InetAddress getAddressByName(final String host) throws UnknownHostException {
        if (SecurityUtility.skipAccessControl()) {
            return InetAddress.getByName(host);
        }
        try {
            return (InetAddress)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return InetAddress.getByName(host);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (UnknownHostException)e.getCause();
        }
    }

    static class ClientTestThread
    extends Thread {
        public boolean ok;
        InetAddress addr;
        int port;

        ClientTestThread(InetAddress addr, int port) {
            this.addr = addr;
            this.port = port;
        }

        @Override
        public void run() {
            try {
                Socket s = new Socket(this.addr, this.port);
                s.close();
                this.ok = true;
                log.trace((Object)("ClientTestThread ok: " + this.addr + ":" + this.port));
            }
            catch (Exception e) {
                log.trace((Object)"error in ClientTestThread", (Throwable)e);
            }
        }
    }

    static class ServerTestThread
    extends Thread {
        InetAddress addr;
        int port;

        ServerTestThread(InetAddress addr, int port) {
            this.addr = addr;
            this.port = port;
        }

        @Override
        public void run() {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        ServerSocket ss = new ServerSocket(ServerTestThread.this.port, 0, ServerTestThread.this.addr);
                        Socket s = ss.accept();
                        s.close();
                        ss.close();
                        log.trace((Object)("ServerTestThread ok: " + ServerTestThread.this.addr + ":" + ServerTestThread.this.port));
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                log.trace((Object)"error in ServerTestThread", (Throwable)e);
            }
        }
    }
}

