/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import org.jboss.logging.Logger;
import org.jboss.remoting.ConnectionListener;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.ServerConfiguration;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvocationHandlerWrapper;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.marshal.MarshalFactory;
import org.jboss.remoting.marshal.MarshallLoaderFactory;
import org.jboss.remoting.serialization.ClassLoaderUtility;
import org.jboss.remoting.transport.ConnectorMBean;
import org.jboss.remoting.transport.PortUtil;
import org.jboss.remoting.util.SecurityUtility;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Connector
implements MBeanRegistration,
ConnectorMBean {
    protected ServerInvoker invoker;
    private String locatorURI;
    private Element xml;
    private ServerConfiguration serverConfiguration;
    private Map configuration = new HashMap();
    private MBeanServer server;
    private ServerSocketFactory svrSocketFactory;
    private SocketFactory socketFactory;
    private Connector marshallerLoaderConnector = null;
    private boolean isMarshallerLoader = false;
    private List remoteClassLoaders;
    private boolean isStarted = false;
    private boolean isCreated = false;
    protected static final Logger log = Logger.getLogger(Connector.class);
    private static final InetAddress LOCAL_HOST;

    public Connector() {
    }

    public Connector(String locatorURI) {
        this.locatorURI = locatorURI;
    }

    public Connector(InvokerLocator locator) {
        if (locator != null) {
            this.locatorURI = locator.getLocatorURI();
        }
    }

    public Connector(Map configuration) {
        this.configuration.putAll(configuration);
    }

    public Connector(String locatorURI, Map configuration) {
        this.locatorURI = locatorURI;
        this.configuration.putAll(configuration);
    }

    public Connector(InvokerLocator locator, Map configuration) {
        if (locator != null) {
            this.locatorURI = locator.getLocatorURI();
        }
        if (configuration != null) {
            this.configuration.putAll(configuration);
        }
    }

    protected Connector(boolean isMarshallerConnector) {
        this();
        this.isMarshallerLoader = isMarshallerConnector;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public void start() throws Exception {
        if (!this.isStarted) {
            if (!this.isCreated) {
                this.create();
            }
            if (this.serverConfiguration != null) {
                this.configureHandlersFromServerConfiguration();
            } else if (this.xml != null) {
                this.configureHandlersFromXML();
            }
            if (!this.isMarshallerLoader && this.marshallerLoaderConnector != null && !this.marshallerLoaderConnector.isStarted()) {
                this.marshallerLoaderConnector.start();
            }
            if (!this.invoker.isStarted()) {
                try {
                    this.invoker.start();
                }
                catch (Exception e) {
                    if (this.marshallerLoaderConnector != null) {
                        this.marshallerLoaderConnector.stop();
                    }
                    log.debug((Object)"Error starting connector.", (Throwable)e);
                    throw e;
                }
            }
            this.isStarted = true;
            log.debug((Object)(this + " started"));
        }
    }

    @Override
    public void start(boolean runAsNewThread) throws Exception {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    Connector.this.start();
                }
                catch (Exception e) {
                    log.error((Object)"Error starting Connector.", (Throwable)e);
                }
            }
        };
        Thread t = new Thread(r);
        t.setDaemon(false);
        t.start();
    }

    private void init() throws Exception {
        HashMap invokerConfig = new HashMap();
        if (this.locatorURI == null) {
            if (this.serverConfiguration != null) {
                this.getInvokerConfigFromServerConfiguration(invokerConfig);
            } else if (this.xml != null) {
                this.getInvokerConfigFromXML(invokerConfig);
            }
            this.configuration.putAll(invokerConfig);
        }
        if (this.locatorURI == null) {
            throw new IllegalStateException("Connector not configured with LocatorURI.");
        }
        final InvokerLocator locator = new InvokerLocator(this.locatorURI);
        if (this.invoker == null) {
            try {
                this.invoker = (ServerInvoker)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return InvokerRegistry.createServerInvoker(locator, Connector.this.configuration);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
            this.invoker.setMBeanServer(this.server);
            this.invoker.setServerSocketFactory(this.svrSocketFactory);
            this.svrSocketFactory = null;
            this.invoker.setSocketFactory(this.socketFactory);
            this.socketFactory = null;
            this.invoker.create();
            if (this.server != null) {
                try {
                    final ObjectName objName = new ObjectName(this.invoker.getMBeanObjectName());
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                if (!Connector.this.server.isRegistered(objName)) {
                                    Connector.this.server.registerMBean(Connector.this.invoker, objName);
                                } else {
                                    log.warn((Object)(objName + " is already registered with MBeanServer"));
                                }
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        throw (Exception)e.getCause();
                    }
                }
                catch (Throwable e) {
                    log.warn((Object)("Error registering invoker " + this.invoker + " with MBeanServer."), e);
                }
            }
        }
        this.locatorURI = this.invoker.getLocator().getLocatorURI();
        if (this.remoteClassLoaders == null) {
            Object o = this.configuration.get("remoteClassLoaders");
            if (o instanceof List) {
                this.setRemoteClassLoaders((List)o);
            } else if (o != null) {
                log.warn((Object)"value of remoteClassLoaders must be a List");
            }
        }
        if (!this.isMarshallerLoader && this.marshallerLoaderConnector == null) {
            this.marshallerLoaderConnector = this.createMarshallerLoader(this.invoker.getLocator());
        }
    }

    private Connector createMarshallerLoader(InvokerLocator locator) {
        ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Connector.class.getClassLoader();
            }
        });
        MarshalFactory.getMarshaller(locator, classLoader, this.configuration);
        Connector marshallerLoader = null;
        InvokerLocator loaderLocator = MarshallLoaderFactory.convertLocator(locator);
        if (loaderLocator != null) {
            marshallerLoader = MarshallLoaderFactory.createMarshallLoader(loaderLocator, this.remoteClassLoaders, this.server);
        }
        return marshallerLoader;
    }

    private void getInvokerConfigFromXML(Map invokerConfig) {
        try {
            NodeList invokerNodes = this.xml.getElementsByTagName("invoker");
            if (invokerNodes != null && invokerNodes.getLength() >= 1) {
                Node invokerNode = invokerNodes.item(0);
                NamedNodeMap attributes = invokerNode.getAttributes();
                Node transportNode = attributes.getNamedItem("transport");
                if (transportNode != null) {
                    String transport = transportNode.getNodeValue();
                    if (invokerNodes.getLength() > 1) {
                        log.warn((Object)("Found more than one invokers defined in configuration.  Will only be using the first one - " + transport));
                    }
                    HashMap<String, String> paramConfig = new HashMap<String, String>();
                    ArrayList homes = new ArrayList();
                    ArrayList connectHomes = new ArrayList();
                    NodeList invokerAttributes = invokerNode.getChildNodes();
                    int len = invokerAttributes.getLength();
                    for (int x = 0; x < len; ++x) {
                        Node attr = invokerAttributes.item(x);
                        if (!"attribute".equals(attr.getNodeName())) continue;
                        String name = attr.getAttributes().getNamedItem("name").getNodeValue();
                        String value = attr.getFirstChild().getNodeValue();
                        if ("homes".equals(name)) {
                            this.processHomes(attr, "home", homes);
                        } else if ("connecthomes".equals(name)) {
                            this.processHomes(attr, "connecthome", connectHomes);
                        } else {
                            invokerConfig.put(name, value);
                        }
                        Node isParamAttribute = attr.getAttributes().getNamedItem("isParam");
                        if (isParamAttribute == null || !Boolean.valueOf(isParamAttribute.getNodeValue()).booleanValue()) continue;
                        paramConfig.put(name, value);
                    }
                    if (homes.isEmpty() && !connectHomes.isEmpty()) {
                        throw new Exception("Configuration has a connecthomes without a homes");
                    }
                    String clientConnectAddress = (String)invokerConfig.get("clientConnectAddress");
                    String clientConnectPort = (String)invokerConfig.get("clientConnectPort");
                    String serverBindAddress = (String)invokerConfig.get("serverBindAddress");
                    String serverBindPort = (String)invokerConfig.get("serverBindPort");
                    String localHostAddress = Connector.getLocalHost().getHostAddress();
                    String tempURI = null;
                    String path = (String)invokerConfig.get("path");
                    PortUtil.updateRange(invokerConfig);
                    if (homes.isEmpty() && connectHomes.isEmpty()) {
                        int port;
                        int n = clientConnectPort != null ? Integer.parseInt(clientConnectPort) : (serverBindPort != null ? Integer.parseInt(serverBindPort) : (port = PortUtil.findFreePort(serverBindAddress != null ? serverBindAddress : localHostAddress)));
                        String host = clientConnectAddress != null ? clientConnectAddress : (serverBindAddress != null ? serverBindAddress : localHostAddress);
                        tempURI = transport + "://" + this.fixHostnameForURL(host) + ":" + port;
                        if (path != null) {
                            tempURI = tempURI + "/" + path;
                        }
                    } else {
                        String port = clientConnectPort != null ? ":" + clientConnectPort : (serverBindPort != null ? ":" + serverBindPort : "");
                        tempURI = transport + "://multihome" + port;
                        if (path != null) {
                            tempURI = tempURI + "/" + path;
                        }
                        tempURI = tempURI + "/?";
                        Iterator it = homes.iterator();
                        tempURI = tempURI + "homes=" + it.next();
                        while (it.hasNext()) {
                            tempURI = tempURI + "!" + it.next();
                        }
                        if (!connectHomes.isEmpty()) {
                            tempURI = tempURI + "&connecthomes=";
                            it = connectHomes.iterator();
                            tempURI = tempURI + it.next();
                            while (it.hasNext()) {
                                tempURI = tempURI + "!" + it.next();
                            }
                        }
                    }
                    if (paramConfig.size() > 0) {
                        Object value;
                        Object name;
                        tempURI = tempURI.indexOf("/?") < 0 ? tempURI + "/?" : tempURI + "&";
                        Iterator keyItr = paramConfig.keySet().iterator();
                        if (keyItr.hasNext()) {
                            name = keyItr.next();
                            value = paramConfig.get(name);
                            tempURI = tempURI + name + "=" + value;
                        }
                        while (keyItr.hasNext()) {
                            tempURI = tempURI + "&";
                            name = keyItr.next();
                            value = paramConfig.get(name);
                            tempURI = tempURI + name + "=" + value;
                        }
                    }
                    this.locatorURI = tempURI;
                } else {
                    log.error((Object)"Invoker element within Configuration attribute does not contain a transport attribute.");
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Error configuring invoker for connector: " + e.getMessage()));
            log.debug((Object)"Error configuring invoker for connector.", (Throwable)e);
            throw new IllegalStateException("Error configuring invoker for connector.  Can not continue without invoker.");
        }
    }

    private void processHomes(Node node, String homeType, List homes) {
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node child = nodes.item(i);
            if (1 != child.getNodeType() || !homeType.equals(child.getNodeName())) continue;
            NodeList children = child.getChildNodes();
            for (int k = 0; k < children.getLength(); ++k) {
                Node grandchild = children.item(k);
                if (3 != grandchild.getNodeType()) continue;
                homes.add(grandchild.getNodeValue());
            }
        }
    }

    private void getInvokerConfigFromServerConfiguration(Map invokerConfig) throws Exception {
        try {
            String transport = this.serverConfiguration.getTransport();
            if (transport == null) {
                log.error((Object)"ServerConfiguration must contain a non-null transport attribute.");
                return;
            }
            HashMap<String, String> locatorParameters = this.serverConfiguration.getInvokerLocatorParameters();
            HashMap serverParameters = this.serverConfiguration.getServerParameters();
            String temp = (String)serverParameters.remove("clientConnectAddress");
            if (temp != null) {
                log.warn((Object)"clientConnectAddress in server parameters will be ignored");
            }
            if ((temp = (String)serverParameters.remove("clientConnectPort")) != null) {
                log.warn((Object)"clientConnectPort in server parameters will be ignored");
            }
            if ((temp = (String)serverParameters.get("serverBindAddress")) != null) {
                locatorParameters.remove("serverBindAddress");
                log.warn((Object)"serverBindAddress in locator parameters will be ignored");
            }
            if ((temp = (String)serverParameters.get("serverBindPort")) != null) {
                locatorParameters.remove("serverBindPort");
                log.warn((Object)"serverBindPort in locator parameters will be ignored");
            }
            if ((temp = (String)serverParameters.remove("connecthomes")) != null) {
                log.warn((Object)"connecthomes in server parameters will be ignored");
            }
            if ((temp = (String)serverParameters.remove("homes")) != null) {
                if (locatorParameters.get("homes") == null) {
                    locatorParameters.put("homes", temp);
                } else {
                    log.warn((Object)"homes in server parameters will be ignored");
                }
            }
            if (locatorParameters.get("connecthomes") != null && locatorParameters.get("homes") == null) {
                throw new Exception("Configuration has a connecthomes without a homes");
            }
            String connectHomes = (String)locatorParameters.remove("connecthomes");
            String homes = (String)serverParameters.remove("homes");
            temp = (String)locatorParameters.remove("homes");
            if (homes == null) {
                homes = temp;
            }
            locatorParameters = new HashMap<String, String>(this.serverConfiguration.getInvokerLocatorParameters());
            serverParameters = new HashMap(this.serverConfiguration.getServerParameters());
            String clientConnectAddress = (String)locatorParameters.remove("clientConnectAddress");
            String clientConnectPort = (String)locatorParameters.remove("clientConnectPort");
            String serverBindAddress = (String)serverParameters.get("serverBindAddress");
            String defaultPortString = (String)serverParameters.get("serverBindPort");
            temp = (String)locatorParameters.remove("serverBindAddress");
            if (serverBindAddress == null) {
                serverBindAddress = temp;
            }
            temp = (String)locatorParameters.remove("serverBindPort");
            if (defaultPortString == null) {
                defaultPortString = temp;
            }
            String path = (String)locatorParameters.remove("path");
            PortUtil.updateRange(invokerConfig);
            String tempURI = null;
            boolean parametersStarted = false;
            if (connectHomes == null && homes == null) {
                String host;
                String localHostAddress = Connector.getLocalHost().getHostAddress();
                String string = clientConnectAddress != null ? clientConnectAddress : (host = serverBindAddress != null ? serverBindAddress : localHostAddress);
                int port = clientConnectPort != null ? Integer.parseInt(clientConnectPort) : (defaultPortString != null ? Integer.parseInt(defaultPortString) : PortUtil.findFreePort(serverBindAddress != null ? serverBindAddress : localHostAddress));
                tempURI = transport + "://" + this.fixHostnameForURL(host) + ":" + port + (path != null ? "/" + path : "");
            } else {
                tempURI = transport + "://multihome" + (path != null ? "/" + path : "");
                parametersStarted = true;
                tempURI = tempURI + "/?";
                if (connectHomes != null) {
                    tempURI = tempURI + "connecthomes=" + connectHomes;
                    if (homes != null) {
                        tempURI = tempURI + "&homes=" + homes;
                    }
                } else if (homes != null) {
                    tempURI = tempURI + "homes=" + homes;
                }
            }
            if (locatorParameters.size() > 0) {
                Object name;
                tempURI = !parametersStarted ? tempURI + "/?" : tempURI + "&";
                Iterator keyItr = locatorParameters.keySet().iterator();
                if (keyItr.hasNext()) {
                    name = keyItr.next();
                    Object value = locatorParameters.get(name);
                    tempURI = tempURI + name + "=" + value;
                }
                while (keyItr.hasNext()) {
                    tempURI = tempURI + "&";
                    name = keyItr.next();
                    Object value = locatorParameters.get(name);
                    tempURI = tempURI + name + "=" + value;
                }
            }
            this.locatorURI = tempURI;
            invokerConfig.putAll(this.serverConfiguration.getServerParameters());
            invokerConfig.putAll(this.serverConfiguration.getInvokerLocatorParameters());
        }
        catch (Exception e) {
            log.error((Object)("Error configuring invoker for connector: " + e.getMessage()));
            log.debug((Object)"Error configuring invoker for connector.", (Throwable)e);
            throw new IllegalStateException("Error configuring invoker from configuration POJO.  Can not continue without invoker.");
        }
    }

    private String fixHostnameForURL(String address) {
        if (address == null) {
            return address;
        }
        if (address.indexOf(58) != -1 && address.indexOf("[") == -1) {
            return "[" + address + "]";
        }
        return address;
    }

    private void configureHandlersFromServerConfiguration() throws Exception {
        Map handlerMap = this.serverConfiguration.getInvocationHandlers();
        if (handlerMap.size() == 0 && (this.getInvocationHandlers() == null || this.getInvocationHandlers().length == 0)) {
            throw new IllegalArgumentException("invocationHandlers list empty and are no registered handlers found.");
        }
        for (String subsystems : handlerMap.keySet()) {
            Object value = handlerMap.get(subsystems);
            ServerInvocationHandler handler = null;
            if (value instanceof ServerInvocationHandler) {
                handler = (ServerInvocationHandler)value;
            } else if (value instanceof String) {
                String valueString = (String)value;
                boolean isObjName = false;
                try {
                    ObjectName objName = new ObjectName(valueString);
                    handler = this.createHandlerProxy(objName);
                    isObjName = true;
                }
                catch (MalformedObjectNameException e) {
                    log.debug((Object)"Handler supplied is not an object name.");
                }
                if (!isObjName) {
                    Class serverInvocationHandlerClass = ClassLoaderUtility.loadClass(valueString, Connector.class);
                    handler = (ServerInvocationHandler)serverInvocationHandlerClass.newInstance();
                }
            } else {
                throw new IllegalArgumentException("handler has invalid type: " + value);
            }
            StringTokenizer tok = new StringTokenizer(subsystems, ",");
            while (tok.hasMoreTokens()) {
                String subsystem = tok.nextToken();
                this.addInvocationHandler(subsystem, handler);
            }
        }
    }

    private void configureHandlersFromXML() throws Exception {
        NodeList handlersNodes = this.xml.getElementsByTagName("handler");
        if (!(handlersNodes != null && handlersNodes.getLength() > 0 || this.getInvocationHandlers() != null && this.getInvocationHandlers().length != 0)) {
            throw new IllegalArgumentException("required 'handler' element not found and are no registered handlers found.");
        }
        int len = handlersNodes.getLength();
        for (int c = 0; c < len; ++c) {
            Node node = handlersNodes.item(c);
            Node subNode = node.getAttributes().getNamedItem("subsystem");
            if (subNode == null) {
                throw new IllegalArgumentException("Required 'subsystem' attribute on 'handler' element");
            }
            String handlerClass = node.getFirstChild().getNodeValue();
            boolean isObjName = false;
            ServerInvocationHandler handler = null;
            try {
                ObjectName objName = new ObjectName(handlerClass);
                handler = this.createHandlerProxy(objName);
                isObjName = true;
            }
            catch (MalformedObjectNameException e) {
                log.debug((Object)"Handler supplied is not an object name.");
            }
            if (!isObjName) {
                Class serverInvocationHandlerClass = ClassLoaderUtility.loadClass(handlerClass, Connector.class);
                handler = (ServerInvocationHandler)serverInvocationHandlerClass.newInstance();
            }
            StringTokenizer tok = new StringTokenizer(subNode.getNodeValue(), ",");
            while (tok.hasMoreTokens()) {
                String subsystem = tok.nextToken();
                this.addInvocationHandler(subsystem, handler);
            }
        }
    }

    private ServerInvocationHandler createHandlerProxy(ObjectName objName) {
        if (this.server == null) {
            throw new RuntimeException("Can not register MBean invocation handler as the Connector has not been registered with a MBeanServer.");
        }
        ServerInvocationHandler handler = MBeanServerInvocationHandler.newProxyInstance(this.server, objName, ServerInvocationHandler.class, false);
        handler = new ServerInvocationHandlerWrapper(handler);
        return handler;
    }

    @Override
    public void addConnectionListener(ConnectionListener listener) {
        if (this.invoker != null) {
            this.invoker.addConnectionListener(listener);
        }
    }

    @Override
    public void removeConnectionListener(ConnectionListener listener) {
        if (this.invoker != null) {
            this.invoker.removeConnectionListener(listener);
        }
    }

    @Override
    public void setLeasePeriod(long leasePeriodValue) {
        if (this.invoker != null) {
            this.invoker.setLeasePeriod(leasePeriodValue);
        }
    }

    @Override
    public long getLeasePeriod() {
        if (this.invoker != null) {
            return this.invoker.getLeasePeriod();
        }
        return -1L;
    }

    @Override
    public void stop() {
        if (this.isStarted) {
            if (this.invoker != null) {
                if (this.server != null) {
                    try {
                        ObjectName objName = new ObjectName(this.invoker.getMBeanObjectName());
                        Connector.unregisterMBean(this.server, objName);
                    }
                    catch (Exception e) {
                        log.error((Object)"invalid Object Name", (Throwable)e);
                    }
                }
                log.trace((Object)(this + " shutting down server invoker"));
                this.invoker.stop();
                this.invoker.destroy();
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        InvokerRegistry.destroyServerInvoker(Connector.this.invoker);
                        return null;
                    }
                });
                this.invoker = null;
            }
            if (this.marshallerLoaderConnector != null && this.marshallerLoaderConnector.isStarted) {
                this.marshallerLoaderConnector.stop();
                this.marshallerLoaderConnector = null;
            }
            this.isStarted = false;
        }
        log.trace((Object)(this + " is stopped"));
    }

    @Override
    public void create() throws Exception {
        if (!this.isCreated) {
            try {
                this.init();
                this.isCreated = true;
            }
            catch (Exception e) {
                if (this.invoker != null) {
                    this.invoker.stop();
                    this.invoker.destroy();
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            InvokerRegistry.destroyServerInvoker(Connector.this.invoker);
                            return null;
                        }
                    });
                    this.invoker = null;
                }
                this.isCreated = false;
                throw e;
            }
        }
    }

    @Override
    public void destroy() {
        if (this.isStarted) {
            this.stop();
        }
        if (this.invoker != null) {
            this.invoker.stop();
            this.invoker.destroy();
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    InvokerRegistry.destroyServerInvoker(Connector.this.invoker);
                    return null;
                }
            });
            this.invoker = null;
        }
        this.isCreated = false;
    }

    public ServerInvoker getServerInvoker() {
        return this.invoker;
    }

    public ServerInvocationHandler[] getInvocationHandlers() {
        ServerInvocationHandler[] handlers = null;
        if (this.invoker != null) {
            handlers = this.invoker.getInvocationHandlers();
        }
        return handlers;
    }

    @Override
    public InvokerLocator getLocator() {
        return this.invoker.getLocator();
    }

    @Override
    public void setInvokerLocator(String locator) throws Exception {
        if (this.isCreated) {
            throw new RuntimeException("Can not set the invoker locator on this Connector as has already been created with a different locator.");
        }
        this.locatorURI = locator;
    }

    @Override
    public String getInvokerLocator() throws Exception {
        return this.locatorURI;
    }

    @Override
    public void setConfiguration(Element xml) throws Exception {
        this.xml = xml;
    }

    @Override
    public Element getConfiguration() {
        return this.xml;
    }

    @Override
    public ServerInvocationHandler addInvocationHandler(String subsystem, ObjectName handlerObjectName) throws Exception {
        ServerInvocationHandler invocationHandler = this.createHandlerProxy(handlerObjectName);
        return this.addInvocationHandler(subsystem, invocationHandler);
    }

    @Override
    public ServerInvocationHandler addInvocationHandler(String subsystem, final ServerInvocationHandler handler) throws Exception {
        if (this.invoker == null) {
            throw new IllegalStateException("You may only add handlers once the Connector is created (via create() method).");
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                handler.setMBeanServer(Connector.this.server);
                return null;
            }
        });
        return this.invoker.addInvocationHandler(subsystem, handler);
    }

    @Override
    public void removeInvocationHandler(String subsystem) throws Exception {
        ServerInvocationHandler handler = this.invoker.removeInvocationHandler(subsystem);
        if (handler != null) {
            handler.setMBeanServer(null);
        }
    }

    public void setServerSocketFactory(ServerSocketFactory serverSocketFactory) {
        if (this.isCreated) {
            throw new RuntimeException("Can not set server socket factory on Connector after the create() method has been called.");
        }
        if (this.invoker != null) {
            this.invoker.setServerSocketFactory(serverSocketFactory);
        } else {
            this.svrSocketFactory = serverSocketFactory;
        }
    }

    public ServerSocketFactory getServerSocketFactory() {
        if (this.invoker != null) {
            return this.invoker.getServerSocketFactory();
        }
        return this.svrSocketFactory;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        if (this.isCreated) {
            throw new RuntimeException("Can not set socket factory on Connector after the create() method has been called.");
        }
        if (this.invoker != null) {
            this.invoker.setSocketFactory(socketFactory);
        } else {
            this.socketFactory = socketFactory;
        }
    }

    public SocketFactory getSocketFactory() {
        if (this.invoker != null) {
            return this.invoker.getSocketFactory();
        }
        return this.socketFactory;
    }

    public ServerConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    public void setServerConfiguration(ServerConfiguration serverConfig) {
        this.serverConfiguration = serverConfig;
    }

    public void setRemoteClassLoaders(List classLoaders) {
        if (classLoaders == null) {
            return;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("setContextClassLoader"));
        }
        this.remoteClassLoaders = classLoaders;
    }

    private static void unregisterMBean(final MBeanServer server, final ObjectName name) throws Exception {
        if (SecurityUtility.skipAccessControl()) {
            server.unregisterMBean(name);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    server.unregisterMBean(name);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (Exception)e.getCause();
        }
    }

    private static InetAddress getLocalHost() throws UnknownHostException {
        if (SecurityUtility.skipAccessControl()) {
            return Connector.doGetLocalHost();
        }
        try {
            return (InetAddress)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws UnknownHostException {
                    return Connector.doGetLocalHost();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (UnknownHostException)e.getCause();
        }
    }

    private static InetAddress doGetLocalHost() throws UnknownHostException {
        if (LOCAL_HOST != null) {
            return LOCAL_HOST;
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            return InetAddress.getByName("127.0.0.1");
        }
    }

    static {
        try {
            LOCAL_HOST = (InetAddress)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws UnknownHostException {
                    try {
                        return InetAddress.getLocalHost();
                    }
                    catch (UnknownHostException e) {
                        return InetAddress.getByName("127.0.0.1");
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            log.debug((Object)(Connector.class.getName() + " unable to get local host address"), e.getCause());
            throw new ExceptionInInitializerError(e.getCause());
        }
        catch (SecurityException e) {
            log.debug((Object)(Connector.class.getName() + " unable to get local host address"), (Throwable)e);
            throw e;
        }
    }
}

