/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.legacy.jnp.factory;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Hashtable;
import java.util.Set;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.jboss.legacy.jnp.factory.SecurityActions;
import org.jboss.legacy.jnp.factory.WatchfulClassLoader;
import org.jboss.legacy.jnp.security.CredentialIdentityProxy;
import org.jboss.legacy.jnp.security.JBossSecurityContextProxy;
import org.jboss.legacy.jnp.security.SecurityUtil;
import org.jboss.legacy.jnp.security.SubjectInfoProxy;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;
import org.jboss.security.plugins.JBossSecurityContext;

public class WatchfulContext
implements Context {
    private final Context wrappedContext;
    private final ClassLoader moduleClassLoader;

    public WatchfulContext(Context wrappedContext) throws NamingException {
        this.wrappedContext = wrappedContext;
        this.moduleClassLoader = this.getClass().getClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object lookup(Name name) throws NamingException {
        ClassLoader classLoader = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(this.getWatchfulClassLoader());
            Object o = this.wrappedContext.lookup(name);
            if (o instanceof Proxy) {
                o = this.decorate(o, classLoader);
            }
            Object object = o;
            return object;
        }
        finally {
            SecurityActions.setContextClassLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object lookup(String name) throws NamingException {
        ClassLoader classLoader = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(this.getWatchfulClassLoader());
            Object o = this.wrappedContext.lookup(name);
            if (o instanceof Proxy) {
                o = this.decorate(o, classLoader);
            }
            Object object = o;
            return object;
        }
        finally {
            SecurityActions.setContextClassLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(Name name, Object obj) throws NamingException {
        ClassLoader classLoader = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(this.getWatchfulClassLoader());
            this.wrappedContext.bind(name, obj);
        }
        finally {
            SecurityActions.setContextClassLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(String name, Object obj) throws NamingException {
        ClassLoader classLoader = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(this.getWatchfulClassLoader());
            this.wrappedContext.bind(name, obj);
        }
        finally {
            SecurityActions.setContextClassLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        ClassLoader classLoader = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(this.getWatchfulClassLoader());
            this.wrappedContext.rebind(name, obj);
        }
        finally {
            SecurityActions.setContextClassLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebind(String name, Object obj) throws NamingException {
        ClassLoader classLoader = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(this.getWatchfulClassLoader());
            this.wrappedContext.rebind(name, obj);
        }
        finally {
            SecurityActions.setContextClassLoader(classLoader);
        }
    }

    @Override
    public void unbind(Name name) throws NamingException {
        ClassLoader classLoader = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(this.getWatchfulClassLoader());
            this.wrappedContext.unbind(name);
        }
        finally {
            SecurityActions.setContextClassLoader(classLoader);
        }
    }

    @Override
    public void unbind(String name) throws NamingException {
        ClassLoader classLoader = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(this.getWatchfulClassLoader());
            this.wrappedContext.unbind(name);
        }
        finally {
            SecurityActions.setContextClassLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        ClassLoader classLoader = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(this.getWatchfulClassLoader());
            this.wrappedContext.rename(oldName, newName);
        }
        finally {
            SecurityActions.setContextClassLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(String oldName, String newName) throws NamingException {
        ClassLoader classLoader = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(this.getWatchfulClassLoader());
            this.wrappedContext.rename(oldName, newName);
        }
        finally {
            SecurityActions.setContextClassLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        ClassLoader classLoader = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(this.getWatchfulClassLoader());
            NamingEnumeration<NameClassPair> namingEnumeration = this.wrappedContext.list(name);
            return namingEnumeration;
        }
        finally {
            SecurityActions.setContextClassLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        ClassLoader classLoader = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(this.getWatchfulClassLoader());
            NamingEnumeration<NameClassPair> namingEnumeration = this.wrappedContext.list(name);
            return namingEnumeration;
        }
        finally {
            SecurityActions.setContextClassLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        ClassLoader classLoader = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(this.getWatchfulClassLoader());
            NamingEnumeration<Binding> namingEnumeration = this.wrappedContext.listBindings(name);
            return namingEnumeration;
        }
        finally {
            SecurityActions.setContextClassLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        ClassLoader classLoader = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(this.getWatchfulClassLoader());
            NamingEnumeration<Binding> namingEnumeration = this.wrappedContext.listBindings(name);
            return namingEnumeration;
        }
        finally {
            SecurityActions.setContextClassLoader(classLoader);
        }
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        ClassLoader classLoader = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(this.getWatchfulClassLoader());
            this.wrappedContext.destroySubcontext(name);
        }
        finally {
            SecurityActions.setContextClassLoader(classLoader);
        }
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        ClassLoader classLoader = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(this.getWatchfulClassLoader());
            this.wrappedContext.destroySubcontext(name);
        }
        finally {
            SecurityActions.setContextClassLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Context createSubcontext(Name name) throws NamingException {
        ClassLoader classLoader = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(this.getWatchfulClassLoader());
            Context context = this.wrappedContext.createSubcontext(name);
            return context;
        }
        finally {
            SecurityActions.setContextClassLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Context createSubcontext(String name) throws NamingException {
        ClassLoader classLoader = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(this.getWatchfulClassLoader());
            Context context = this.wrappedContext.createSubcontext(name);
            return context;
        }
        finally {
            SecurityActions.setContextClassLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object lookupLink(Name name) throws NamingException {
        ClassLoader classLoader = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(this.getWatchfulClassLoader());
            Object object = this.wrappedContext.lookupLink(name);
            return object;
        }
        finally {
            SecurityActions.setContextClassLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object lookupLink(String name) throws NamingException {
        ClassLoader classLoader = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(this.getWatchfulClassLoader());
            Object object = this.wrappedContext.lookupLink(name);
            return object;
        }
        finally {
            SecurityActions.setContextClassLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        ClassLoader classLoader = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(this.getWatchfulClassLoader());
            NameParser nameParser = this.wrappedContext.getNameParser(name);
            return nameParser;
        }
        finally {
            SecurityActions.setContextClassLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NameParser getNameParser(String name) throws NamingException {
        ClassLoader classLoader = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(this.getWatchfulClassLoader());
            NameParser nameParser = this.wrappedContext.getNameParser(name);
            return nameParser;
        }
        finally {
            SecurityActions.setContextClassLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        ClassLoader classLoader = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(this.getWatchfulClassLoader());
            Name name2 = this.wrappedContext.composeName(name, prefix);
            return name2;
        }
        finally {
            SecurityActions.setContextClassLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String composeName(String name, String prefix) throws NamingException {
        ClassLoader classLoader = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(this.getWatchfulClassLoader());
            String string = this.wrappedContext.composeName(name, prefix);
            return string;
        }
        finally {
            SecurityActions.setContextClassLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        ClassLoader classLoader = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(this.getWatchfulClassLoader());
            Object object = this.wrappedContext.addToEnvironment(propName, propVal);
            return object;
        }
        finally {
            SecurityActions.setContextClassLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        ClassLoader classLoader = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(this.getWatchfulClassLoader());
            Object object = this.wrappedContext.removeFromEnvironment(propName);
            return object;
        }
        finally {
            SecurityActions.setContextClassLoader(classLoader);
        }
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        ClassLoader classLoader = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(this.getWatchfulClassLoader());
            Hashtable<?, ?> hashtable = this.wrappedContext.getEnvironment();
            return hashtable;
        }
        finally {
            SecurityActions.setContextClassLoader(classLoader);
        }
    }

    @Override
    public void close() throws NamingException {
        ClassLoader classLoader = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(this.getWatchfulClassLoader());
            this.wrappedContext.close();
        }
        finally {
            SecurityActions.setContextClassLoader(classLoader);
        }
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        ClassLoader classLoader = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(this.getWatchfulClassLoader());
            String string = this.wrappedContext.getNameInNamespace();
            return string;
        }
        finally {
            SecurityActions.setContextClassLoader(classLoader);
        }
    }

    protected ClassLoader getWatchfulClassLoader() {
        ClassLoader invocationClassLoader = SecurityActions.getContextClassLoader();
        return new WatchfulClassLoader(this.moduleClassLoader, invocationClassLoader);
    }

    protected Object decorate(Object o, ClassLoader classLoader) {
        Proxy toWrap = (Proxy)o;
        Class<?>[] interfaces = toWrap.getClass().getInterfaces();
        return Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)new ClassLoaderSwitchInvocationHandler(this.getWatchfulClassLoader(), o));
    }

    private class ClassLoaderSwitchInvocationHandler
    implements InvocationHandler {
        private final ClassLoader vengance;
        private final Object originalTarget;

        public ClassLoaderSwitchInvocationHandler(ClassLoader vengance, Object o) {
            this.vengance = vengance;
            this.originalTarget = o;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            ClassLoader oldClassLoader = SecurityActions.getContextClassLoader();
            SecurityContext oldContext = SecurityContextAssociation.getSecurityContext();
            try {
                SecurityActions.setContextClassLoader(this.vengance);
                JBossSecurityContext contextHack = this.createLocalContext();
                SecurityContextAssociation.setSecurityContext((SecurityContext)contextHack);
                Object object = method.invoke(this.originalTarget, args);
                return object;
            }
            finally {
                try {
                    SecurityActions.setContextClassLoader(oldClassLoader);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (oldContext != null) {
                    try {
                        SecurityContextAssociation.setSecurityContext((SecurityContext)oldContext);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        private JBossSecurityContext createLocalContext() throws Exception {
            JBossSecurityContextProxy contextProxy = SecurityUtil.wrapCurrentContext();
            if (contextProxy == null || contextProxy.getSubjectInfo().getAuthenticatedSubject() == null) {
                return null;
            }
            JBossSecurityContext newContext = (JBossSecurityContext)SecurityContextFactory.createSecurityContext((String)contextProxy.getSecurityDomain());
            SubjectInfoProxy subjectInfoProxy = contextProxy.getSubjectInfo();
            Set identities = subjectInfoProxy.getIdentities();
            CredentialIdentityProxy identityProxy = (CredentialIdentityProxy)identities.iterator().next();
            newContext.getUtil().createSubjectInfo(identityProxy.asPrincipal(), identityProxy.getCredential(), subjectInfoProxy.getAuthenticatedSubject());
            return newContext;
        }
    }
}

