/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.legacy.jnp.infinispan;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.legacy.jnp.infinispan.ClusterNodeProxy;

public class LegacyClusterNodeAdapter
implements ClusterNode {
    private ClusterNodeProxy node;

    public LegacyClusterNodeAdapter(ClusterNodeProxy node) {
        this.node = node;
    }

    public String getName() {
        return this.node.getName();
    }

    public InetAddress getIpAddress() {
        return this.node.getIpAddress();
    }

    public int getPort() {
        return this.node.getPort();
    }

    private String getId(ClusterNode node) {
        return this.getIpAddress().getHostAddress() + ":" + this.getPort();
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof ClusterNode)) {
            throw new ClassCastException("ClusterNode.compareTo(): comparison between different classes");
        }
        return this.getId(this).compareTo(this.getId((ClusterNode)o));
    }

    public static Vector convertToVector(List<ClusterNodeProxy> nodes) {
        Vector<LegacyClusterNodeAdapter> result = new Vector<LegacyClusterNodeAdapter>(nodes.size());
        for (ClusterNodeProxy node : nodes) {
            result.add(new LegacyClusterNodeAdapter(node));
        }
        return result;
    }

    public static ClusterNode[] convertToArray(List<ClusterNodeProxy> nodes) {
        ArrayList<LegacyClusterNodeAdapter> result = new ArrayList<LegacyClusterNodeAdapter>(nodes.size());
        for (ClusterNodeProxy node : nodes) {
            result.add(new LegacyClusterNodeAdapter(node));
        }
        return result.toArray(new ClusterNode[nodes.size()]);
    }
}

