/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.legacy.jnp.server;

import java.rmi.RemoteException;
import java.util.Collection;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import org.jboss.legacy.jnp.server.NamingStore;
import org.jnp.interfaces.Naming;
import org.jnp.interfaces.NamingContext;
import org.jnp.interfaces.NamingParser;
import org.jnp.server.SingletonNamingServer;

public class NamingStoreWrapper
implements Naming {
    private static final NamingParser parser = new NamingParser();
    private final Naming singletonNamingServer;
    private final NamingStore namingStore;

    public NamingStoreWrapper(NamingStore namingStore) throws NamingException {
        this(namingStore, (Naming)new SingletonNamingServer());
    }

    protected NamingStoreWrapper(NamingStore namingStore, Naming singletonNamingServer) throws NamingException {
        this.namingStore = namingStore;
        this.singletonNamingServer = singletonNamingServer;
        NamingContext.setLocal((Naming)this);
    }

    public void bind(Name name, Object obj, String className) throws NamingException, RemoteException {
        this.singletonNamingServer.bind(name, obj, className);
    }

    public void rebind(Name name, Object obj, String className) throws NamingException, RemoteException {
        this.singletonNamingServer.rebind(name, obj, className);
    }

    public void unbind(Name name) throws NamingException, RemoteException {
        this.singletonNamingServer.unbind(name);
    }

    public Object lookup(Name name) throws NamingException, RemoteException {
        try {
            return this.lookupInternal(name);
        }
        catch (Exception t) {
            if (this.hasExportedPrefix(name)) {
                return this.lookupInternal(this.stripJBossExportedContext(name));
            }
            try {
                return this.lookupInternal(parser.parse("jboss/exported/" + name.toString()));
            }
            catch (Exception e) {
                return this.lookupInternal(parser.parse("java:jboss/exported/" + name.toString()));
            }
        }
    }

    private Object lookupInternal(Name name) throws NamingException, RemoteException {
        try {
            return this.singletonNamingServer.lookup(name);
        }
        catch (Exception t) {
            return this.namingStore.lookup(name);
        }
    }

    public Collection<NameClassPair> list(Name name) throws NamingException, RemoteException {
        try {
            return this.singletonNamingServer.list(name);
        }
        catch (Exception t) {
            return this.namingStore.list(name);
        }
    }

    public Collection<Binding> listBindings(Name name) throws NamingException, RemoteException {
        try {
            return this.singletonNamingServer.listBindings(name);
        }
        catch (Exception t) {
            return this.namingStore.listBindings(name);
        }
    }

    public Context createSubcontext(Name name) throws NamingException, RemoteException {
        NamingStoreWrapper namingStoreWrapper = this;
        synchronized (namingStoreWrapper) {
            try {
                return this.singletonNamingServer.createSubcontext(name);
            }
            catch (NamingException e) {
                Object value = this.singletonNamingServer.lookup(name);
                if (value instanceof Context) {
                    return (Context)value;
                }
                throw e;
            }
        }
    }

    private boolean hasExportedPrefix(Name name) {
        return this.getJBossExportedIndex(name) >= 0;
    }

    protected Name stripJBossExportedContext(Name name) {
        int index = this.getJBossExportedIndex(name);
        if (index > 0) {
            return name.getSuffix(index);
        }
        return name;
    }

    private int getJBossExportedIndex(Name name) {
        boolean hasJboss = false;
        for (int i = 0; i < name.size(); ++i) {
            String component = name.get(i);
            if (hasJboss) {
                if ("exported".equals(component)) {
                    return i + 1;
                }
                return -1;
            }
            hasJboss = "jboss".equals(component) || "java:jboss".equals(component);
        }
        return -1;
    }
}

