/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.microcontainer;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.dependency.plugins.AbstractControllerContext;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContextActions;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.dependency.spi.dispatch.LifecycleDispatchContext;
import org.jboss.system.Service;
import org.jboss.system.ServiceContext;
import org.jboss.system.ServiceController;
import org.jboss.system.metadata.ServiceMetaData;
import org.jboss.system.metadata.ServiceMetaDataVisitor;
import org.jboss.system.metadata.ServiceMetaDataVisitorNode;
import org.jboss.system.microcontainer.LifecycleInfo;
import org.jboss.system.microcontainer.ServiceControllerContextActions;
import org.jboss.system.microcontainer.ServiceProxy;

public class ServiceControllerContext
extends AbstractControllerContext
implements LifecycleDispatchContext {
    private ObjectName objectName;
    private ServiceController serviceController;
    private ServiceMetaData serviceMetaData;
    private ServiceContext serviceContext = new ServiceContext();
    private boolean includeLifecycle = true;
    private volatile LifecycleInfo lifecycleInfo;

    public ServiceControllerContext(ServiceController serviceController, ObjectName name) {
        this(serviceController, name, true);
    }

    public ServiceControllerContext(ServiceController serviceController, ObjectName name, boolean includeLifecycle) {
        this(serviceController, name, includeLifecycle, null);
    }

    public ServiceControllerContext(ServiceController serviceController, ObjectName name, boolean includeLifecycle, Object target) {
        super((Object)name.getCanonicalName(), (ControllerContextActions)ServiceControllerContextActions.getLifecycleOnly());
        this.serviceContext.objectName = this.objectName = name;
        this.serviceController = serviceController;
        this.setMode(ControllerMode.MANUAL);
        this.includeLifecycle = includeLifecycle;
        if (target != null) {
            this.setTarget(target);
        }
    }

    public ServiceControllerContext(ServiceController serviceController, ServiceMetaData metaData) {
        super((Object)metaData.getObjectName().getCanonicalName(), (ControllerContextActions)ServiceControllerContextActions.getInstance());
        this.serviceContext.objectName = this.objectName = metaData.getObjectName();
        this.serviceController = serviceController;
        ControllerMode mode = metaData.getMode();
        this.serviceMetaData = metaData;
        if (mode == null) {
            this.setMode(ControllerMode.MANUAL);
        } else {
            this.setMode(mode);
        }
    }

    public ServiceControllerContext(ServiceController serviceController, ObjectName name, Object target) {
        super((Object)name.getCanonicalName(), (ControllerContextActions)ServiceControllerContextActions.getInstance());
        this.serviceContext.objectName = this.objectName = name;
        this.serviceController = serviceController;
        this.setTarget(target);
        this.setMode(ControllerMode.MANUAL);
    }

    private MBeanServer getMBeanServer() {
        MBeanServer server = this.serviceController.getMBeanServer();
        if (server == null) {
            throw new IllegalStateException("MBeanServer not available.");
        }
        return server;
    }

    protected static String getAttributeName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Illegal name: " + name);
        }
        char firstCharacter = name.charAt(0);
        if (Character.isLowerCase(firstCharacter)) {
            String attributeName = String.valueOf(Character.toUpperCase(firstCharacter));
            if (name.length() > 1) {
                attributeName = attributeName + name.substring(1);
            }
            return attributeName;
        }
        return name;
    }

    public Object get(String name) throws Throwable {
        return this.getMBeanServer().getAttribute(this.objectName, ServiceControllerContext.getAttributeName(name));
    }

    public void set(String name, Object value) throws Throwable {
        Attribute attribute = new Attribute(ServiceControllerContext.getAttributeName(name), value);
        this.getMBeanServer().setAttribute(this.objectName, attribute);
    }

    public Object invoke(String name, Object[] parameters, String[] signature) throws Throwable {
        return this.getMBeanServer().invoke(this.objectName, name, parameters, signature);
    }

    public ClassLoader getClassLoader() throws Throwable {
        if (this.serviceMetaData != null) {
            return this.getMBeanServer().getClassLoader(this.serviceMetaData.getClassLoaderName());
        }
        return this.getMBeanServer().getClassLoaderFor(this.objectName);
    }

    public ControllerState lifecycleInvocation(String name, Object[] parameters, String[] signature) throws Throwable {
        if (this.lifecycleInfo == null) {
            this.lifecycleInfo = new LifecycleInfo(this);
        }
        return this.lifecycleInfo.lifecycleInvocation(name, signature);
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public ServiceMetaData getServiceMetaData() {
        return this.serviceMetaData;
    }

    public void setServiceMetaData(ServiceMetaData serviceMetaData) {
        this.serviceMetaData = serviceMetaData;
    }

    public ServiceController getServiceController() {
        return this.serviceController;
    }

    public Service getServiceProxy() throws Exception {
        if (this.serviceContext.proxy != null) {
            return this.serviceContext.proxy;
        }
        MBeanServer server = this.serviceController.getMBeanServer();
        if (server != null) {
            this.serviceContext.proxy = ServiceProxy.getServiceProxy(this.objectName, server, this.includeLifecycle);
        }
        return this.serviceContext.proxy;
    }

    public ServiceContext getServiceContext() {
        try {
            this.serviceContext.proxy = this.getServiceProxy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.getError() != null) {
            this.serviceContext.setProblem(this.getError());
        }
        if (this.getState() == ControllerState.ERROR) {
            this.serviceContext.state = 4;
        }
        return this.serviceContext;
    }

    public void install(ControllerState fromState, ControllerState toState) throws Throwable {
        try {
            super.install(fromState, toState);
        }
        catch (Throwable t) {
            this.serviceContext.setProblem(t);
            this.serviceContext.state = 4;
            throw t;
        }
    }

    public void setController(Controller controller) {
        super.setController(controller);
        if (controller != null) {
            this.preprocessMetaData();
            this.serviceContext.state = 0;
        } else {
            this.serviceContext.state = 7;
        }
    }

    protected void preprocessMetaData() {
        if (this.serviceMetaData == null) {
            return;
        }
        PreprocessMetaDataVisitor visitor = new PreprocessMetaDataVisitor();
        AccessController.doPrivileged(visitor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PreprocessMetaDataVisitor
    implements ServiceMetaDataVisitor,
    PrivilegedAction<Object> {
        private ControllerState contextState = ControllerState.INSTANTIATED;

        protected PreprocessMetaDataVisitor() {
        }

        @Override
        public Object run() {
            ServiceControllerContext.this.serviceMetaData.visit(this);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visit(ServiceMetaDataVisitorNode node) {
            Iterator<? extends ServiceMetaDataVisitorNode> children;
            boolean trace = ServiceControllerContext.this.log.isTraceEnabled();
            if (trace) {
                ServiceControllerContext.this.log.trace((Object)("Visit node " + node));
            }
            if ((children = node.getChildren()) != null) {
                ControllerState restoreState = this.contextState;
                while (children.hasNext()) {
                    Object var7_6;
                    ServiceMetaDataVisitorNode child = children.next();
                    try {
                        child.visit(this);
                        var7_6 = null;
                        this.contextState = restoreState;
                    }
                    catch (Throwable throwable) {
                        var7_6 = null;
                        this.contextState = restoreState;
                        throw throwable;
                    }
                }
            }
        }

        @Override
        public ServiceControllerContext getControllerContext() {
            return ServiceControllerContext.this;
        }

        @Override
        public ControllerState getContextState() {
            return this.contextState;
        }

        @Override
        public void addDependency(DependencyItem dependency) {
            ServiceControllerContext.this.getDependencyInfo().addIDependOn(dependency);
        }

        @Override
        public void setContextState(ControllerState contextState) {
            this.contextState = contextState;
        }
    }
}

