/*
 * Decompiled with CFR 0.152.
 */
package org.jnp.server;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Collection;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import org.jnp.interfaces.Naming;

public class NamingServerGuard
implements Naming,
Serializable {
    private static final long serialVersionUID = 1875763972368932742L;
    private final Naming securedNaming;
    public static final String GUARDED_JNDI_METHOD_NAMES = "bind,rebind,unbind,createSubcontext";

    public NamingServerGuard(Naming securedNaming) {
        this.securedNaming = securedNaming;
    }

    public void bind(Name name, Object obj, String className) throws NamingException, RemoteException {
        throw new NoPermissionException("bind JNDI operation not allowed when calling from outside NamingServer's VM.");
    }

    public void rebind(Name name, Object obj, String className) throws NamingException, RemoteException {
        throw new NoPermissionException("rebind JNDI operation not allowed when calling from outside NamingServer's VM.");
    }

    public void unbind(Name name) throws NamingException, RemoteException {
        throw new NoPermissionException("unbind JNDI operation not allowed when calling from outside NamingServer's VM.");
    }

    public Object lookup(Name name) throws NamingException, RemoteException {
        return this.securedNaming.lookup(name);
    }

    public Collection list(Name name) throws NamingException, RemoteException {
        return this.securedNaming.list(name);
    }

    public Collection listBindings(Name name) throws NamingException, RemoteException {
        return this.securedNaming.listBindings(name);
    }

    public Context createSubcontext(Name name) throws NamingException, RemoteException {
        throw new NoPermissionException("createSubcontext JNDI operation not allowed when calling from outside NamingServer's VM.");
    }
}

