/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.rmi.NoSuchObjectException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteStub;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import javax.naming.NoPermissionException;
import org.jboss.ha.client.loadbalance.LoadBalancePolicy;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.interfaces.HARMIClient;
import org.jboss.ha.framework.interfaces.HARMIProxy;
import org.jboss.ha.framework.interfaces.HARMIResponse;
import org.jboss.ha.framework.interfaces.HARMIServer;
import org.jboss.ha.framework.server.HATarget;
import org.jboss.invocation.MarshalledInvocation;
import org.jboss.logging.Logger;
import org.jboss.net.sockets.DefaultSocketFactory;

public class HARMIServerImpl
implements HARMIServer {
    protected Object handler;
    protected Map invokerMap = new HashMap();
    protected Logger log;
    protected RemoteStub rmistub;
    protected Object stub;
    protected String key;
    protected Class intf;
    protected RefreshProxiesHATarget target;
    protected static final int MAX_CONCURRENT_REQUESTS = Integer.MAX_VALUE;
    protected Semaphore startStopSemaphore = new Semaphore(0, true);

    public HARMIServerImpl(HAPartition partition, String replicantName, Class intf, Object handler, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws Exception {
        this(partition, replicantName, intf, handler, port, csf, ssf, null);
    }

    public HARMIServerImpl(HAPartition partition, String replicantName, Class intf, Object handler, int port, RMIClientSocketFactory clientSocketFactory, RMIServerSocketFactory serverSocketFactory, InetAddress bindAddress) throws Exception {
        this.handler = handler;
        this.log = Logger.getLogger(this.getClass());
        this.intf = intf;
        this.key = partition.getPartitionName() + "/" + replicantName;
        Class<?>[] ifaces = handler.getClass().getInterfaces();
        for (int i = 0; i < ifaces.length; ++i) {
            Map tmp = MarshalledInvocation.methodToHashesMap(ifaces[i]);
            this.invokerMap.putAll(tmp);
        }
        if (bindAddress != null) {
            if (serverSocketFactory == null) {
                serverSocketFactory = new DefaultSocketFactory(bindAddress);
            } else {
                try {
                    Class[] parameterTypes = new Class[]{String.class};
                    Class<?> ssfClass = serverSocketFactory.getClass();
                    Method m = ssfClass.getMethod("setBindAddress", parameterTypes);
                    Object[] args = new Object[]{bindAddress.getHostAddress()};
                    m.invoke((Object)serverSocketFactory, args);
                }
                catch (NoSuchMethodException e) {
                    this.log.warn((Object)"Socket factory does not support setBindAddress(String)");
                }
                catch (Exception e) {
                    this.log.warn((Object)("Failed to setBindAddress=" + bindAddress + " on socket factory"), (Throwable)e);
                }
            }
        }
        this.rmistub = (RemoteStub)UnicastRemoteObject.exportObject(this, port, clientSocketFactory, serverSocketFactory);
        this.target = new RefreshProxiesHATarget(partition, replicantName, this.rmistub, 2);
        HARMIServer.rmiServers.put(this.key, this);
        this.startStopSemaphore.release(Integer.MAX_VALUE);
    }

    public HARMIServerImpl(HAPartition partition, String replicantName, Class intf, Object handler) throws Exception {
        this(partition, replicantName, intf, handler, 0, null, null);
    }

    public Object createHAStub(LoadBalancePolicy policy) {
        HARMIClient client = new HARMIClient(this.target.getReplicants(), this.target.getCurrentViewId(), policy, this.key, this.handler);
        this.target.addProxy(client);
        return Proxy.newProxyInstance(this.intf.getClassLoader(), new Class[]{this.intf, HARMIProxy.class}, (InvocationHandler)client);
    }

    public void destroy() {
        try {
            HARMIServer.rmiServers.remove(this.key);
            UnicastRemoteObject.unexportObject(this, true);
            this.startStopSemaphore.acquire(Integer.MAX_VALUE);
            this.target.destroy();
        }
        catch (Exception e) {
            this.log.error((Object)"failed to destroy", (Throwable)e);
        }
    }

    public HARMIResponse invoke(long clientViewId, MarshalledInvocation mi) throws Exception {
        mi.setMethodMap(this.invokerMap);
        Method method = mi.getMethod();
        if (!this.startStopSemaphore.tryAcquire()) {
            throw new NoSuchObjectException("HARMIServer is not running");
        }
        try {
            this.log.info((Object)("RMI local invocation =" + mi.isLocal()));
            if ("bind,rebind,unbind,createSubcontext".indexOf(method.getName()) != -1) {
                throw new NoPermissionException(method.getName() + " JNDI operation not allowed when on non-local invocation.");
            }
            HARMIResponse rsp = new HARMIResponse();
            if (clientViewId != this.target.getCurrentViewId()) {
                rsp.newReplicants = new ArrayList(this.target.getReplicants());
                rsp.currentViewId = this.target.getCurrentViewId();
            }
            rsp.response = method.invoke(this.handler, mi.getArguments());
            HARMIResponse hARMIResponse = rsp;
            return hARMIResponse;
        }
        catch (IllegalAccessException iae) {
            throw iae;
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (InvocationTargetException ite) {
            throw (Exception)ite.getTargetException();
        }
        finally {
            this.startStopSemaphore.release();
        }
    }

    public List getReplicants() throws Exception {
        return this.target.getReplicants();
    }

    public Object getLocal() throws Exception {
        return this.handler;
    }

    public class RefreshProxiesHATarget
    extends HATarget {
        protected ArrayList generatedProxies;

        public RefreshProxiesHATarget(HAPartition partition, String replicantName, Serializable target, int allowInvocations) throws Exception {
            super(partition, replicantName, target, allowInvocations);
        }

        public void init() throws Exception {
            super.init();
            this.generatedProxies = new ArrayList();
        }

        public synchronized void addProxy(HARMIClient client) {
            SoftReference<HARMIClient> ref = new SoftReference<HARMIClient>(client);
            this.generatedProxies.add(ref);
        }

        public synchronized void replicantsChanged(String key, List newReplicants, int newReplicantsViewId, boolean merge) {
            super.replicantsChanged(key, newReplicants, newReplicantsViewId, merge);
            int max = this.generatedProxies.size();
            ArrayList<SoftReference> trash = new ArrayList<SoftReference>();
            for (int i = 0; i < max; ++i) {
                SoftReference ref = (SoftReference)this.generatedProxies.get(i);
                HARMIClient proxy = (HARMIClient)ref.get();
                if (proxy == null) {
                    trash.add(ref);
                    continue;
                }
                proxy.updateClusterInfo(this.replicants, this.clusterViewId);
            }
            if (trash.size() > 0) {
                this.generatedProxies.removeAll(trash);
            }
        }
    }
}

