/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.http.server;

import java.util.ArrayList;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.ha.framework.interfaces.GenericClusteringException;
import org.jboss.ha.framework.interfaces.HARMIResponse;
import org.jboss.ha.framework.server.HATarget;
import org.jboss.invocation.Invocation;
import org.jboss.logging.Logger;
import org.jboss.mx.util.DynamicMBeanSupport;
import org.jboss.mx.util.JMXExceptionDecoder;

public class HAInvokerWrapper
extends DynamicMBeanSupport {
    private static Logger log = Logger.getLogger(HAInvokerWrapper.class);
    private MBeanServer mbeanServer;
    private MBeanInfo info;
    private ObjectName targetName;
    private HATarget target;

    public HAInvokerWrapper(MBeanServer mbeanServer, ObjectName targetName, HATarget target) {
        this.mbeanServer = mbeanServer;
        this.targetName = targetName;
        this.target = target;
        MBeanAttributeInfo[] attrInfo = null;
        MBeanConstructorInfo[] ctorInfo = null;
        MBeanParameterInfo[] sig = new MBeanParameterInfo[]{new MBeanParameterInfo("invocation", Invocation.class.getName(), "The invocation content information")};
        MBeanOperationInfo[] opInfo = new MBeanOperationInfo[]{new MBeanOperationInfo("invoke", "The detached invoker entry point", sig, "java.lang.Object", 1)};
        MBeanNotificationInfo[] eventInfo = null;
        this.info = new MBeanInfo(((Object)((Object)this)).getClass().getName(), "A wrapper inovker that delegates to the target invoker", attrInfo, ctorInfo, opInfo, eventInfo);
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (params == null || params.length != 1 || !(params[0] instanceof Invocation)) {
            NoSuchMethodException e = new NoSuchMethodException(actionName);
            throw new ReflectionException(e, actionName);
        }
        Invocation invocation = (Invocation)params[0];
        try {
            Object value = this.invoke(invocation);
            return value;
        }
        catch (Exception e) {
            throw new ReflectionException(e, "Invoke failure");
        }
    }

    public Object invoke(Invocation invocation) throws Exception {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Object[] args = new Object[]{invocation};
            String[] sig = new String[]{"org.jboss.invocation.Invocation"};
            Object rtn = this.mbeanServer.invoke(this.targetName, "invoke", args, sig);
            Long clientViewId = (Long)invocation.getValue((Object)"CLUSTER_VIEW_ID");
            HARMIResponse rsp = new HARMIResponse();
            if (clientViewId.longValue() != this.target.getCurrentViewId()) {
                rsp.newReplicants = new ArrayList(this.target.getReplicants());
                rsp.currentViewId = this.target.getCurrentViewId();
            }
            rsp.response = rtn;
            HARMIResponse hARMIResponse = rsp;
            return hARMIResponse;
        }
        catch (Exception e2) {
            Throwable e2 = (Exception)JMXExceptionDecoder.decode((Throwable)e2);
            if (e2 instanceof JMException) {
                e2 = new GenericClusteringException(1, e2.getMessage());
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)"operation failed", e2);
            }
            throw e2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    public MBeanInfo getMBeanInfo() {
        return this.info;
    }
}

