/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.legacy.jnp;

import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.legacy.jnp.JNPSubsystemNamespace;
import org.jboss.legacy.jnp.JNPSubsystemXMLAttribute;
import org.jboss.legacy.jnp.JNPSubsystemXMLElement;
import org.jboss.legacy.jnp.connector.JNPServerConnectorResourceDefinition;
import org.jboss.legacy.jnp.infinispan.DistributedTreeManagerResourceDefinition;
import org.jboss.legacy.jnp.server.JNPServerResourceDefinition;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class JNPSubsystem10Parser
implements XMLElementReader<List<ModelNode>> {
    public static final JNPSubsystem10Parser INSTANCE = new JNPSubsystem10Parser();

    protected JNPSubsystem10Parser() {
    }

    public void readElement(XMLExtendedStreamReader xmlExtendedStreamReader, List<ModelNode> result) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)xmlExtendedStreamReader);
        ModelNode jnpSubsystemAddOperation = Util.createAddOperation();
        jnpSubsystemAddOperation.get("address").add("subsystem", "legacy-jnp");
        result.add(jnpSubsystemAddOperation);
        ModelNode jnpServerServiceAddOperation = Util.createAddOperation();
        jnpServerServiceAddOperation.get("address").add("subsystem", "legacy-jnp").add("service", "jnp-server");
        result.add(jnpServerServiceAddOperation);
        ModelNode jnpServerConnectorServiceAddOperation = Util.createAddOperation();
        jnpServerConnectorServiceAddOperation.get("address").add("subsystem", "legacy-jnp").add("service", "jnp-connector");
        result.add(jnpServerConnectorServiceAddOperation);
        ModelNode distributedTreManagerServiceAddOperation = Util.createAddOperation();
        distributedTreManagerServiceAddOperation.get("address").add("subsystem", "legacy-jnp").add("service", "distributed-cache");
        EnumSet<JNPSubsystemXMLElement> encountered = EnumSet.noneOf(JNPSubsystemXMLElement.class);
        block5: while (xmlExtendedStreamReader.hasNext() && xmlExtendedStreamReader.nextTag() != 2) {
            if (JNPSubsystemNamespace.forUri(xmlExtendedStreamReader.getNamespaceURI()) != JNPSubsystemNamespace.LEGACY_JNP_1_0) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)xmlExtendedStreamReader);
            }
            JNPSubsystemXMLElement element = JNPSubsystemXMLElement.forName(xmlExtendedStreamReader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)xmlExtendedStreamReader);
            }
            switch (element) {
                case JNP_CONNECTOR: {
                    this.parseJNPConnector(xmlExtendedStreamReader, jnpServerConnectorServiceAddOperation);
                    continue block5;
                }
                case JNP_SERVER: {
                    this.parseJNPServer(xmlExtendedStreamReader, jnpServerServiceAddOperation);
                    continue block5;
                }
                case DISTRIBUTED_CACHE: {
                    this.parseDistributedCache(xmlExtendedStreamReader, distributedTreManagerServiceAddOperation, jnpServerConnectorServiceAddOperation);
                    JNPServerResourceDefinition.HA.parseAndSetParameter("true", jnpServerServiceAddOperation, (XMLStreamReader)xmlExtendedStreamReader);
                    result.add(distributedTreManagerServiceAddOperation);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)xmlExtendedStreamReader);
        }
    }

    private void parseJNPServer(XMLExtendedStreamReader xmlExtendedStreamReader, ModelNode jnpServerServiceAddOperation) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)xmlExtendedStreamReader);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)xmlExtendedStreamReader);
    }

    private void parseJNPConnector(XMLExtendedStreamReader xmlExtendedStreamReader, ModelNode jnpServerConnectorServiceAddOperation) throws XMLStreamException {
        block4: for (int i = 0; i < xmlExtendedStreamReader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)xmlExtendedStreamReader, (int)i);
            String value = xmlExtendedStreamReader.getAttributeValue(i);
            switch (JNPSubsystemXMLAttribute.forName(xmlExtendedStreamReader.getAttributeLocalName(i))) {
                case SOCKET_BINDING: {
                    JNPServerConnectorResourceDefinition.SOCKET_BINDING.parseAndSetParameter(value, jnpServerConnectorServiceAddOperation, (XMLStreamReader)xmlExtendedStreamReader);
                    continue block4;
                }
                case RMI_SOCKET_BINDING: {
                    JNPServerConnectorResourceDefinition.RMI_SOCKET_BINDING.parseAndSetParameter(value, jnpServerConnectorServiceAddOperation, (XMLStreamReader)xmlExtendedStreamReader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)xmlExtendedStreamReader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)xmlExtendedStreamReader);
    }

    private boolean parseDistributedCache(XMLExtendedStreamReader xmlExtendedStreamReader, ModelNode distributedTreManagerServiceAddOperation, ModelNode jnpServerConnectorServiceAddOperation) throws XMLStreamException {
        block4: for (int i = 0; i < xmlExtendedStreamReader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)xmlExtendedStreamReader, (int)i);
            String value = xmlExtendedStreamReader.getAttributeValue(i);
            switch (JNPSubsystemXMLAttribute.forName(xmlExtendedStreamReader.getAttributeLocalName(i))) {
                case CACHE_CONTAINER: {
                    DistributedTreeManagerResourceDefinition.CACHE_CONTAINER.parseAndSetParameter(value, distributedTreManagerServiceAddOperation, (XMLStreamReader)xmlExtendedStreamReader);
                    JNPServerConnectorResourceDefinition.CACHE_CONTAINER.parseAndSetParameter(value, jnpServerConnectorServiceAddOperation, (XMLStreamReader)xmlExtendedStreamReader);
                    continue block4;
                }
                case CACHE_REF: {
                    DistributedTreeManagerResourceDefinition.CACHE_REF.parseAndSetParameter(value, distributedTreManagerServiceAddOperation, (XMLStreamReader)xmlExtendedStreamReader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)xmlExtendedStreamReader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)xmlExtendedStreamReader);
        return true;
    }
}

