/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.legacy.jnp;

import java.util.HashMap;
import java.util.Map;

public enum JNPSubsystemXMLElement {
    UNKNOWN(null),
    JNP_CONNECTOR("jnp-connector"),
    JNP_SERVER("jnp-server"),
    DISTRIBUTED_CACHE("distributed-cache");

    private final String name;
    private static final Map<String, JNPSubsystemXMLElement> MAP;

    private JNPSubsystemXMLElement(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static JNPSubsystemXMLElement forName(String localName) {
        JNPSubsystemXMLElement element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, JNPSubsystemXMLElement> map = new HashMap<String, JNPSubsystemXMLElement>(5);
        for (JNPSubsystemXMLElement element : JNPSubsystemXMLElement.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

