/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.legacy.jnp;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.legacy.jnp.JNPSubsystemNamespace;
import org.jboss.legacy.jnp.JNPSubsystemXMLElement;
import org.jboss.legacy.jnp.connector.JNPServerConnectorResourceDefinition;
import org.jboss.legacy.jnp.infinispan.DistributedTreeManagerResourceDefinition;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class JNPSubsystemXMLPersister
implements XMLElementWriter<SubsystemMarshallingContext> {
    public static final JNPSubsystemXMLPersister INSTANCE = new JNPSubsystemXMLPersister();

    public void writeContent(XMLExtendedStreamWriter xmlExtendedStreamWriter, SubsystemMarshallingContext subsystemMarshallingContext) throws XMLStreamException {
        subsystemMarshallingContext.startSubsystemElement(JNPSubsystemNamespace.LEGACY_JNP_1_0.getUriString(), false);
        this.writeElements(xmlExtendedStreamWriter, subsystemMarshallingContext);
        xmlExtendedStreamWriter.writeEndElement();
    }

    private void writeElements(XMLExtendedStreamWriter xmlExtendedStreamWriter, SubsystemMarshallingContext subsystemMarshallingContext) throws XMLStreamException {
        if (subsystemMarshallingContext.getModelNode().hasDefined("service")) {
            ModelNode model = subsystemMarshallingContext.getModelNode().get("service");
            if (model.hasDefined("jnp-server")) {
                this.writeJNPServer(xmlExtendedStreamWriter);
            }
            if (model.hasDefined("jnp-connector")) {
                this.writeConnector(xmlExtendedStreamWriter, subsystemMarshallingContext);
            }
            if (model.hasDefined("distributed-cache")) {
                ModelNode treeModel = model.get("distributed-cache");
                if (model.hasDefined("cache-container") && treeModel.hasDefined("cache-ref")) {
                    this.writeDistributedCache(xmlExtendedStreamWriter, treeModel);
                }
            }
        }
    }

    private void writeConnector(XMLExtendedStreamWriter xmlExtendedStreamWriter, SubsystemMarshallingContext subsystemMarshallingContext) throws XMLStreamException {
        ModelNode model = subsystemMarshallingContext.getModelNode().get("service").get("jnp-connector");
        xmlExtendedStreamWriter.writeStartElement(JNPSubsystemXMLElement.JNP_CONNECTOR.getLocalName());
        if (model.hasDefined("socket-binding")) {
            JNPServerConnectorResourceDefinition.SOCKET_BINDING.marshallAsAttribute(model, true, (XMLStreamWriter)xmlExtendedStreamWriter);
        }
        if (model.hasDefined("rmi-socket-binding")) {
            JNPServerConnectorResourceDefinition.RMI_SOCKET_BINDING.marshallAsAttribute(model, true, (XMLStreamWriter)xmlExtendedStreamWriter);
        }
        xmlExtendedStreamWriter.writeEndElement();
    }

    private void writeJNPServer(XMLExtendedStreamWriter xmlExtendedStreamWriter) throws XMLStreamException {
        xmlExtendedStreamWriter.writeStartElement(JNPSubsystemXMLElement.JNP_SERVER.getLocalName());
        xmlExtendedStreamWriter.writeEndElement();
    }

    private void writeDistributedCache(XMLExtendedStreamWriter xmlExtendedStreamWriter, ModelNode treeModel) throws XMLStreamException {
        xmlExtendedStreamWriter.writeStartElement(JNPSubsystemXMLElement.DISTRIBUTED_CACHE.getLocalName());
        DistributedTreeManagerResourceDefinition.CACHE_CONTAINER.marshallAsAttribute(treeModel, true, (XMLStreamWriter)xmlExtendedStreamWriter);
        DistributedTreeManagerResourceDefinition.CACHE_REF.marshallAsAttribute(treeModel, true, (XMLStreamWriter)xmlExtendedStreamWriter);
        xmlExtendedStreamWriter.writeEndElement();
    }
}

