/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.legacy.jnp.infinispan;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.clustering.ClusterNode;
import org.jboss.legacy.jnp.infinispan.ClusterNodeProxy;
import org.jgroups.stack.IpAddress;

public class ClusterNodeAdapter
implements ClusterNode {
    private final ClusterNodeProxy node;

    public ClusterNodeAdapter(ClusterNodeProxy node) {
        this.node = node;
    }

    public String getName() {
        return this.node.getName();
    }

    public InetAddress getIpAddress() {
        return this.node.getIpAddress();
    }

    public int getPort() {
        return this.node.getPort();
    }

    public int compareTo(ClusterNode o) {
        return this.getId(this).compareTo(this.getId(o));
    }

    private String getId(ClusterNode node) {
        IpAddress address = new IpAddress(node.getIpAddress(), node.getPort());
        return address.getIpAddress().getHostAddress() + ":" + address.getPort();
    }

    public static List<ClusterNodeProxy> convertToList(List<ClusterNode> nodes) {
        ArrayList<ClusterNodeProxy> result = new ArrayList<ClusterNodeProxy>(nodes.size());
        for (ClusterNode node : nodes) {
            result.add(new ClusterNodeProxy(node.getIpAddress(), node.getName(), node.getPort()));
        }
        return result;
    }

    public static List<List<ClusterNodeProxy>> convertListOfList(List<List<ClusterNode>> nodes) {
        ArrayList<List<ClusterNodeProxy>> result = new ArrayList<List<ClusterNodeProxy>>(nodes.size());
        for (List<ClusterNode> list : nodes) {
            result.add(ClusterNodeAdapter.convertToList(list));
        }
        return result;
    }
}

