/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dependency.plugins;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.dependency.plugins.AbstractAliasControllerContext;
import org.jboss.dependency.plugins.AbstractControllerContextActions;
import org.jboss.dependency.plugins.AbstractControllerMBean;
import org.jboss.dependency.plugins.AliasControllerContext;
import org.jboss.dependency.plugins.JMXObjectNameFix;
import org.jboss.dependency.plugins.SecurityActions;
import org.jboss.dependency.plugins.StateStatistics;
import org.jboss.dependency.plugins.action.ControllerContextAction;
import org.jboss.dependency.plugins.action.SimpleControllerContextAction;
import org.jboss.dependency.spi.CallbackItem;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerContextActions;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.ControllerStateModel;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.dependency.spi.LifecycleCallbackItem;
import org.jboss.dependency.spi.graph.GraphController;
import org.jboss.dependency.spi.graph.LookupStrategy;
import org.jboss.dependency.spi.graph.SearchInfo;
import org.jboss.util.JBossObject;
import org.jboss.util.collection.CollectionsFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractController
extends JBossObject
implements Controller,
ControllerStateModel,
GraphController,
AbstractControllerMBean {
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Executor executor;
    private boolean shutdown = false;
    private List<ControllerState> states = new CopyOnWriteArrayList<ControllerState>();
    private Map<Object, ControllerContext> allContexts = new ConcurrentHashMap<Object, ControllerContext>();
    private Map<ControllerState, Set<ControllerContext>> contextsByState = new ConcurrentHashMap<ControllerState, Set<ControllerContext>>();
    private Map<Object, ControllerContext> errorContexts = new ConcurrentHashMap<Object, ControllerContext>();
    private Set<ControllerContext> installing = new CopyOnWriteArraySet<ControllerContext>();
    private AbstractController parentController;
    private Set<AbstractController> childControllers = new CopyOnWriteArraySet<AbstractController>();
    private Map<Object, Set<CallbackItem<?>>> installCallbacks = new ConcurrentHashMap();
    private Map<Object, Set<CallbackItem<?>>> uninstallCallbacks = new ConcurrentHashMap();
    private boolean onDemandEnabled = true;
    private boolean collectStats = false;
    private volatile StateStatistics installStats = null;

    public AbstractController() {
        this.addState(ControllerState.NOT_INSTALLED, null);
        this.addState(ControllerState.PRE_INSTALL, null);
        this.addState(ControllerState.DESCRIBED, null);
        this.addState(ControllerState.INSTANTIATED, null);
        this.addState(ControllerState.CONFIGURED, null);
        this.addState(ControllerState.CREATE, null);
        this.addState(ControllerState.START, null);
        this.addState(ControllerState.INSTALLED, null);
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public Executor getExecutor() {
        return this.getExecutionEnvironment();
    }

    protected Executor getExecutionEnvironment() {
        return this.executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isShutdown() {
        this.lockWrite();
        try {
            boolean bl = this.shutdown;
            return bl;
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkShutdown() {
        this.lockWrite();
        try {
            if (this.shutdown) {
                throw new IllegalStateException("Already shutdown");
            }
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.lockWrite();
        try {
            Set<ControllerContext> contexts;
            Set<AbstractController> children = this.getControllers();
            if (children != null && !children.isEmpty()) {
                for (AbstractController child : children) {
                    try {
                        child.shutdown();
                    }
                    catch (Throwable t) {
                        this.log.warn((Object)("Error during shutdown of child: " + child), t);
                    }
                }
            }
            if ((contexts = this.getAllContexts()) != null && !contexts.isEmpty()) {
                for (ControllerContext context : contexts) {
                    try {
                        this.uninstall(context.getName());
                    }
                    catch (Throwable t) {
                        this.log.warn((Object)("Error during shutdown while uninstalling: " + context), t);
                    }
                }
            }
        }
        finally {
            this.shutdown = true;
            this.unlockWrite();
        }
    }

    public boolean isCollectStats() {
        return this.collectStats;
    }

    public void setCollectStats(boolean collectStats) {
        this.collectStats = collectStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String listStateTimes(boolean details) {
        AbstractController abstractController = this;
        synchronized (abstractController) {
            if (this.installStats == null) {
                return "No statistics available";
            }
            return this.installStats.listTimes(details);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addState(ControllerState state, ControllerState before) {
        this.lockWrite();
        try {
            if (this.states.contains(state)) {
                return;
            }
            if (before == null) {
                this.states.add(state);
            } else {
                this.states.add(this.getStateIndex(before), state);
            }
            CopyOnWriteArraySet contexts = new CopyOnWriteArraySet();
            this.contextsByState.put(state, contexts);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addControllerContext(ControllerContext context) {
        this.lockWrite();
        try {
            this.registerControllerContext(context);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeControllerContext(ControllerContext context) {
        this.lockWrite();
        try {
            this.unregisterControllerContext(context);
        }
        finally {
            this.unlockWrite();
        }
    }

    public AbstractController getParentController() {
        return this.parentController;
    }

    protected void setParentController(AbstractController parentController) {
        this.parentController = parentController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<AbstractController> getControllers() {
        this.lockRead();
        try {
            Set<AbstractController> set = Collections.unmodifiableSet(this.childControllers);
            return set;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addController(AbstractController controller) {
        this.lockWrite();
        try {
            boolean bl = this.childControllers.add(controller);
            return bl;
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeController(AbstractController controller) {
        this.lockWrite();
        try {
            boolean bl = this.childControllers.remove(controller);
            return bl;
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        this.lockRead();
        try {
            if (!this.allContexts.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            for (AbstractController child : this.getControllers()) {
                if (!child.isActive()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public ControllerContext getContext(Object name, ControllerState state, SearchInfo info) {
        if (info == null) {
            throw new IllegalArgumentException("Null search info.");
        }
        LookupStrategy strategy = info.getStrategy();
        if (strategy == null) {
            throw new IllegalArgumentException("AbstractController doesn't implement this search info: " + info);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Executing search " + info.getType()));
        }
        return strategy.getContext(this, name, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ControllerContext> getAllContexts() {
        this.lockRead();
        try {
            LinkedHashSet<ControllerContext> result = new LinkedHashSet<ControllerContext>();
            for (int i = this.states.size() - 1; i >= 0; --i) {
                ControllerState state = this.states.get(i);
                result.addAll((Collection<ControllerContext>)this.contextsByState.get(state));
            }
            result.addAll(this.errorContexts.values());
            LinkedHashSet<ControllerContext> linkedHashSet = result;
            return linkedHashSet;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ControllerContext getContext(Object name, ControllerState state) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        this.lockRead();
        try {
            ControllerContext result = this.getRegisteredControllerContext(name, false);
            if (result != null && state != null && this.isBeforeState(result.getState(), state)) {
                ControllerContext controllerContext = null;
                return controllerContext;
            }
            ControllerContext controllerContext = result;
            return controllerContext;
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public ControllerContext getInstalledContext(Object name) {
        return this.getContext(name, ControllerState.INSTALLED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ControllerContext> getNotInstalled() {
        this.lockWrite();
        try {
            HashSet<ControllerContext> result = new HashSet<ControllerContext>(this.errorContexts.values());
            int i = 0;
            while (!ControllerState.INSTALLED.equals(this.states.get(i))) {
                Set<ControllerContext> stateContexts = this.getContextsByState(this.states.get(i));
                result.addAll(stateContexts);
                ++i;
            }
            HashSet<ControllerContext> hashSet = result;
            return hashSet;
        }
        finally {
            this.unlockWrite();
        }
    }

    @Override
    public ControllerStateModel getStates() {
        return this;
    }

    @Override
    public Set<ControllerContext> getContextsByState(ControllerState state) {
        return this.contextsByState.get(state);
    }

    @Override
    public void install(ControllerContext context) throws Throwable {
        boolean trace = this.log.isTraceEnabled();
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        Object name = context.getName();
        if (name == null) {
            throw new IllegalArgumentException("Null name " + context.toShortString());
        }
        this.install(context, trace);
    }

    @Override
    public void change(ControllerContext context, ControllerState state) throws Throwable {
        boolean trace = this.log.isTraceEnabled();
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        if (state == null) {
            throw new IllegalArgumentException("Null state");
        }
        this.change(context, state, trace);
    }

    @Override
    public void enableOnDemand(ControllerContext context) throws Throwable {
        boolean trace = this.log.isTraceEnabled();
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        this.enableOnDemand(context, trace);
    }

    @Override
    public ControllerContext uninstall(Object name) {
        return this.uninstall(name, 0);
    }

    protected String getId() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getSimpleName());
        buffer.append("[").append(System.identityHashCode(this)).append("]");
        return buffer.toString();
    }

    @Override
    public void addAlias(Object alias, Object original) throws Throwable {
        Map<ControllerState, ControllerContextAction> map = this.createAliasActions();
        AbstractControllerContextActions actions = new AbstractControllerContextActions(map);
        InnerAliasControllerContext context = new InnerAliasControllerContext(alias, this.getId(), original, actions);
        this.preAliasInstall(context);
        this.install(context);
        Throwable error = context.getError();
        if (error != null) {
            throw error;
        }
        if (ControllerState.ERROR.equals(context.getState())) {
            throw new IllegalArgumentException("Alias " + context + " is in error.");
        }
    }

    protected Map<ControllerState, ControllerContextAction> createAliasActions() {
        return Collections.singletonMap(ControllerState.INSTALLED, new AliasControllerContextAction());
    }

    protected void preAliasInstall(ControllerContext aliasContext) {
    }

    @Override
    public void removeAlias(Object alias) {
        this.uninstall(alias + "_Alias_" + this.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ControllerContext uninstall(Object name, int level) {
        boolean trace = this.log.isTraceEnabled();
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        this.lockWrite();
        try {
            ControllerContext context;
            if (this.errorContexts.remove(name) != null && trace) {
                this.log.trace((Object)("Tidied up context in error state: " + name));
            }
            if ((context = this.getRegisteredControllerContext(name, false)) != null) {
                if (trace) {
                    this.log.trace((Object)("Uninstalling " + context.toShortString()));
                }
                AbstractController parent = this.getParentController();
                this.uninstallContext(context, ControllerState.NOT_INSTALLED, trace);
                try {
                    this.unregisterControllerContext(context);
                }
                catch (Throwable t) {
                    this.log.warn((Object)("Error unregistering context: " + context.toShortString() + " with name: " + name));
                }
                while (parent != null) {
                    try {
                        parent.unregisterControllerContext(context);
                    }
                    catch (Throwable t) {
                        this.log.warn((Object)("Error unregistering context in parent controller: " + context.toShortString() + " with name: " + name));
                    }
                    parent = parent.getParentController();
                }
            } else {
                AbstractController controller;
                Iterator<AbstractController> i$ = this.getControllers().iterator();
                while (i$.hasNext() && (context = (controller = i$.next()).uninstall(name, level + 1)) == null) {
                }
            }
            if (context == null && level == 0) {
                throw new IllegalStateException("Not installed: " + name);
            }
            ControllerContext controllerContext = context;
            return controllerContext;
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void install(ControllerContext context, boolean trace) throws Throwable {
        block17: {
            this.lockWrite();
            try {
                boolean ok;
                this.checkShutdown();
                Object name = context.getName();
                if (this.getRegisteredControllerContext(name, false) != null) {
                    throw new IllegalStateException(name + " is already installed.");
                }
                Set<Object> aliases = context.getAliases();
                if (aliases != null && !aliases.isEmpty()) {
                    for (Object alias : aliases) {
                        if (this.getRegisteredControllerContext(alias, false) == null) continue;
                        throw new IllegalStateException(alias + " an alias of " + name + " is already installed.");
                    }
                }
                ControllerMode mode = context.getMode();
                context.setRequiredState(mode.getRequiredState());
                if (trace) {
                    this.log.trace((Object)("Installing " + context.toShortString()));
                }
                context.setController(this);
                DependencyInfo dependencies = context.getDependencyInfo();
                if (trace) {
                    String dependsOn = "[]";
                    if (dependencies != null) {
                        try {
                            Set<DependencyItem> set = dependencies.getIDependOn(null);
                            if (set != null) {
                                dependsOn = set.toString();
                            }
                        }
                        catch (Throwable t) {
                            this.log.warn((Object)("Exception getting dependencies: " + t));
                            dependsOn = null;
                        }
                    }
                    if (dependsOn != null) {
                        this.log.trace((Object)("Dependencies for " + name + ": " + dependsOn));
                    }
                }
                if (ok = this.incrementState(context, trace)) {
                    try {
                        this.registerControllerContext(context);
                    }
                    catch (Throwable t) {
                        ok = false;
                        throw t;
                    }
                }
                if (ok) {
                    this.resolveContexts(trace);
                    break block17;
                }
                this.errorContexts.remove(context);
                throw context.getError();
            }
            finally {
                this.unlockWrite();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void change(ControllerContext context, ControllerState state, boolean trace) throws Throwable {
        this.lockWrite();
        try {
            this.checkShutdown();
            ControllerState fromState = context.getState();
            int currentIndex = this.states.indexOf(fromState);
            int requiredIndex = this.states.indexOf(state);
            if (requiredIndex == -1) {
                throw new IllegalArgumentException("Unknown state: " + state);
            }
            if (currentIndex == requiredIndex) {
                if (trace) {
                    this.log.trace((Object)("No change required toState=" + state.getStateString() + " " + context.toShortString()));
                }
                return;
            }
            if (trace) {
                this.log.trace((Object)("Change toState=" + state.getStateString() + " " + context.toShortString()));
            }
            context.setRequiredState(state);
            if (currentIndex < requiredIndex) {
                this.resolveContexts(trace);
            } else {
                while (currentIndex > requiredIndex) {
                    this.uninstallContext(context, trace);
                    currentIndex = this.states.indexOf(context.getState());
                }
            }
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enableOnDemand(ControllerContext context, boolean trace) throws Throwable {
        this.lockWrite();
        try {
            this.checkShutdown();
            if (!ControllerMode.ON_DEMAND.equals((Object)context.getMode())) {
                throw new IllegalStateException("Context is not ON DEMAND: " + context.toShortString());
            }
            this.getRegisteredControllerContext(context.getName(), true);
            if (ControllerState.INSTALLED.equals(context.getRequiredState())) {
                return;
            }
            context.setRequiredState(ControllerState.INSTALLED);
            if (trace) {
                this.log.trace((Object)("Enable onDemand: " + context.toShortString()));
            }
            this.onDemandEnabled = true;
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean incrementState(ControllerContext context, boolean trace) {
        ControllerState fromState = context.getState();
        Controller fromController = context.getController();
        Set<ControllerContext> fromContexts = null;
        int currentIndex = -1;
        if (ControllerState.ERROR.equals(fromState)) {
            this.errorContexts.remove(context);
            Throwable error = null;
            this.unlockWrite();
            try {
                this.install(context, ControllerState.ERROR, ControllerState.NOT_INSTALLED);
            }
            catch (Throwable t) {
                error = t;
                return (boolean)error;
            }
            finally {
                this.lockWrite();
                if (error != null) {
                    this.log.error((Object)("Error during initial installation: " + context.toShortString()), error);
                    context.setError(error);
                    this.errorContexts.put(context.getName(), context);
                    return false;
                }
            }
            Set<ControllerContext> notInstalled = fromController.getContextsByState(ControllerState.NOT_INSTALLED);
            notInstalled.add(context);
            context.setState(ControllerState.NOT_INSTALLED);
        } else {
            currentIndex = this.states.indexOf(fromState);
            fromContexts = fromController.getContextsByState(fromState);
            if (!fromContexts.contains(context)) {
                throw new IllegalStateException("Context not found in previous state: " + context.toShortString());
            }
        }
        int toIndex = currentIndex + 1;
        ControllerState toState = this.states.get(toIndex);
        this.unlockWrite();
        Throwable error = null;
        try {
            this.install(context, fromState, toState);
            if (fromContexts != null) {
                fromContexts.remove(context);
            }
            Controller toController = context.getController();
            Set<ControllerContext> toContexts = toController.getContextsByState(toState);
            toContexts.add(context);
            context.setState(toState);
            this.handleInstallLifecycleCallbacks(context, toState);
            this.resolveCallbacks(context, toState, true);
        }
        catch (Throwable t) {
            error = t;
            return (boolean)error;
        }
        finally {
            this.lockWrite();
            if (error != null) {
                this.log.error((Object)("Error installing to " + toState.getStateString() + ": " + context.toShortString()), error);
                this.uninstallContext(context, ControllerState.NOT_INSTALLED, trace);
                this.errorContexts.put(context.getName(), context);
                context.setError(error);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveContexts(boolean trace) {
        int i;
        boolean resolutions = true;
        block3: while (resolutions || this.onDemandEnabled) {
            this.onDemandEnabled = false;
            resolutions = false;
            for (i = 0; i < this.states.size() - 1; ++i) {
                ControllerState toState;
                ControllerState fromState = this.states.get(i);
                if (!this.resolveContexts(fromState, toState = this.states.get(i + 1), trace)) continue;
                resolutions = true;
                continue block3;
            }
        }
        if (trace) {
            for (i = 0; i < this.states.size() - 1; ++i) {
                ControllerState state = this.states.get(i);
                ControllerState nextState = this.states.get(i + 1);
                Set<ControllerContext> stillUnresolved = this.contextsByState.get(state);
                if (stillUnresolved.isEmpty()) continue;
                for (ControllerContext ctx : stillUnresolved) {
                    if (!this.advance(ctx)) continue;
                    this.log.trace((Object)("Still unresolved " + nextState.getStateString() + ": " + ctx));
                }
            }
        }
        for (AbstractController controller : this.childControllers) {
            controller.lockWrite();
            try {
                controller.resolveContexts(trace);
            }
            finally {
                controller.unlockWrite();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean resolveContexts(ControllerState fromState, ControllerState toState, boolean trace) {
        boolean resolutions;
        block16: {
            resolutions = false;
            Set<ControllerContext> unresolved = this.contextsByState.get(fromState);
            Set<ControllerContext> resolved = this.resolveContexts(unresolved, fromState, toState, trace);
            if (!resolved.isEmpty()) {
                Object name;
                HashSet<ControllerContext> toProcess = new HashSet<ControllerContext>();
                for (ControllerContext context : resolved) {
                    name = context.getName();
                    if (!fromState.equals(context.getState())) {
                        if (trace) {
                            this.log.trace((Object)("Skipping already installed " + name + " for " + toState.getStateString()));
                        }
                        this.installing.remove(context);
                        continue;
                    }
                    toProcess.add(context);
                }
                try {
                    if (!toProcess.isEmpty()) {
                        Iterator iter = toProcess.iterator();
                        while (iter.hasNext()) {
                            ControllerContext context;
                            context = (ControllerContext)iter.next();
                            iter.remove();
                            name = context.getName();
                            try {
                                if (!fromState.equals(context.getState())) {
                                    if (!trace) continue;
                                    this.log.trace((Object)("Skipping already installed " + name + " for " + toState.getStateString()));
                                    continue;
                                }
                                if (trace) {
                                    this.log.trace((Object)("Dependencies resolved " + name + " for " + toState.getStateString()));
                                }
                                if (!this.incrementState(context, trace)) continue;
                                resolutions = true;
                                if (!trace) continue;
                                this.log.trace((Object)(name + " " + toState.getStateString()));
                            }
                            finally {
                                this.installing.remove(context);
                            }
                        }
                    }
                    if (toProcess.isEmpty()) break block16;
                }
                catch (Throwable throwable) {
                    if (!toProcess.isEmpty()) {
                        for (ControllerContext context : toProcess) {
                            this.installing.remove(context);
                        }
                    }
                    throw throwable;
                }
                for (ControllerContext context : toProcess) {
                    this.installing.remove(context);
                }
            }
        }
        return resolutions;
    }

    protected Set<ControllerContext> resolveContexts(Set<ControllerContext> contexts, ControllerState fromState, ControllerState toState, boolean trace) {
        HashSet<ControllerContext> result = new HashSet<ControllerContext>();
        if (!contexts.isEmpty()) {
            for (ControllerContext ctx : contexts) {
                Object name = ctx.getName();
                if (!fromState.equals(ctx.getState())) {
                    if (!trace) continue;
                    this.log.trace((Object)("Skipping already installed " + name + " for " + toState.getStateString()));
                    continue;
                }
                if (!this.installing.add(ctx)) {
                    if (!trace) continue;
                    this.log.trace((Object)("Already installing " + name + " for " + toState.getStateString()));
                    continue;
                }
                if (this.advance(ctx)) {
                    DependencyInfo dependencies = ctx.getDependencyInfo();
                    try {
                        if (dependencies == null || dependencies.resolveDependencies(this, toState)) {
                            result.add(ctx);
                            continue;
                        }
                        this.installing.remove(ctx);
                    }
                    catch (Throwable error) {
                        this.installing.remove(ctx);
                        this.log.error((Object)("Error resolving dependencies for " + toState.getStateString() + ": " + ctx.toShortString()), error);
                        this.uninstallContext(ctx, ControllerState.NOT_INSTALLED, trace);
                        this.errorContexts.put(ctx.getName(), ctx);
                        ctx.setError(error);
                    }
                    continue;
                }
                this.installing.remove(ctx);
            }
        }
        return result;
    }

    protected void uninstallContext(ControllerContext context, ControllerState toState, boolean trace) {
        int targetState = this.states.indexOf(toState);
        if (targetState == -1) {
            this.log.error((Object)("INTERNAL ERROR: unknown state " + toState + " states=" + this.states), (Throwable)new Exception("STACKTRACE"));
        }
        ControllerState fromState;
        while (!ControllerState.ERROR.equals(fromState = context.getState())) {
            int currentState = this.states.indexOf(fromState);
            if (currentState == -1) {
                this.log.error((Object)("INTERNAL ERROR: current state not found: " + context.toShortString()), (Throwable)new Exception("STACKTRACE"));
            }
            if (targetState > currentState) {
                return;
            }
            this.uninstallContext(context, trace);
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uninstallContext(ControllerContext context, boolean trace) {
        Controller fromController;
        Set<ControllerContext> fromContexts;
        Object name = context.getName();
        ControllerState fromState = context.getState();
        if (trace) {
            this.log.trace((Object)("Uninstalling " + name + " from " + fromState.getStateString()));
        }
        if ((fromContexts = (fromController = context.getController()).getContextsByState(fromState)) == null || !fromContexts.remove(context)) {
            throw new Error("INTERNAL ERROR: context not found in previous state " + fromState.getStateString() + " context=" + context.toShortString(), new Exception("STACKTRACE"));
        }
        DependencyInfo dependencies = context.getDependencyInfo();
        if (dependencies != null) {
            try {
                Set<DependencyItem> dependsOnMe = dependencies.getDependsOnMe(null);
                if (!dependsOnMe.isEmpty()) {
                    for (DependencyItem item : dependsOnMe) {
                        ControllerState dependentState;
                        if (!item.isResolved() || (dependentState = item.getDependentState()) != null && !dependentState.equals(fromState) || !item.unresolved(this)) continue;
                        Set dependents = CollectionsFactory.createLazySet();
                        this.getContexts(item.getName(), dependents);
                        if (dependents.isEmpty()) continue;
                        ControllerState whenRequired = item.getWhenRequired();
                        if (whenRequired == null) {
                            whenRequired = ControllerState.NOT_INSTALLED;
                        }
                        for (ControllerContext dependent : dependents) {
                            boolean selfDependency = dependent == context;
                            if (selfDependency || this.isBeforeState(dependent.getState(), whenRequired)) continue;
                            this.uninstallContext(dependent, whenRequired, trace);
                        }
                    }
                }
            }
            catch (Throwable error) {
                this.log.error((Object)("Error resolving dependencies for " + fromState.getStateString() + ": " + context.toShortString()), error);
                this.errorContexts.put(context.getName(), context);
                context.setError(error);
            }
        }
        if (ControllerState.ERROR.equals(fromState = context.getState())) {
            return;
        }
        int currentIndex = this.states.indexOf(fromState);
        int toIndex = currentIndex - 1;
        if (toIndex < 0) {
            context.setState(ControllerState.ERROR);
            return;
        }
        ControllerState toState = this.states.get(toIndex);
        this.unlockWrite();
        try {
            this.resolveCallbacks(context, fromState, false);
            this.handleUninstallLifecycleCallbacks(context, toState);
            this.uninstall(context, fromState, toState);
            Controller toController = context.getController();
            Set<ControllerContext> toContexts = toController.getContextsByState(toState);
            toContexts.add(context);
            context.setState(toState);
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error uninstalling from " + fromState.getStateString() + ": " + context.toShortString()), t);
        }
        finally {
            this.lockWrite();
        }
    }

    protected void getContexts(Object name, Set<ControllerContext> contexts) {
        Set<AbstractController> children;
        Set<Object> aliases;
        ControllerContext context = this.getContext(name, null);
        if (!(context == null || (aliases = context.getAliases()) != null && aliases.contains(name))) {
            contexts.add(context);
        }
        if ((children = this.getControllers()) != null && !children.isEmpty()) {
            for (AbstractController child : children) {
                child.getContexts(name, contexts);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> void addCallback(Object name, boolean isInstallPhase, CallbackItem<T> callback) {
        this.lockWrite();
        try {
            Map<Object, Set<CallbackItem<?>>> map = isInstallPhase ? this.installCallbacks : this.uninstallCallbacks;
            Set<CallbackItem<?>> callbacks = map.get(name);
            if (callbacks == null) {
                callbacks = new HashSet();
                map.put(name, callbacks);
            }
            callbacks.add(callback);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> void removeCallback(Object name, boolean isInstallPhase, CallbackItem<T> callback) {
        this.lockWrite();
        try {
            Map<Object, Set<CallbackItem<?>>> map = isInstallPhase ? this.installCallbacks : this.uninstallCallbacks;
            Set<CallbackItem<?>> callbacks = map.get(name);
            if (callbacks != null) {
                callbacks.remove(callback);
                if (callbacks.isEmpty()) {
                    map.remove(name);
                }
            }
        }
        finally {
            this.unlockWrite();
        }
    }

    protected Set<CallbackItem<?>> getDependencyCallbacks(ControllerContext context, boolean isInstallPhase) {
        DependencyInfo di = context.getDependencyInfo();
        if (di != null) {
            return isInstallPhase ? di.getInstallItems() : di.getUninstallItems();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<CallbackItem<?>> getCallbacks(Object name, boolean isInstallPhase) {
        this.lockRead();
        try {
            Map<Object, Set<CallbackItem<?>>> map = isInstallPhase ? this.installCallbacks : this.uninstallCallbacks;
            Set<CallbackItem<?>> callbacks = map.get(name);
            Set<CallbackItem<Object>> set = callbacks != null ? callbacks : Collections.emptySet();
            return set;
        }
        finally {
            this.unlockRead();
        }
    }

    protected void resolveCallbacks(Set<CallbackItem<?>> callbacks, ControllerState state, boolean execute, boolean isInstallPhase, boolean type) {
        if (callbacks != null && !callbacks.isEmpty()) {
            for (CallbackItem<?> callback : callbacks) {
                if (!callback.getWhenRequired().equals(state)) continue;
                if (isInstallPhase) {
                    this.addCallback(callback.getIDependOn(), type, callback);
                } else {
                    this.removeCallback(callback.getIDependOn(), type, callback);
                }
                if (!execute) continue;
                try {
                    callback.ownerCallback(this, isInstallPhase);
                }
                catch (Throwable t) {
                    this.log.warn((Object)("Broken callback: " + callback), t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveCallbacks(ControllerContext context, ControllerState state, boolean isInstallPhase) {
        ClassLoader previous = null;
        try {
            previous = SecurityActions.setContextClassLoader(context);
            Set<CallbackItem<?>> installs = this.getDependencyCallbacks(context, true);
            this.resolveCallbacks(installs, state, isInstallPhase, isInstallPhase, true);
            Set<CallbackItem<?>> uninstalls = this.getDependencyCallbacks(context, false);
            this.resolveCallbacks(uninstalls, state, !isInstallPhase, isInstallPhase, false);
            DependencyInfo dependencyInfo = context.getDependencyInfo();
            if (dependencyInfo != null && dependencyInfo.isAutowireCandidate()) {
                HashSet existingCallbacks = new HashSet();
                existingCallbacks.addAll(this.getCallbacks(context.getName(), isInstallPhase));
                Collection<Class<?>> classes = this.getClassesImplemented(context.getTarget());
                if (classes != null && !classes.isEmpty()) {
                    for (Class<Object> clazz : classes) {
                        existingCallbacks.addAll(this.getCallbacks(clazz, isInstallPhase));
                    }
                }
                if (existingCallbacks != null && !existingCallbacks.isEmpty()) {
                    for (CallbackItem callbackItem : existingCallbacks) {
                        if (!state.equals(callbackItem.getDependentState())) continue;
                        try {
                            callbackItem.changeCallback(this, context, isInstallPhase);
                        }
                        catch (Throwable t) {
                            this.log.warn((Object)("Broken callback: " + callbackItem), t);
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            this.log.warn((Object)("Cannot resolve callbacks, state= " + state + ", isInstall= " + isInstallPhase + ", context= " + context), t);
        }
        finally {
            if (previous != null) {
                SecurityActions.resetContextClassLoader(previous);
            }
        }
    }

    protected void handleInstallLifecycleCallbacks(ControllerContext context, ControllerState state) throws Throwable {
        this.handleLifecycleCallbacks(context, state, true);
    }

    protected void handleUninstallLifecycleCallbacks(ControllerContext context, ControllerState state) throws Throwable {
        ControllerState oldState = this.getNextState(state);
        this.handleLifecycleCallbacks(context, oldState, false);
    }

    protected void handleLifecycleCallbacks(ControllerContext context, ControllerState state, boolean install) throws Throwable {
        DependencyInfo di = context.getDependencyInfo();
        if (di != null) {
            List<LifecycleCallbackItem> callbacks = di.getLifecycleCallbacks();
            for (LifecycleCallbackItem callback : callbacks) {
                if (!callback.getWhenRequired().equals(state)) continue;
                if (install) {
                    callback.install(context);
                    continue;
                }
                callback.uninstall(context);
            }
        }
    }

    protected Collection<Class<?>> getClassesImplemented(Object target) {
        if (target == null) {
            return null;
        }
        HashSet classes = new HashSet();
        this.traverseClass(target.getClass(), classes);
        return classes;
    }

    protected void traverseClass(Class<?> clazz, Set<Class<?>> classes) {
        if (clazz != null && !Object.class.equals(clazz)) {
            Class<?>[] interfaces;
            classes.add(clazz);
            this.traverseClass(clazz.getSuperclass(), classes);
            for (Class<?> intface : interfaces = clazz.getInterfaces()) {
                this.traverseClass(intface, classes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void install(ControllerContext context, ControllerState fromState, ControllerState toState) throws Throwable {
        long time = 0L;
        boolean collectStats = this.collectStats;
        if (collectStats) {
            time = System.currentTimeMillis();
        }
        try {
            context.install(fromState, toState);
        }
        finally {
            if (collectStats && (time = System.currentTimeMillis() - time) > 0L) {
                AbstractController abstractController = this;
                synchronized (abstractController) {
                    if (this.installStats == null) {
                        this.installStats = new StateStatistics();
                    }
                    String state = toState.getStateString();
                    String name = context.getName().toString();
                    this.installStats.addStatistic(state, name, time);
                }
            }
        }
    }

    protected void uninstall(ControllerContext context, ControllerState fromState, ControllerState toState) {
        context.uninstall(fromState, toState);
    }

    protected boolean advance(ControllerContext context) {
        ControllerMode mode = context.getMode();
        if (ControllerMode.DISABLED.equals((Object)mode)) {
            return false;
        }
        return this.isBeforeState(context.getState(), context.getRequiredState());
    }

    protected void lockRead() {
        this.lock.readLock().lock();
    }

    protected void unlockRead() {
        this.lock.readLock().unlock();
    }

    protected void lockWrite() {
        this.lock.writeLock().lock();
    }

    protected void unlockWrite() {
        this.lock.writeLock().unlock();
    }

    protected ControllerContext getRegisteredControllerContext(Object name, boolean mustExist) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        ControllerContext result = this.allContexts.get(name);
        if (mustExist && result == null) {
            throw new IllegalStateException("Context does not exist with name: " + name);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void registerControllerContext(ControllerContext context) {
        block14: {
            if (context == null) {
                throw new IllegalArgumentException("Null context");
            }
            Set<Object> aliases = context.getAliases();
            Object name = context.getName();
            this.registerControllerContext(name, context);
            if (aliases != null && !aliases.isEmpty()) {
                int ok = 0;
                for (Object alias : aliases) {
                    this.registerControllerContext(alias, context);
                    ++ok;
                }
                Object var8_7 = null;
                if (ok == aliases.size() || ok <= 0) break block14;
                for (Object alias : aliases) {
                    if (ok-- == 0) break;
                    try {
                        this.unregisterControllerContext(alias);
                    }
                    catch (Throwable ignored) {
                        this.log.debug((Object)("Error unregistering alias: " + alias), ignored);
                    }
                }
                try {
                    this.unregisterControllerContext(name);
                }
                catch (Throwable ignored) {
                    this.log.debug((Object)("Error unregistering context with name: " + name), ignored);
                }
                break block14;
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    if (ok != aliases.size() && ok > 0) {
                        for (Object alias : aliases) {
                            if (ok-- == 0) break;
                            try {
                                this.unregisterControllerContext(alias);
                            }
                            catch (Throwable ignored) {
                                this.log.debug((Object)("Error unregistering alias: " + alias), ignored);
                            }
                        }
                        try {
                            this.unregisterControllerContext(name);
                        }
                        catch (Throwable ignored) {
                            this.log.debug((Object)("Error unregistering context with name: " + name), ignored);
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    protected void unregisterControllerContext(ControllerContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        Set<Object> aliases = context.getAliases();
        Object name = context.getName();
        this.unregisterControllerContext(name);
        if (aliases != null && !aliases.isEmpty()) {
            for (Object alias : aliases) {
                try {
                    this.unregisterControllerContext(alias);
                }
                catch (Throwable ignored) {
                    this.log.debug((Object)("Error unregistering alias: " + alias), ignored);
                }
            }
        }
    }

    protected void registerControllerContext(Object name, ControllerContext context) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        if (this.allContexts.containsKey(name)) {
            throw new IllegalStateException("Unable to register context " + context.toShortString() + ", name already exists: " + name);
        }
        this.allContexts.put(name, context);
    }

    protected void unregisterControllerContext(Object name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        this.allContexts.remove(name);
    }

    @Override
    public ListIterator<ControllerState> listIteraror() {
        return this.states.listIterator(this.states.size() - 1);
    }

    @Override
    public ControllerState getPreviousState(ControllerState state) {
        return this.getState(this.getStateIndex(state) - 1);
    }

    @Override
    public ControllerState getNextState(ControllerState state) {
        return this.getState(this.getStateIndex(state) + 1);
    }

    @Override
    public boolean isBeforeState(ControllerState state, ControllerState reference) {
        int referenceIndex;
        int stateIndex = this.getStateIndex(state, true);
        return stateIndex < (referenceIndex = this.getStateIndex(reference, true));
    }

    @Override
    public boolean isAfterState(ControllerState state, ControllerState reference) {
        int referenceIndex;
        int stateIndex = this.getStateIndex(state, true);
        return stateIndex > (referenceIndex = this.getStateIndex(reference, true));
    }

    @Override
    public Iterator<ControllerState> iterator() {
        return this.states.iterator();
    }

    protected int getStateIndex(ControllerState state) {
        return this.getStateIndex(state, false);
    }

    protected int getStateIndex(ControllerState state, boolean allowNotFound) {
        if (state == null) {
            throw new IllegalArgumentException("Null state");
        }
        int stateIndex = this.states.indexOf(state);
        if (stateIndex < 0 && !allowNotFound) {
            throw new IllegalArgumentException("No such state " + state + " in states " + this.states);
        }
        return stateIndex;
    }

    protected ControllerState getState(int index) {
        if (index < 0 || index >= this.states.size()) {
            return null;
        }
        return this.states.get(index);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AliasControllerContextAction
    extends SimpleControllerContextAction<AliasControllerContext> {
        private AliasControllerContextAction() {
        }

        @Override
        protected AliasControllerContext contextCast(ControllerContext context) {
            return (AliasControllerContext)AliasControllerContext.class.cast(context);
        }

        @Override
        protected boolean validateContext(ControllerContext context) {
            return context instanceof AliasControllerContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void installAction(AliasControllerContext context) throws Throwable {
            Object original;
            Object jmxOriginal;
            Object alias = context.getAlias();
            Object jmxAlias = JMXObjectNameFix.needsAnAlias(alias);
            if (jmxAlias != null) {
                alias = jmxAlias;
            }
            if ((jmxOriginal = JMXObjectNameFix.needsAnAlias(original = context.getOriginal())) != null) {
                original = jmxOriginal;
            }
            AbstractController controller = (AbstractController)context.getController();
            AbstractController.this.lockWrite();
            try {
                ControllerContext lookup = controller.getRegisteredControllerContext(original, true);
                controller.registerControllerContext(alias, lookup);
                if (AbstractController.this.log.isTraceEnabled()) {
                    AbstractController.this.log.trace((Object)("Added alias " + alias + " for context " + context));
                }
            }
            finally {
                AbstractController.this.unlockWrite();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void uninstallAction(AliasControllerContext context) {
            AbstractController.this.lockWrite();
            try {
                Object alias = context.getAlias();
                Object jmxAlias = JMXObjectNameFix.needsAnAlias(alias);
                if (jmxAlias != null) {
                    alias = jmxAlias;
                }
                AbstractController controller = (AbstractController)context.getController();
                controller.unregisterControllerContext(alias);
                if (AbstractController.this.log.isTraceEnabled()) {
                    AbstractController.this.log.trace((Object)("Removed alias " + alias));
                }
            }
            finally {
                AbstractController.this.unlockWrite();
            }
        }
    }

    private static class InnerAliasControllerContext
    extends AbstractAliasControllerContext {
        private InnerAliasControllerContext(Object alias, String id, Object original, ControllerContextActions actions) {
            super(alias, id, original, actions);
        }
    }
}

