/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.merge.javaee.spec;

import java.util.HashSet;
import java.util.Set;
import org.jboss.metadata.javaee.spec.SecurityRoleMetaData;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.metadata.javaee.support.IdMetaDataImpl;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.merge.javaee.spec.SecurityRoleMetaDataMerger;

public class SecurityRolesMetaDataMerger {
    public static void merge(SecurityRolesMetaData dest, IdMetaDataImpl override, IdMetaDataImpl original) {
        SecurityRoleMetaData to;
        SecurityRolesMetaData roles1 = (SecurityRolesMetaData)override;
        SecurityRolesMetaData roles0 = (SecurityRolesMetaData)original;
        if (roles0 != null) {
            for (SecurityRoleMetaData sr : roles0) {
                to = (SecurityRoleMetaData)dest.get(sr.getRoleName());
                if (to != null) {
                    SecurityRoleMetaDataMerger.merge(to, sr, null);
                    continue;
                }
                dest.add((MappableMetaData)sr);
            }
        }
        if (roles1 != null) {
            for (SecurityRoleMetaData sr : roles1) {
                to = (SecurityRoleMetaData)dest.get(sr.getRoleName());
                if (to != null) {
                    SecurityRoleMetaDataMerger.merge(to, sr, null);
                    continue;
                }
                dest.add((MappableMetaData)sr);
            }
        }
        SecurityRolesMetaDataMerger.rebuildPrincipalsVersusRolesMap(dest);
    }

    private static void processSecurityRoleMetaData(SecurityRoleMetaData roleMetaData, SecurityRolesMetaData dest) {
        Set principals = roleMetaData.getPrincipals();
        if (principals == null) {
            return;
        }
        for (String principal : principals) {
            HashSet<String> roles = (HashSet<String>)dest.getPrincipalVersusRolesMap().get(principal);
            if (roles == null) {
                roles = new HashSet<String>();
                dest.getPrincipalVersusRolesMap().put(principal, roles);
            }
            roles.add(roleMetaData.getRoleName());
        }
    }

    private static void rebuildPrincipalsVersusRolesMap(SecurityRolesMetaData dest) {
        dest.clearPrincipalVersusRolesMap();
        for (SecurityRoleMetaData roleMetaData : dest) {
            SecurityRolesMetaDataMerger.processSecurityRoleMetaData(roleMetaData, dest);
        }
    }
}

